rem Clean-up
rem ========

rem del *.zip
rem del *.exe
rem del changelog.txt

copy ..\doc\changelog.txt .\

rem Alcyone x86 (installer)
rem =======================

makensis alcyone_x86.nsi

rem Alcyone x64 (installer)
rem =======================

makensis alcyone_x64.nsi

rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define ALCYONE_MAJOR_VERSION " ..\src\alcyone\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~31,1%

for /f "delims=" %%a in ('findstr /b /c:"#define ALCYONE_MINOR_VERSION " ..\src\alcyone\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~31,2%

for /f "delims=" %%a in ('findstr /b /c:"#define ALCYONE_RELEASE " ..\src\alcyone\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~26%

rem Alcyone x86 (portable)
rem ======================

rem Note: -mx=1 (fastest), -mx=3 (fast), nothing or -mx=5 (normal)

7z a -tzip -mx=1 alcyone-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\alcyone.exe
7z a -tzip -mx=1 alcyone-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\changelog.txt
7z a -tzip -mx=1 alcyone-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\license.txt
7z a -tzip -mx=1 alcyone-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\documentation.txt
7z a -tzip -mx=1 alcyone-%maj%.%min%%rel%-x86.zip portable
7z d -r alcyone-%maj%.%min%%rel%-x86.zip *.lib
7z d -r alcyone-%maj%.%min%%rel%-x86.zip *.pdb
7z d -r alcyone-%maj%.%min%%rel%-x86.zip *.exp
7z t alcyone-%maj%.%min%%rel%-x86.zip * -r

rem Alcyone x64 (portable)
rem ======================

7z a -tzip -mx=1 alcyone-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\alcyone.exe
7z a -tzip -mx=1 alcyone-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\changelog.txt
7z a -tzip -mx=1 alcyone-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\license.txt
7z a -tzip -mx=1 alcyone-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\documentation.txt
7z a -tzip -mx=1 alcyone-%maj%.%min%%rel%-x64.zip portable
7z d -r alcyone-%maj%.%min%%rel%-x64.zip *.lib
7z d -r alcyone-%maj%.%min%%rel%-x64.zip *.pdb
7z d -r alcyone-%maj%.%min%%rel%-x64.zip *.exp
7z t alcyone-%maj%.%min%%rel%-x64.zip * -r

cd ..
git archive --format=zip --prefix=GV-612/ HEAD > pack\alcyone-%maj%.%min%%rel%-src.zip
git archive --format=tar.gz --prefix=GV-612/ HEAD > pack\alcyone-%maj%.%min%%rel%-src.tar.gz

pause
