!include "MUI2.nsh"
!include "LogicLib.nsh"

;Unicode true

;SetCompress off
SetCompressor zlib
;SetCompressor /solid LZMA
;SetCompressorDictSize 8
;RequestExecutionLevel highest
RequestExecutionLevel admin

;!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\nsis3-install-alt.ico"
;!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\nsis3-uninstall.ico"
;!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\nsis3-metro.bmp"
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\orange.bmp"
!define MUI_COMPONENTSPAGE_NODESC
!define MUI_FINISHPAGE_NOAUTOCLOSE

!searchparse /file ..\src\alcyone\app_info.h '#define ALCYONE_MAJOR_VERSION ' MAJOR
!searchparse /file ..\src\alcyone\app_info.h '#define ALCYONE_MINOR_VERSION ' MINOR
!searchparse /file ..\src\alcyone\app_info.h '#define ALCYONE_RELEASE "' RELEASE '"'
!searchparse /file ..\src\alcyone\app_info.h '#define ALCYONE_COPYRIGHT "' COPYRIGHT '"'
!searchparse /file ..\src\alcyone\app_info.h '#define ALCYONE_COMPANY_URL "' COMPANY '"'

Name "Alcyone"
OutFile "alcyone-${MAJOR}.${MINOR}${RELEASE}-x64-install.exe"
;BrandingText "Grafmin"

VIAddVersionKey "ProductName" "Alcyone"
VIAddVersionKey "CompanyName" "${COMPANY}"
VIAddVersionKey "FileDescription" "Alcyone installer (x64)"
VIAddVersionKey "FileVersion" "${MAJOR}.${MINOR}.0.0"
VIAddVersionKey "ProductVersion" "${MAJOR}.${MINOR}"
VIAddVersionKey "LegalCopyright" "${COPYRIGHT}"
VIProductVersion "${MAJOR}.${MINOR}.0.0"

InstallDir "$PROGRAMFILES64\Alcyone"

;Get installation folder from registry if available
InstallDirRegKey HKCU "Software\Alcyone (x64)" ""

!define MUI_ABORTWARNING
!define MUI_FINISHPAGE_RUN $INSTDIR\alcyone.exe

!insertmacro MUI_PAGE_LICENSE "..\doc\license.txt"
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
;AutoCloseWindow true

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

!insertmacro MUI_LANGUAGE "English"

Section "Alcyone" SecAlcyone
  SectionIn RO

  SetOutPath "$INSTDIR"

  File "..\build\vc\x64\Release\alcyone.exe"
  File "..\build\vc\x64\Release\changelog.txt"
  File "..\build\vc\x64\Release\license.txt"
  File "..\build\vc\Win32\Release\documentation.txt"

  ;Store installation folder
  WriteRegStr HKCU "Software\Alcyone (x64)" "" $INSTDIR

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\uninstall.exe"
SectionEnd

Section "Start menu shortcuts" SecStart
  SetOutPath "$SMPROGRAMS\Alcyone (x64)"
  CreateShortcut "$OUTDIR\Alcyone (x64).lnk" "$INSTDIR\alcyone.exe"
  CreateShortcut "$OUTDIR\Uninstall Alcyone (x64).lnk" "$INSTDIR\uninstall.exe"
SectionEnd

Section /o "Desktop icon" SecDesktop
  SetOutPath $DESKTOP
  CreateShortcut "$OUTDIR\Alcyone (x64).lnk" "$INSTDIR\alcyone.exe"
SectionEnd

;Language strings
LangString DESC_SecAlcyone ${LANG_ENGLISH} "Alcyone core (required)."
LangString DESC_SecStart ${LANG_ENGLISH} "Start menu shortcuts."
LangString DESC_SecDesktop ${LANG_ENGLISH} "Desktop icon."

;Assign language strings to sections
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SecAlcyone} $(DESC_SecAlcyone)
!insertmacro MUI_DESCRIPTION_TEXT ${SecStart} $(DESC_SecStart)
!insertmacro MUI_DESCRIPTION_TEXT ${SecDesktop} $(DESC_SecDesktop)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"
  StrCpy $1 "alcyone.exe"

retry:
  nsProcess::_FindProcess "$1"

  Pop $R0
  ${if} $R0 = 0
    MessageBox MB_RETRYCANCEL "Alcyone is running. Close Alcyone and hit Retry." /SD IDRETRY IDCANCEL cancel
    Goto retry
  ${endif}

  Delete "$DESKTOP\Alcyone (x64).lnk"
  Delete "$SMPROGRAMS\Alcyone (x64)\Alcyone (x64).lnk"
  Delete "$SMPROGRAMS\Alcyone (x64)\Uninstall Alcyone (x64).lnk"
  RMDir /r "$SMPROGRAMS\Alcyone (x64)"

  Delete "$INSTDIR\alcyone.exe"
  Delete "$INSTDIR\changelog.txt"
  Delete "$INSTDIR\license.txt"
  Delete "$INSTDIR\documentation.txt"
  Delete "$INSTDIR\uninstall.exe"
  RMDir "$INSTDIR"

  DeleteRegKey /ifempty HKCU "Software\Alcyone (x64)"

  Goto cont

cancel:
  Abort

cont:
SectionEnd
