// Copyright (c) 2018 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "alcyone/definitions.h"
#include "alcyone/app_info.h"

#include <string.h>
#include <stdlib.h>

#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"
#include "WDL/mutex.h"

// 3:1 (ultra wide)
#define RSA_ABOUT_WIDTH 630
#define RSA_ABOUT_HEIGHT 210

#define RSA_ABOUT_RENDER 505
#define RSA_ABOUT_RENDER_MS 41

static const char *master_project =
  "\xce\x91\xce\xbb\xce\xba\xcf\x85\xcf\x8c\xce\xbd\xce\xb7";

static const char *different =
  "\xce\x93\xce\xb9\xcf\x8e\xcf\x81\xce\xb3\xce\xbf"
  "\xcf\x82\x20\xce\x92\xce\xbf\xcf\x85\xce\xb3\xce"
  "\xb9\xce\xbf\xcf\x8d\xce\xba\xce\xb1\xcf\x82";

static const char *rsa_credits[] =
{
  ALCYONE_NAME_MARKETING,
  "Version: " ALCYONE_NAKED_VERSION " (" ALCYONE_ARCH ")",
  "Build timestamp: " ALCYONE_TIMESTAMP,
  "Git commit: " ALCYONE_GIT_SHA,
  "",
  "Developed by:",
  "Giorgos Vougioukas",
  "",
  "WDL:",
  "Cockos Incorporated",
  //"(when you care enough to use the very best)",
  "",
  "Zstandard:",
  "Yann Collet",
  "Nick Terrell",
  "Przemys\xc5""\x82""aw ""Skibi\xc5""\x84""ski",
  "Facebook, Inc",
  "",
  "cJSON:",
  "Dave Gamble",
  "cJSON contributors",
  "",
  "libarchive:",
  "Tim Kientzle",
  "Martin Matuska",
  "Michihiro NAKAJIMA",
  "Joerg Sonnenberger",
  "Andres Mejia",
  "Thomas Moestl",
  "Charles M. Hannum",
  "Matt Thomas",
  "Kees Zeelenbergv",
  "Ondrej Holy",
  "Jonas Gastal",
  "Diomidis Spinellis",
  "James A. Woods",
  "Spencer Thomas",
  "Joseph Orost",
  "Nokia Corporation",
  "The NetBSD Foundation, Inc",
  "The Regents of the University of California",
  "",
  "minizip:",
  "Gilles Vollant",
  "Even Rouault",
  "Mathias Svensson",
  "",
  "zlib:",
  "Jean-loup Gailly",
  "Mark Adler",
  "",
  "Windows installer:",
  "Nullsoft Scriptable Install System (NSIS)",
  "Compressor | ZLIB",
  "",
  "Windows portable:",
  "Archive format | ZIP",
  //"",
  //"Linux tarball:",
  //"gzip",
  "",
  "Giorgos wishes to thank the following",
  "for their assistance:",
  "Asimina",
  "Manolis",
  "Justin Frankel",
  "and",
  "Snoopy",
  "",
  "Contact | email:",
  "support@grafmin.gr",
  "",
  ALCYONE_NAME_MARKETING,
  ALCYONE_COPYRIGHT
};

struct RSA_AboutWndData
{
  HWND hwnd;
  UINT msg;
  WPARAM wparam;
  LPARAM lparam;

  int x, y, w, h;
  WDL_WndSizer resize;
  LICE_IBitmap *bm;
  LICE_IFont *font;
  int font_alpha;
  int scroll_offset_y;
  int credits_height;
  bool calc;
  WDL_TypedBuf<int> disjunction;

  HANDLE thread;
  bool kill_thread;
  WDL_Mutex mutex;
};

static RSA_AboutWndData awd;

static LOGFONT lf =
{
  16, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, DEFAULT_CHARSET,
  OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH,
  "Arial"
};

static int Run()
{
  RECT r, fr;
  int half_screen, half_text;

  HWND sta = GetDlgItem(awd.hwnd, IDC_STATIC_ABOUT);

  GetWindowRect(sta, &r);
  ScreenToClient(awd.hwnd, (LPPOINT)&r);
  ScreenToClient(awd.hwnd, ((LPPOINT)&r)+1);

  GetWindowRect(sta, &fr);
  ScreenToClient(awd.hwnd, (LPPOINT)&fr);
  ScreenToClient(awd.hwnd, ((LPPOINT)&fr)+1);

  LICE_Clear(awd.bm, LICE_RGBA(0, 0, 0, 255));

  awd.font->SetBkColor(LICE_RGBA(0, 0, 0, 255));
  awd.font->SetTextColor(LICE_RGBA(192, 192, 192, awd.font_alpha));
  awd.font->SetFromHFont(CreateFontIndirect(&lf),LICE_FONT_FLAG_OWNS_HFONT);

  half_screen = (r.right - r.left) / 2;

  fr.top = RSA_ABOUT_HEIGHT - 32;
  fr.bottom = fr.top + RSA_ABOUT_HEIGHT;

  fr.top -= awd.scroll_offset_y;
  fr.bottom -= awd.scroll_offset_y;

  for (int i = 0; i < sizeof(rsa_credits) /
    sizeof(rsa_credits[0]); i++)
  {
    if (awd.disjunction.Find(i) < 0)
    {
      if (i > awd.disjunction.Get()[awd.disjunction.GetSize() - 1])
      {
        fr.top += 32;
        fr.bottom += 32;
      }
      else
      {
        fr.top += 16;
        fr.bottom += 16;
      }

      if (fr.top >= -16 && fr.top <= RSA_ABOUT_HEIGHT)
      {
        if (!strcmp(rsa_credits[i],
          "\x47\x69\x6f\x72\x67\x6f\x73\x20\x56\x6f\x75\x67\x69\x6f\x75\x6b\x61\x73")
          && (GetAsyncKeyState(VK_CONTROL) & 0x8000))
        {
          awd.font->DrawText(awd.bm, different,
            (int)strlen(different),
            &fr, DT_CALCRECT| DT_NOPREFIX | DT_SINGLELINE);
          half_text = (fr.right - fr.left) / 2;
          fr.left = 0;
          fr.left += half_screen - half_text;
          fr.right += half_screen - half_text;
          awd.font->DrawText(awd.bm, different,
            (int)strlen(different), &fr,
            LICE_DT_NEEDALPHA | LICE_DT_USEFGALPHA |
            DT_NOPREFIX | DT_SINGLELINE);
        }
        else if (!strcmp(rsa_credits[i], "\x41\x6c\x63\x79\x6f\x6e\x65")
          && (GetAsyncKeyState(VK_CONTROL) & 0x8000))
        {
          awd.font->DrawText(awd.bm, master_project,
            (int)strlen(master_project),
            &fr, DT_CALCRECT| DT_NOPREFIX | DT_SINGLELINE);
          half_text = (fr.right - fr.left) / 2;
          fr.left = 0;
          fr.left += half_screen - half_text;
          fr.right += half_screen - half_text;
          awd.font->DrawText(awd.bm, master_project,
            (int)strlen(master_project), &fr,
            LICE_DT_NEEDALPHA | LICE_DT_USEFGALPHA |
            DT_NOPREFIX | DT_SINGLELINE);
        }
        else
        {
          awd.font->DrawText(awd.bm, rsa_credits[i],
            (int)strlen(rsa_credits[i]),
            &fr, DT_CALCRECT| DT_NOPREFIX | DT_SINGLELINE);
          half_text = (fr.right - fr.left) / 2;
          fr.left = 0;
          fr.left += half_screen - half_text;
          fr.right += half_screen - half_text;
          awd.font->DrawText(awd.bm, rsa_credits[i],
            (int)strlen(rsa_credits[i]), &fr,
            LICE_DT_NEEDALPHA | LICE_DT_USEFGALPHA |
            DT_NOPREFIX | DT_SINGLELINE);
        }
      }
    }
    else
    {
      if (i == awd.disjunction.Get()[awd.disjunction.GetSize() - 1])
      {
        fr.top += RSA_ABOUT_HEIGHT - 60;
        fr.bottom += RSA_ABOUT_HEIGHT - 60;
      }
      else
      {
        fr.top += 32;
        fr.bottom += 32;
      }
    }
  }

  if (awd.calc)
  {
    awd.credits_height = fr.bottom - (RSA_ABOUT_HEIGHT / 2);
    awd.calc = false;
  }

  awd.x = r.left;
  awd.y = r.top;
  awd.w = r.right - r.left;
  awd.h = r.bottom - r.top;

  LICE_Blit(awd.bm, awd.bm, awd.x, awd.y, awd.w, awd.h, awd.bm->getWidth(),
    awd.bm->getHeight(), 1.0f, LICE_BLIT_MODE_COPY);

  if (awd.scroll_offset_y > awd.credits_height)
  {
    if (awd.font_alpha > 220) awd.font_alpha -= 1;
    else awd.font_alpha -= 20;

    if (awd.font_alpha <= 0)
    {
      awd.font_alpha = 255;
      awd.scroll_offset_y = -32;
    }
  }
  else
  {
    awd.scroll_offset_y++;
  }

  return 1;
}

static unsigned int WINAPI ThreadFunction(void *arg)
{
  awd.kill_thread = false;

  while (!awd.kill_thread)
  {
    awd.mutex.Enter();
    while (!Run());
    awd.mutex.Leave();
    Sleep(41); // 24 FPS
  }

  return 0;
}

static void DoPaint(HWND hwnd, HDC dc)
{
  BitBlt(dc, awd.x, awd.y, awd.w, awd.h, awd.bm->getDC(), 0, 0, SRCCOPY);
}

static void WM_InitDialog()
{
  g_aboutwnd = awd.hwnd;
  awd.x = 0;
  awd.y = 0;
  awd.w = 0;
  awd.h = 0;
  awd.bm = NULL;
  awd.font = NULL;
  awd.font_alpha = 255;
  awd.scroll_offset_y = 0;
  awd.credits_height = 0;
  awd.calc = true;
  awd.thread = NULL;
  awd.kill_thread = false;

  HWND s = GetDlgItem(awd.hwnd, IDC_STATIC_ABOUT);

  awd.resize.init(awd.hwnd);
  awd.resize.init_itemhwnd(s);

  int x = GetPrivateProfileInt(ALCYONE_NAME, "about_wnd_x", 0, g_inipath.Get());
  int y = GetPrivateProfileInt(ALCYONE_NAME, "about_wnd_y", 50, g_inipath.Get());
  int w = RSA_ABOUT_WIDTH;
  int h = RSA_ABOUT_HEIGHT;
  SetWindowPos(awd.hwnd, NULL, x, y, w, h, SWP_NOZORDER | SWP_NOACTIVATE);

  for (int i = 0; i < sizeof(rsa_credits) /
    sizeof(rsa_credits[0]); i++)
  {
    if (!strcmp(rsa_credits[i], "")) awd.disjunction.Add(&i, 1);
  }

  awd.bm = new LICE_SysBitmap(w, h);
  awd.font = new LICE_CachedFont();

  awd.x = x;
  awd.y = y;
  awd.w = w;
  awd.h = h;
  LICE_Clear(awd.bm, LICE_RGBA(0, 0, 0, 255));

  SetTimer(awd.hwnd, RSA_ABOUT_RENDER, RSA_ABOUT_RENDER_MS, NULL);
}

static void WM_Paint()
{
#if _WIN32
  PAINTSTRUCT ps;
  HWND sta = GetDlgItem(awd.hwnd, IDC_STATIC_ABOUT);
  HDC dc = BeginPaint(sta, &ps);
  DoPaint(awd.hwnd, dc);
  EndPaint(sta, &ps);
#endif
}

static void WM_Timer()
{
  if (awd.wparam == RSA_ABOUT_RENDER)
  {
    Run();
#if defined(_WIN32)
    InvalidateRect(awd.hwnd, NULL, FALSE);
#else
    {
      HWND h = GetDlgItem(awd.hwnd, IDC_STATIC_ABOUT);
      HDC dc = GetWindowDC(h);
      DoPaint(awd.hwnd,dc);
      ReleaseDC(h,dc);
      //SWELL_FlushWindow(h); // for macos
    }
#endif
  }
}

static void WM_Size()
{
  if (awd.wparam != SIZE_MINIMIZED)
  {
    awd.resize.onResize();
  }
}

static void WM_Destroy()
{
  KillTimer(awd.hwnd, RSA_ABOUT_RENDER);

  RECT r;
  GetWindowRect(awd.hwnd, &r);

  WDL_FastString rleft, rtop;
  rleft.SetFormatted(32, "%d", r.left);
  rtop.SetFormatted(32, "%d", r.top);

  WritePrivateProfileString(ALCYONE_NAME,"about_wnd_x", rleft.Get(), g_inipath.Get());
  WritePrivateProfileString(ALCYONE_NAME,"about_wnd_y", rtop.Get(), g_inipath.Get());

  delete awd.bm;
  awd.bm = NULL;
  delete awd.font;
  awd.font = NULL;
  awd.font_alpha = 255;
  awd.scroll_offset_y = 0;
  awd.credits_height = 0;
  awd.calc = true;
  awd.disjunction.Resize(0, true);
  awd.hwnd = NULL;

  g_aboutwnd = NULL;
}

static void WM_Command()
{
  switch(LOWORD(awd.wparam))
  {
  case IDCANCEL:
    {
      DestroyWindow(awd.hwnd);
    }
    break;
  }
}

WDL_DLGRET RSA_AboutWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  awd.hwnd = hwnd;
  awd.msg = msg;
  awd.wparam = wparam;
  awd.lparam = lparam;

  switch (msg)
  {
    case WM_INITDIALOG: WM_InitDialog(); break;
    case WM_PAINT: WM_Paint(); break;
    case WM_TIMER: WM_Timer(); break;
    case WM_SIZE: WM_Size(); break;
    case WM_ERASEBKGND: return 1; break;
    case WM_DESTROY: WM_Destroy(); break;
    case WM_COMMAND: WM_Command(); break;
  }

  return 0;
}
