// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "alcyone/definitions.h"
#include "alcyone/app_info.h"
#include "alcyone/editor.h"

#include "WDL/wingui/wndsize.h"

#define PREVIEW_EDITOR_TIMER 100
#define PREVIEW_EDITOR_TIMER_MS 50

struct RSA_ChangelogWndData
{
  RSA_ChangelogWndData()
    : preview(&curses_ctx)
  {}
  HWND hwnd;
  UINT msg;
  WPARAM wparam;
  LPARAM lparam;
  win32CursesCtx curses_ctx;
  WDL_WndSizer resize;
  RSA_PreviewEditor preview;
};

static RSA_ChangelogWndData cwd;

static void WM_InitDialog()
{
  g_changelogwnd = cwd.hwnd;
  HWND cc = GetDlgItem(cwd.hwnd, IDC_CUSTOM1);
  curses_setWindowContext(cc, &cwd.curses_ctx);

  cwd.resize.init(cwd.hwnd);
  cwd.resize.init_itemhwnd(cc, 0.0f, 0.0f, 1.0f, 1.0f);

  int x = GetPrivateProfileInt(ALCYONE_NAME, "changelog_wnd_x", 0, g_inipath.Get());
  int y = GetPrivateProfileInt(ALCYONE_NAME, "changelog_wnd_y", 50, g_inipath.Get());
#if defined(_WIN32)
  SetWindowPos(cwd.hwnd, NULL, x, y, 620, 505, SWP_NOZORDER | SWP_NOACTIVATE);
#else
  SetWindowPos(cwd.hwnd, NULL, x, y, 680, 505, SWP_NOZORDER | SWP_NOACTIVATE);
#endif

  WDL_FastString changelog;
  changelog.Set(g_modpath.Get());
  changelog.Append("changelog.txt");

  cwd.preview.SetParent(cwd.hwnd);
  cwd.preview.init(changelog.Get());
  cwd.preview.draw();
  cwd.preview.setCursor();

  SetTimer(cwd.hwnd, PREVIEW_EDITOR_TIMER, PREVIEW_EDITOR_TIMER_MS, NULL);

  SetFocus(cc);
}

static void WM_Timer()
{
  if (cwd.wparam == PREVIEW_EDITOR_TIMER)
  {
    cwd.preview.RunEditor();
  }
}

static void WM_Destroy()
{
  cwd.preview.ClearText();
  KillTimer(cwd.hwnd, PREVIEW_EDITOR_TIMER);

  RECT r;
  GetWindowRect(cwd.hwnd, &r);

  WDL_FastString rleft, rtop;
  rleft.SetFormatted(32, "%d", r.left);
  rtop.SetFormatted(32, "%d", r.top);

  WritePrivateProfileString(ALCYONE_NAME,"changelog_wnd_x", rleft.Get(), g_inipath.Get());
  WritePrivateProfileString(ALCYONE_NAME,"changelog_wnd_y", rtop.Get(), g_inipath.Get());

  g_changelogwnd = NULL;
}

static void WM_Size()
{
  if (cwd.wparam != SIZE_MINIMIZED)
  {
    cwd.resize.onResize();
  }
}

static void WM_Command()
{
  switch(LOWORD(cwd.wparam))
  {
  case IDCANCEL:
    {
      DestroyWindow(cwd.hwnd);
    }
    break;
  }
}

static void WM_SysCommand()
{
  if (LOWORD(cwd.wparam) == SC_CLOSE)
  {
    DestroyWindow(cwd.hwnd);
  }
}

WDL_DLGRET RSA_ChangelogWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  cwd.hwnd = hwnd;
  cwd.msg = msg;
  cwd.wparam = wparam;
  cwd.lparam = lparam;

  switch (msg)
  {
  case WM_INITDIALOG: WM_InitDialog(); break;
  case WM_TIMER: WM_Timer(); break;
  case WM_DESTROY: WM_Destroy(); break;
  case WM_SIZE: WM_Size(); break;
  case WM_COMMAND: WM_Command(); break;
  case WM_SYSCOMMAND: WM_SysCommand(); break;
  }

  return 0;
}
