// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _ALCYONE_PREFERENCES_H_
#define _ALCYONE_PREFERENCES_H_

#include "third_party/cJSON/cJSON.h"

#include <string.h>
#include <stdlib.h>

#include "WDL/wdlstring.h"

class RSA_Preferences
{
public:
  RSA_Preferences();
  ~RSA_Preferences();

  void Create();
  void Open(bool default_file = false);

  bool Parse(bool default_file = false);
  const char *GetParseError() const { return m_err.Get(); }

  void SetRelaunch(bool enable) { m_relaunch = enable; }
  bool WantRelaunch() const { return m_relaunch; }

  bool WantCurses() const;
  bool WantCursesRightFocus() const;
  bool WantPreserveCurrentDirectory() const;
  int GetZstdCompressionLevel() const;
  bool WantZstdKeepTarball() const;
  int GetZstdChecksumFlag() const;
  int GetZlibCompressionLevel() const;
  int GetActionAfterCompression() const;
  int GetActionAfterDecompression() const;

private:
  cJSON *m_pf;
  WDL_FastString m_err;
  bool m_relaunch;
};

#endif // _ALCYONE_PREFERENCES_H_
