// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "alcyone/definitions.h"
#include "alcyone/client.h"
#include "alcyone/app_info.h"

#include "WDL/wingui/wndsize.h"

#define RSA_ZSTD_PROGRESS 101
#define RSA_ZSTD_PROGRESS_MS 50

struct RSA_ProgressWndData
{
  HWND hwnd;
  UINT msg;
  WPARAM wparam;
  LPARAM lparam;
  int x, y;
  WDL_WndSizer resize;
};

static RSA_ProgressWndData pwd;

static void WM_InitDialog()
{
  g_progwnd = pwd.hwnd;

  pwd.x = GetPrivateProfileInt(ALCYONE_NAME, "progress_wnd_x", 50, g_inipath.Get());
  pwd.y = GetPrivateProfileInt(ALCYONE_NAME, "progress_wnd_y", 50, g_inipath.Get());
  SetWindowPos(pwd.hwnd, NULL, pwd.x, pwd.y, 0, 0, SWP_NOSIZE | SWP_NOACTIVATE);

  ShowWindow(pwd.hwnd, SW_SHOW);
  SetTimer(pwd.hwnd, RSA_ZSTD_PROGRESS, RSA_ZSTD_PROGRESS_MS, NULL);
}

static int WM_Destroy()
{
  KillTimer(pwd.hwnd, RSA_ZSTD_PROGRESS);

  RECT r;
  GetWindowRect(pwd.hwnd, &r);

  WDL_FastString xstr, ystr, wstr, hstr;
  xstr.SetFormatted(32, "%d", r.left);
  ystr.SetFormatted(32, "%d", r.top);
  //wstr.SetFormatted(32, "%d", r.right - r.left);
  //hstr.SetFormatted(32, "%d", r.bottom - r.top);


  WritePrivateProfileString(ALCYONE_NAME, "progress_wnd_x", xstr.Get(), g_inipath.Get());
  WritePrivateProfileString(ALCYONE_NAME, "progress_wnd_y", ystr.Get(), g_inipath.Get());
  //WritePrivateProfileString(ALCYONE_NAME, "load_wnd_w", wstr.Get(), g_inipath.Get());
  //WritePrivateProfileString(ALCYONE_NAME, "load_wnd_h", hstr.Get(), g_inipath.Get());

  g_progwnd = NULL;
  return 0;
}

static void WM_Timer()
{
  if (pwd.wparam == RSA_ZSTD_PROGRESS)
  {
    SendMessage(GetDlgItem(pwd.hwnd, IDC_PROGRESS1), PBM_SETRANGE, 0, MAKELPARAM(0, 100));

    if (g_client->IsInProgress())
    {
      int perc1, perc2;
      WDL_FastString stage;
      g_client->Progress(&perc1, &perc2, &stage);
      SendMessage(GetDlgItem(pwd.hwnd, IDC_PROGRESS1), PBM_SETPOS, perc1, 0);
      SendMessage(GetDlgItem(pwd.hwnd, IDC_PROGRESS2), PBM_SETPOS, perc2, 0);
      SetWindowText(pwd.hwnd, stage.Get());
    }
  }
}

static void WM_SysCommand()
{
  if (pwd.wparam == SC_CLOSE)
  {
    if (g_client->IsInProgress()) g_client->AbortProgress();
  }
}

static void WM_Command()
{
  switch(LOWORD(pwd.wparam))
  {
  case IDCANCEL:
    {
      if (g_client->IsInProgress()) g_client->AbortProgress();
      EndDialog(pwd.hwnd, 0);
    }
    break;
  }
}

WDL_DLGRET RSA_ProgressWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  pwd.hwnd = hwnd;
  pwd.msg = msg;
  pwd.wparam = wparam;
  pwd.lparam = lparam;

  switch(msg)
  {
    case WM_INITDIALOG: WM_InitDialog(); break;
    //case WM_SYSCOMMAND: WM_SysCommand(); break;
    //case WM_CLOSE: return 0; break;
    //case WM_SIZE: WM_Size(); break;
    //case WM_MOVE: WM_Move(); break;
    case WM_DESTROY: WM_Destroy(); break;
    case WM_COMMAND: WM_Command(); break;
    case WM_TIMER: WM_Timer(); break;
  }

  return 0;
}
