// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _ALCYONE_INFO_H_
#define _ALCYONE_INFO_H_

#include <string.h>

#include "alcyone/git_sha1.h"

#define ALCYONE_MAJOR_VERSION 1
#define ALCYONE_MINOR_VERSION 16

#define ALCYONE_RELEASE ""
#define ALCYONE_SPECIAL ""

#define ALCYONE_NAME "alcyone"
#define ALCYONE_NAME_MARKETING "Alcyone"
#define ALCYONE_COMPANY_URL "https://www.grafmin.gr/"
#define ALCYONE_WEBSITE_URL "https://www.grafmin.gr/alcyone"
#define ALCYONE_COPYRIGHT "Copyright (c) 2022-2025 Giorgos Vougioukas"

#define ALCYONE_STRINGIFY_HELPER(x) #x
#define ALCYONE_STRINGIFY(x) ALCYONE_STRINGIFY_HELPER(x)

#define ALCYONE_NAKED_VERSION \
  ALCYONE_STRINGIFY(ALCYONE_MAJOR_VERSION) \
  "." ALCYONE_STRINGIFY(ALCYONE_MINOR_VERSION) \
  ALCYONE_RELEASE ALCYONE_SPECIAL

#define ALCYONE_FULL_VERSION \
  ALCYONE_NAME_MARKETING " " ALCYONE_NAKED_VERSION

#define ALCYONE_GIT_SHA ALCYONE_STRINGIFY(GIT_SHA1)

#define ALCYONE_TIMESTAMP __DATE__ " " __TIME__

inline bool IsStableRelease()
{
  if (strlen(ALCYONE_RELEASE)) return false;

  return true;
}

#if defined(_MSC_VER)
  #if defined(_M_AMD64) || defined(_M_X64)
    #define ALCYONE_ARCH "x64"
  #elif defined(_M_IX86)
    #define ALCYONE_ARCH "x86"
  #else
    #define ALCYONE_ARCH "unk"
  #endif
#elif defined(__linux__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define ALCYONE_ARCH "amd64"
  #elif defined(__i386__)
    #define ALCYONE_ARCH "i686"
  #else
    #define ALCYONE_ARCH "unk"
  #endif
#elif defined(__APPLE__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define ALCYONE_ARCH "x86-64"
  #elif defined(__i386__)
    #define ALCYONE_ARCH "i386"
  #else
    #define ALCYONE_ARCH "unk"
  #endif
#endif

#endif // _ALCYONE_INFO_H_
