// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _ALCYONE_DEFINITIONS_H_
#define _ALCYONE_DEFINITIONS_H_

#if defined(_WIN32)
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <process.h>
#else
#include "WDL/swell/swell.h"
#include "WDL/swell/swell-functions.h"
#endif

#include "alcyone/res/resource.h"

#include "WDL/wdltypes.h"
#include "WDL/win32_utf8.h"
#include "WDL/wdlstring.h"

#ifndef WM_MOUSEWHEEL
#define WM_MOUSEWHEEL 0x020A
#endif

#ifndef WM_MOUSEHWHEEL
#define WM_MOUSEHWHEEL 0x020E
#endif

#if defined(__linux__)
extern bool has_requested_quit;
#endif

class RSA_Preferences;
class RSA_Client;

extern HINSTANCE g_inst;

extern WDL_FastString g_modpath;
extern WDL_FastString g_setpath;
extern WDL_FastString g_inipath;

extern UINT g_scroll_message;

extern RSA_Preferences *g_preferences;
extern RSA_Client *g_client;

extern HWND g_mainwnd;
extern HWND g_licwnd;
extern HWND g_changelogwnd;
extern HWND g_prefwnd;
extern HWND g_aboutwnd;
extern HWND g_progwnd;

extern WDL_DLGRET RSA_MainWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET RSA_AboutWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET RSA_LicenseWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET RSA_ChangelogWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET RSA_PreferencesWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET RSA_ProgressWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern int RSA_ProcessMessage(MSG *msg);
extern void RSA_RunMessageLoop();

#endif // _ALCYONE_DEFINITIONS_H_
