// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "alcyone/definitions.h"
#include "alcyone/app_info.h"

#include "WDL/fileread.h"
#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"

struct RSA_LicenseWndData
{
  HWND hwnd;
  UINT msg;
  WPARAM wparam;
  LPARAM lparam;
  WDL_WndSizer resize;
};

static RSA_LicenseWndData lwd;

static void WM_InitDialog()
{
  g_licwnd = lwd.hwnd;
  HWND s = GetDlgItem(lwd.hwnd, IDC_EDIT_LICENSE);

  lwd.resize.init(lwd.hwnd);
  lwd.resize.init_itemhwnd(s);

  int x = GetPrivateProfileInt(ALCYONE_NAME, "license_wnd_x", 0, g_inipath.Get());
  int y = GetPrivateProfileInt(ALCYONE_NAME, "license_wnd_y", 50, g_inipath.Get());
  SetWindowPos(lwd.hwnd, NULL, x, y, 400, 400, SWP_NOZORDER | SWP_NOACTIVATE);

  WDL_FastString lpath(g_modpath.Get());
  lpath.Append("license.txt");
  WDL_FileRead lfile(lpath.Get());

  WDL_String ltext;
  ltext.SetLen((int)lfile.GetSize());
  lfile.Read(ltext.Get(), (int)lfile.GetSize());

  SetFocus(s);

  SetDlgItemText(lwd.hwnd, IDC_EDIT_LICENSE, ltext.Get());
  SendMessage(s, EM_SETSEL, -1, 0);
}

#ifdef _WIN32
static INT_PTR WM_CtlColorStatic()
{
  if((HWND)lwd.lparam == GetDlgItem(lwd.hwnd, IDC_EDIT_LICENSE))
  {
    SetBkMode((HDC)lwd.wparam, TRANSPARENT);
    SetTextColor((HDC)lwd.wparam, RGB(0, 0, 0));
    return (INT_PTR)((HBRUSH)GetStockObject(WHITE_BRUSH));
    // if edit control is in dialog procedure change LRESULT to INT_PTR
  }
  else // this is some other static control, do not touch it.
  {
    return DefWindowProc(lwd.hwnd, lwd.msg, lwd.wparam, lwd.lparam);
  }
}
#endif

static void WM_Destroy()
{
  RECT r;
  GetWindowRect(lwd.hwnd, &r);

  WDL_FastString rleft, rtop;
  rleft.SetFormatted(32, "%d", r.left);
  rtop.SetFormatted(32, "%d", r.top);

  WritePrivateProfileString(ALCYONE_NAME,"license_wnd_x", rleft.Get(), g_inipath.Get());
  WritePrivateProfileString(ALCYONE_NAME,"license_wnd_y", rtop.Get(), g_inipath.Get());

  g_licwnd = NULL;
}

static void WM_Size()
{
  if (lwd.wparam != SIZE_MINIMIZED)
  {
    lwd.resize.onResize();
  }
}

static void WM_Command()
{
  switch(LOWORD(lwd.wparam))
  {
  case IDCANCEL:
    {
      DestroyWindow(lwd.hwnd);
    }
    break;
  }
}

WDL_DLGRET RSA_LicenseWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  lwd.hwnd = hwnd;
  lwd.msg = msg;
  lwd.wparam = wparam;
  lwd.lparam = lparam;

  switch (msg)
  {
  case WM_INITDIALOG: WM_InitDialog(); break;
#ifdef _WIN32
    case WM_CTLCOLORSTATIC: WM_CtlColorStatic(); break;
#endif
  case WM_DESTROY: WM_Destroy(); break;
  case WM_SIZE: WM_Size(); break;
  case WM_COMMAND: WM_Command(); break;
  }

  return 0;
}
