// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "alcyone/definitions.h"

int RSA_ProcessMessage(MSG *msg)
{
  if (msg->hwnd == g_mainwnd || IsChild(g_mainwnd, msg->hwnd))
  {
    if (msg->wParam == VK_CONTROL &&
        (msg->message == WM_KEYDOWN ||
         msg->message == WM_KEYUP))
    {
      if (GetCapture() == g_mainwnd)
      {
        //InvalidateRect(g_mainwnd, NULL, FALSE);
      }
    }

    //if (msg->message == WM_MOUSEWHEEL)
    //{
    //  SendMessage(msg->hwnd, WM_MOUSEWHEEL, msg->wParam, msg->lParam);

    //  return 1;
    //}

    if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
    {
      if (msg->lParam & FVIRTKEY)
      {
        if (msg->wParam == VK_F1)
        {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd, WM_COMMAND, ID_HELP_ABOUTALCYONE, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F2)
        {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd, WM_COMMAND, ID_HELP_CHANGELOG, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F3)
        {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd, WM_COMMAND, ID_HELP_VERSION, 0);
            }

            return 1;
          }
        }
      } // FVIRTKEY

      if (msg->wParam == 'Z')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd, WM_COMMAND, ID_FILE_COMPRESSFOLDER, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'Z')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd, WM_COMMAND, ID_FILE_COMPRESSFILE, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'D')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd, WM_COMMAND, ID_FILE_DECOMPRESSFILE, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'Q')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd, WM_COMMAND, ID_FILE_EXIT, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == '0')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd, WM_COMMAND, ID_OPTIONS_ZLIB, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == '1')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd, WM_COMMAND, ID_OPTIONS_ZSTD, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'P')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd, WM_COMMAND, ID_OPTIONS_PREFERENCES, 0);
          }

          return 1;
        }
      }
    }
  }

  return 0;
}

void RSA_RunMessageLoop()
{
#if defined(_WIN32)

  for (;;) // Justin Frankel in the loop
  {
    MSG msg = { 0, };
    int vvv = GetMessage(&msg, NULL, 0, 0);

    if (!vvv)
    {
      break;
    }

    if (vvv < 0)
    {
      Sleep(10);
      continue;
    }

    if (!msg.hwnd)
    {
      DispatchMessage(&msg);
      continue;
    }

    vvv = RSA_ProcessMessage(&msg);

    if (vvv > 0)
    {
      continue;
    }

    if (IsDialogMessage(g_mainwnd, &msg))
    {
      continue;
    }

    if (IsDialogMessage(g_changelogwnd, &msg))
    {
      continue;
    }

    if (IsDialogMessage(g_licwnd, &msg))
    {
      continue;
    }

    if (IsDialogMessage(g_aboutwnd, &msg))
    {
      continue;
    }

    if (IsDialogMessage(g_prefwnd, &msg))
    {
      continue;
    }

    if (IsDialogMessage(g_progwnd, &msg))
    {
      continue;
    }

    HWND parent = NULL;
    HWND temp = msg.hwnd;

    do
    {
      if (GetClassLong(temp, GCW_ATOM) == (INT)32770)
      {
        parent = temp;

        if (!(GetWindowLong(temp, GWL_STYLE) &WS_CHILD))
        {
          break;  // not a child, exit
        }
      }
    }
    while (temp = GetParent(temp));

    if (parent && IsDialogMessage(parent, &msg))
    {
      continue;
    }

    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }

#else

  for (;;)
  {
    MSG msg = { 0, };
    int x = RSA_ProcessMessage(&msg);

    if (x == 0)
    {
      break;
    }
  }

#endif
}
