// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "alcyone/definitions.h"
#include "alcyone/preferences.h"
#include "alcyone/editor.h"
#include "alcyone/app_info.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"

#define RSA_CURSES_PREFERENCES_TIMER 100
#define RSA_CURSES_PREFERENCES_TIMER_MS 50

struct RSA_PreferencesWndData
{
  RSA_PreferencesWndData()
    : preview(&preview_ctx)
    , editor(&editor_ctx)
  {}
  HWND hwnd;
  UINT msg;
  WPARAM wparam;
  LPARAM lparam;
  win32CursesCtx preview_ctx;
  win32CursesCtx editor_ctx;
  WDL_WndSizer resize;
  WDL_VWnd_Painter painter;
  RSA_PreviewEditor preview;
  RSA_PreferencesEditor editor;
};

static RSA_PreferencesWndData pwd;

static void WM_InitDialog()
{
  g_prefwnd = pwd.hwnd;
  HWND ccp = GetDlgItem(pwd.hwnd, IDC_CUSTOM3);
  HWND cce = GetDlgItem(pwd.hwnd, IDC_CUSTOM2);
  curses_setWindowContext(ccp, &pwd.preview_ctx);
  curses_setWindowContext(cce, &pwd.editor_ctx);

  pwd.resize.init(pwd.hwnd);
  pwd.resize.init_itemhwnd(ccp, 0.0f, 0.0f, 0.5f, 1.0f);
  pwd.resize.init_itemhwnd(cce, 0.5f, 0.0f, 1.0f, 1.0f);

  int x = GetPrivateProfileInt(ALCYONE_NAME, "preferences_wnd_x", 0, g_inipath.Get());
  int y = GetPrivateProfileInt(ALCYONE_NAME, "preferences_wnd_y", 50, g_inipath.Get());
  int w = GetPrivateProfileInt(ALCYONE_NAME, "preferences_wnd_w", 1120, g_inipath.Get());
  int h = GetPrivateProfileInt(ALCYONE_NAME, "preferences_wnd_h", 720, g_inipath.Get());
  SetWindowPos(pwd.hwnd, NULL, x, y, w, h, SWP_NOZORDER | SWP_NOACTIVATE);

  WDL_FastString defpref;
  defpref.Set(g_setpath.Get());
  defpref.Append("preferences-default.txt");

  WDL_FastString usrpref;
  usrpref.Set(g_setpath.Get());
  usrpref.Append("preferences.txt");

  pwd.preview.SetParent(pwd.hwnd);
  pwd.preview.init(defpref.Get());
  pwd.preview.draw();
  pwd.preview.setCursor();

  pwd.editor.SetParent(pwd.hwnd);
  pwd.editor.init(usrpref.Get());
  pwd.editor.draw();
  pwd.editor.setCursor();

  SetTimer(pwd.hwnd, RSA_CURSES_PREFERENCES_TIMER, RSA_CURSES_PREFERENCES_TIMER_MS, NULL);

  bool crf = g_preferences->WantCursesRightFocus();
  if (crf) SetFocus(cce); else SetFocus(ccp);
}

static void WM_Timer()
{
  if (pwd.wparam == RSA_CURSES_PREFERENCES_TIMER)
  {
    pwd.preview.RunEditor();
    pwd.editor.RunEditor();
  }
}

static void WM_Destroy()
{
  pwd.preview.ClearText();
  pwd.editor.ClearText();
  KillTimer(pwd.hwnd, RSA_CURSES_PREFERENCES_TIMER);

  RECT r;
  GetWindowRect(pwd.hwnd, &r);

  WDL_FastString rleft, rtop, rwidth, rheight;
  rleft.SetFormatted(32, "%d", r.left);
  rtop.SetFormatted(32, "%d", r.top);
  rwidth.SetFormatted(32, "%d", r.right - r.left);
  rheight.SetFormatted(32, "%d", r.bottom - r.top);

  WritePrivateProfileString(ALCYONE_NAME,"preferences_wnd_x", rleft.Get(), g_inipath.Get());
  WritePrivateProfileString(ALCYONE_NAME,"preferences_wnd_y", rtop.Get(), g_inipath.Get());
  WritePrivateProfileString(ALCYONE_NAME,"preferences_wnd_w", rwidth.Get(), g_inipath.Get());
  WritePrivateProfileString(ALCYONE_NAME,"preferences_wnd_h", rheight.Get(), g_inipath.Get());

  g_prefwnd = NULL;
}

static void WM_Size()
{
  if (pwd.wparam != SIZE_MINIMIZED)
  {
    pwd.resize.onResize();
  }
}

static void WM_Command()
{
  switch(LOWORD(pwd.wparam))
  {
    case IDCANCEL:
    {
      DestroyWindow(pwd.hwnd);
    }
    break;
  }
}

static void WM_SysCommand()
{
  if (LOWORD(pwd.wparam) == SC_CLOSE)
  {
    DestroyWindow(pwd.hwnd);
  }
}

static void WM_ToggleFocus()
{
  HWND ccp = GetDlgItem(pwd.hwnd, IDC_CUSTOM3);
  HWND cce = GetDlgItem(pwd.hwnd, IDC_CUSTOM2);
  if (GetFocus() == ccp) SetFocus(cce); else SetFocus(ccp);
}

static void WM_Paint()
{
  RECT r;
  GetClientRect(pwd.hwnd, &r);

  pwd.painter.PaintBegin(pwd.hwnd, RGB(255, 255, 128));
  pwd.painter.PaintEnd();
}

WDL_DLGRET RSA_PreferencesWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  pwd.hwnd = hwnd;
  pwd.msg = msg;
  pwd.wparam = wparam;
  pwd.lparam = lparam;

  switch (msg)
  {
    case WM_INITDIALOG: WM_InitDialog(); break;
    case WM_TIMER: WM_Timer(); break;
    case WM_DESTROY: WM_Destroy(); break;
    case WM_SIZE: WM_Size(); break;
    case WM_COMMAND: WM_Command(); break;
    case WM_SYSCOMMAND: WM_SysCommand(); break;
    case WM_TOGGLE_FOCUS: WM_ToggleFocus(); break;
    case WM_PAINT: WM_Paint(); break;
  }

  return 0;
}
