rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define EUTERPE_MAJOR_VERSION " ..\..\src\euterpe\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~31,1%

for /f "delims=" %%a in ('findstr /b /c:"#define EUTERPE_MINOR_VERSION " ..\..\src\euterpe\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~31,2%

for /f "delims=" %%a in ('findstr /b /c:"#define EUTERPE_RELEASE " ..\..\src\euterpe\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~26%

rmdir /s /q build
rmdir /s /q src
del /s /q euterpe-gen*.zip

mkdir build
mkdir build\vc
mkdir build\linux
mkdir src
mkdir src\WDL-GV
mkdir src\euterpe
mkdir src\euterpe_gen
mkdir lib
mkdir lib\ffmpeg-linux-amd64
mkdir lib\ffmpeg-linux-i686
mkdir lib\ffmpeg-win-x64
mkdir lib\ffmpeg-win-x86
mkdir src\third_party
mkdir src\third_party\ffmpeg
mkdir src\third_party\compat

xcopy /y /s ..\..\src\WDL-GV src\WDL-GV
xcopy /y ..\..\src\euterpe\euterpe_plugin_public.h src\euterpe
xcopy /y ..\..\src\euterpe\sample_format.h src\euterpe
xcopy /y ..\..\build\vc\euterpe-gen.* build\vc
xcopy /y ..\..\build\linux\makefile_euterpe_gen.mk build\linux
xcopy /y ..\..\build\linux\Makefile build\linux
xcopy /y /s ..\..\src\euterpe_gen src\euterpe_gen
xcopy /y /s ..\..\lib\ffmpeg-linux-amd64 lib\ffmpeg-linux-amd64\
xcopy /y /s ..\..\lib\ffmpeg-linux-i686 lib\ffmpeg-linux-i686\
xcopy /y /s ..\..\lib\ffmpeg-win-x86 lib\ffmpeg-win-x86\
xcopy /y /s ..\..\lib\ffmpeg-win-x64 lib\ffmpeg-win-x64\
xcopy /y /s ..\..\src\third_party\ffmpeg src\third_party\ffmpeg\
xcopy /y /s ..\..\src\third_party\compat src\third_party\compat\

7z a -tzip -mx=1 euterpe-gen-%maj%.%min%%rel%-src.zip build
7z a -tzip -mx=1 euterpe-gen-%maj%.%min%%rel%-src.zip src
7z a -tzip -mx=1 euterpe-gen-%maj%.%min%%rel%-src.zip lib
7z a -tzip -mx=1 euterpe-gen-%maj%.%min%%rel%-src.zip README.txt
7z d -r euterpe-gen-%maj%.%min%%rel%-src.zip build\vc\Win32
7z d -r euterpe-gen-%maj%.%min%%rel%-src.zip build\vc\x64
7z d -r euterpe-gen-%maj%.%min%%rel%-src.zip *.o
7z t euterpe-gen-%maj%.%min%%rel%-src.zip * -r

rmdir /s /q build
rmdir /s /q src
rmdir /s /q lib

pause
