// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_ABOUT_WINDOW_H_
#define _EUTERPE_ABOUT_WINDOW_H_

#include "euterpe/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"
#include "WDL/mutex.h"

class RSE_AboutWnd
{
public:
  RSE_AboutWnd();
  ~RSE_AboutWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_AboutWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET AboutWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void DoPaint(HWND hwnd, HDC dc);
  static unsigned int WINAPI ThreadFunction(void *arg);
  int Run();

  HWND m_hwnd;
  RSE_MainWnd *m_par;
  int m_x, m_y, m_w, m_h;

  WDL_WndSizer m_resize;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  int m_font_alpha;
  int m_scroll_offset_y;
  int m_credits_height;
  bool m_calc;
  WDL_TypedBuf<int> m_break;

  HANDLE m_thread;
  bool m_kill_thread;
  WDL_Mutex m_mutex;
};

#endif // _EUTERPE_ABOUT_WINDOW_H_
