// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_INFO_H_
#define _EUTERPE_INFO_H_

#include <string.h>

#include "euterpe/git_sha1.h"

#define EUTERPE_MAJOR_VERSION 2
#define EUTERPE_MINOR_VERSION 20

#define EUTERPE_RELEASE ""
#define EUTERPE_SPECIAL ""

#define EUTERPE_NAME "euterpe"
#define EUTERPE_NAME_MARKETING "Euterpe"
#define EUTERPE_COMPANY_URL "https://www.grafmin.gr/"
#define EUTERPE_WEBSITE_URL "https://www.grafmin.gr/euterpe"
#define EUTERPE_COPYRIGHT "Copyright (c) 2020-2025 Giorgos Vougioukas"

#define EUTERPE_STRINGIFY_HELPER(x) #x
#define EUTERPE_STRINGIFY(x) EUTERPE_STRINGIFY_HELPER(x)

#define EUTERPE_NAKED_VERSION \
  EUTERPE_STRINGIFY(EUTERPE_MAJOR_VERSION) \
  "." EUTERPE_STRINGIFY(EUTERPE_MINOR_VERSION) \
  EUTERPE_RELEASE EUTERPE_SPECIAL

#define EUTERPE_FULL_VERSION \
  EUTERPE_NAME_MARKETING " " EUTERPE_NAKED_VERSION

#define EUTERPE_GIT_SHA EUTERPE_STRINGIFY(GIT_SHA1)

#define EUTERPE_TIMESTAMP __DATE__ " " __TIME__

inline bool IsStableRelease()
{
  if (strlen(EUTERPE_RELEASE)) return false;

  return true;
}

#if defined(_MSC_VER)
  #if defined(_M_AMD64) || defined(_M_X64)
    #define EUTERPE_ARCH "x64"
  #elif defined(_M_IX86)
    #define EUTERPE_ARCH "x86"
  #else
    #define EUTERPE_ARCH "unk"
  #endif
#elif defined(__linux__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define EUTERPE_ARCH "amd64"
  #elif defined(__i386__)
    #define EUTERPE_ARCH "i686"
  #else
    #define EUTERPE_ARCH "unk"
  #endif
#elif defined(__APPLE__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define EUTERPE_ARCH "x86-64"
  #elif defined(__i386__)
    #define EUTERPE_ARCH "i386"
  #else
    #define EUTERPE_ARCH "unk"
  #endif
#endif

#endif // _EUTERPE_INFO_H_
