// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_ARTWORK_WINDOW_H_
#define _EUTERPE_ARTWORK_WINDOW_H_

#include "euterpe/definitions.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/wdlstring.h"

class RSE_ArtworkWnd
{
public:
  RSE_ArtworkWnd();
  ~RSE_ArtworkWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_ArtworkWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET ArtworkWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void LoadArtwork(const char *filename);
  void DoPaint(HWND hwnd, HDC dc);
  void Update();

  HWND m_hwnd;
  int m_x, m_y, m_w, m_h;
  HMENU m_context_menu;
  LICE_IBitmap *m_bm;
  LICE_IBitmap *m_bmp;
  WDL_WndSizer m_resize;
  WDL_FastString m_last_fn;
};

#endif // _EUTERPE_ARTWORK_WINDOW_H_
