// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_BUFFER_QUEUE_H_
#define _EUTERPE_BUFFER_QUEUE_H_

#include <stdlib.h>
#include <string.h>

#include "euterpe/sample_format.h"

#include "WDL/heapbuf.h"
#include "WDL/ptrlist.h"
#include "WDL/queue.h"
#include "WDL/mutex.h"

class RSE_BufferQueue
{
public:
  RSE_BufferQueue();
  ~RSE_BufferQueue();

  void AddBlock(WDL_TypedBuf<SAM> *block);
  bool GetBlock(WDL_TypedQueue<SAM> **block);
  void ReturnBlock(WDL_TypedQueue<SAM> *block);
  void DisposeBlock(WDL_TypedQueue<SAM> *block);
  int GetSize() const;
  void Flush();
  void Empty();

private:
  typedef WDL_TypedQueue<SAM> Block;
  WDL_PtrList<Block> m_blocks;
  WDL_PtrList<Block> m_empty_blocks;
  WDL_Mutex m_mutex;
  int m_size_bytes;
};

#endif // _EUTERPE_BUFFER_QUEUE_H_
