// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_DB2SLIDER_H_
#define _EUTERPE_DB2SLIDER_H_

#include <math.h>

#include "WDL/fpcmp.h"

#define RSE_POWVAL 2.0

static inline int DB2SLIDER(double db)
{
  double x = pow(RSE_POWVAL, db / 10.0);
  if (WDL_DefinitelyGreaterThan(x, 1.0)) x = 1.0;
  if (WDL_DefinitelyLessThan(x, 0.0)) x = 0.0;
  return (int)(x * 1000);
}

static inline double SLIDER2DB(int slider)
{
  double x = (double)slider / 1000;
  if (WDL_DefinitelyGreaterThan(x, 0.0000000298023223876953125))
  {
    return 10.0 * log(x) / log(RSE_POWVAL);
  }
  else
  {
    return -150;
  }
}

#endif // _EUTERPE_DB2SLIDER_H_
