// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "euterpe/definitions.h"

#include "euterpe/euterpe_plugin.h"
#include "euterpe/main_wnd.h"
#include "euterpe/playlist_wnd.h"
#include "euterpe/transport_wnd.h"
#include "euterpe/main_loop.h"

#include "WDL/mutex.h"

static void free_str(const char *p) { free((void *)p); }

#if defined(__linux__)
bool has_requested_quit = false;
#endif

WDL_FastString g_media_ext(".flac .mp3");

RSE_MainLoop *g_main_loop = NULL;
WDL_Mutex g_main_loop_mutex;
int g_main_loop_done = 0;
HANDLE g_main_loop_thread = NULL;

RSE_IAudioStreamer *g_audio_streamer = NULL;

WDL_FastString g_ini_path;
RSE_IniFile *g_ini_file = NULL;

WDL_FastString g_settings_path;
WDL_FastString g_module_path;

RSE_ITheme *g_theme = NULL;
RSE_IconTheme g_icon_theme;
RSE_KeyboardMap *g_keymap = NULL;

HINSTANCE g_inst = NULL;

RSE_Settings *g_preference_settings = NULL;
RSE_Settings *g_device_settings = NULL;

UINT g_scroll_message;

RSE_MainWnd *g_main_wnd = NULL;
RSE_PlayListWnd *g_playlist_wnd = NULL;
RSE_TransportWnd *g_transport_wnd = NULL;

WDL_PtrKeyedArray<const char *> g_plugin_import(free_str);
WDL_StringKeyedArray<void *> g_plugin_export;

const char *GetClientIniPath()
{
  return g_ini_path.Get();
}

const char *GetClientSettingsPath()
{
  return g_settings_path.Get();
}

double GetHardwareSampleRate()
{
  if (!g_audio_streamer) return 0.0;
  return g_audio_streamer->GetSampleRate();
}

int AudioOnSamples(WDL_TypedBuf<SAM> *output, int frame_count, int nch)
{
  g_main_loop->AudioOutput(output, frame_count, nch);

  return 0;
}

int GetResamplerSinc()
{
  int sinc = g_ini_file->read_int("resampler_sinc", 64, "preferences");
  return sinc;
}

int GetDiskReadMode()
{
  int readmode = g_ini_file->read_int("read_mode", 2, "preferences");
  return readmode;
}

int GetDiskReadBufferSize()
{
  int readbuffer = g_ini_file->read_int("read_buffer", 262144, "preferences");
  return readbuffer;
}

int GetDiskReadBuffers()
{
  int readbuffers = g_ini_file->read_int("read_buffers", 3, "preferences");
  return readbuffers;
}
