// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_DEFINITIONS_H_
#define _EUTERPE_DEFINITIONS_H_

#if defined(_WIN32)
  #include <windows.h>
  #include <windowsx.h>
  #include <commctrl.h>
#else
  #include "WDL/swell/swell.h"
  #include "WDL/swell/swell-functions.h"
#endif

#include "euterpe/main_loop.h"
#include "euterpe/icon_theme.h"
#include "euterpe/ini_file.h"
#include "euterpe/settings.h"
#include "euterpe/keyboard_map.h"
#include "euterpe/theme.h"
#include "euterpe/res/resource.h"

#include "WDL/assocarray.h"
#include "WDL/win32_utf8.h"
#include "WDL/wdlstring.h"
#include "WDL/wdlutf8.h"

#ifndef WM_MOUSEWHEEL
#define WM_MOUSEWHEEL 0x020A
#endif

#ifndef WM_MOUSEHWHEEL
#define WM_MOUSEHWHEEL 0x020E
#endif

class RSE_MainWnd;
class RSE_PlayListWnd;
class RSE_TransportWnd;
class RSE_Settings;
class RSE_IAudioStreamer;
class WDL_Mutex;
class RSE_MainLoop;

#if defined(__linux__)
extern bool has_requested_quit;
#endif

extern WDL_FastString g_media_ext;

extern RSE_MainLoop *g_main_loop;
extern WDL_Mutex g_main_loop_mutex;
extern int g_main_loop_done;
extern HANDLE g_main_loop_thread;

extern RSE_IAudioStreamer *g_audio_streamer;

extern WDL_FastString g_ini_path;
extern RSE_IniFile *g_ini_file;

extern WDL_FastString g_settings_path;
extern WDL_FastString g_module_path;

extern RSE_ITheme *g_theme;
extern RSE_IconTheme g_icon_theme;
extern RSE_KeyboardMap *g_keymap;

extern HINSTANCE g_inst;

extern RSE_Settings *g_preference_settings;
extern RSE_Settings *g_device_settings;

extern UINT g_scroll_message;

extern RSE_MainWnd *g_main_wnd;
extern RSE_PlayListWnd *g_playlist_wnd;
extern RSE_TransportWnd *g_transport_wnd;

extern WDL_PtrKeyedArray<const char *> g_plugin_import;
extern WDL_StringKeyedArray<void *> g_plugin_export;

extern const char *GetClientSettingsPath();
extern double GetHardwareSampleRate();
extern int AudioOnSamples(WDL_TypedBuf<SAM> *output, int frame_count, int nch);
extern int GetResamplerSinc();
extern int GetDiskReadMode();
extern int GetDiskReadBufferSize();
extern int GetDiskReadBuffers();

#endif // _EUTERPE_DEFINITIONS_H_
