// Copyright (c) 2017 Giorgos Vougioukas
//
// The plug-in mechanism derived from REAPER plug-in API
// Copyright (c) 2006-2009, Cockos Incorporated
//
// This software is provided 'as-is', without any express or implied
// warranty.  In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//     claim that you wrote the original software. If you use this software
//     in a product, an acknowledgment in the product documentation would be
//     appreciated but is not required.
//  2. Altered source versions must be plainly marked as such, and must not be
//     misrepresented as being the original software.
//  3. This notice may not be removed or altered from any source distribution.
//
//  Notes: the C++ interfaces used require MSVC on win32, or at least the
//  MSVC-compatible C++ ABI. Sorry, mingw users :(

#ifndef _EUTERPE_PLUGIN_PUBLIC_H_
#define _EUTERPE_PLUGIN_PUBLIC_H_

#ifdef _WIN32
#include <windows.h>

#define EUTERPE_PLUGIN_EXPORT __declspec(dllexport)
#define EUTERPE_PLUGIN_HINSTANCE HINSTANCE
#else
#include <pthread.h>
#include "WDL/swell/swell.h"

#define EUTERPE_PLUGIN_EXPORT __attribute__((visibility("default")))
#define EUTERPE_PLUGIN_HINSTANCE void *
#endif

#include "euterpe/sample_format.h"

#include "WDL/wdltypes.h"

#define EUTERPE_PLUGIN_ENTRYPOINT euterpe_plugin_entry
#define EUTERPE_PLUGIN_ENTRYPOINT_NAME "euterpe_plugin_entry"

#define EUTERPE_PLUGIN_VERSION 101

class RSE_IFileInput
{
public:
  virtual ~RSE_IFileInput()
  {}

  //virtual void Open(const char *filename) = 0;

  //virtual bool IsAvailable() = 0;

  virtual const char *GetType() = 0;

  // return NULL if no filename (not purely a file)
  virtual const char *GetFileName() = 0;

  // return number of channels
  virtual int GetChannels() = 0;

  // returns preferred sample rate. if < 1.0 then it is assumed to be silent
  virtual double GetSampleRate() = 0;

  // length in seconds
  virtual double GetLength() = 0;

  // returns bits/sample, if available. only used for metadata purposes,
  // since everything returns as doubles anyway.
  virtual int GetBitsPerSample() = 0;

  virtual double GetPosition() = 0;

  virtual void Seek(double time) = 0;

  //virtual int GetSamples(RSE_AudioBus *audio_bus) = 0;
  virtual int GetSamples(SAM *buffer, int length) = 0;

  virtual bool IsStreaming() = 0;

  virtual int Extended(int call, void *parm1, void *parm2, void *parm3) = 0;
};

struct RSE_AudioInputRegister
{
  RSE_IFileInput *(*CreateFromType)(const char *type);
  RSE_IFileInput *(*CreateFromFile)(const char *filename);
};

struct RSE_PluginInfo
{
  int caller_version;

  HWND hwnd_main;

  int (*Register)(const char *name, void *info_struct);

  void *(*GetFunc)(const char *name);
};

class RSE_IFileTagger
{
public:
  virtual ~RSE_IFileTagger()
  {}

  virtual const char *GetType() const = 0;

  virtual const char *GetTitle() const = 0;
  virtual const char *GetArtist() const = 0;
  virtual const char *GetAlbum() const = 0;
  virtual const char *GetGenre() const = 0;
  virtual int GetTrack() const = 0;
  virtual int GetYear() const = 0;
  virtual const char *GetComment() const = 0;

  virtual int GetBitRate() const = 0;
  virtual double GetSampleRate() const = 0;
  virtual int GetChannels() const = 0;
  virtual double GetLength() const = 0;
  virtual WDL_INT64 GetFileSize() const = 0;
  virtual const char *GetFileName() const = 0;
  virtual const char *GetFilePath() const = 0;
  virtual const char *GetFileExtension() const = 0;
  virtual const char *GetSHA() const = 0;
};

struct RSE_FileTaggerRegister
{
  RSE_IFileTagger *(*CreateFromFile)(const char *filename);
};

class RSE_IFilePic
{
public:
  virtual ~RSE_IFilePic()
  {}

  virtual int GetPicSize() const = 0;
  virtual void *GetPic() const = 0;
};

struct RSE_FilePicRegister
{
  RSE_IFilePic *(*CreateFromFile)(const char *filename);
};

#endif // _EUTERPE_PLUGIN_PUBLIC_H_
