// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_FILE_TASKS_H_
#define _EUTERPE_FILE_TASKS_H_

#include "euterpe/definitions.h"
#include "euterpe/playlist_wnd.h"
#include "WDL/mutex.h"
#include "WDL/ptrlist.h"
#include "WDL/wdlstring.h"
#include "WDL/filebrowse.h"
#include "WDL/dirscan.h"
#include "WDL/lineparse.h"

class RSE_FileTasks
{
public:
  RSE_FileTasks();
  ~RSE_FileTasks();

  void SetParent(HWND parent);

  void PlayFolder();
  void PlayFiles();
  void AddFolder();
  void AddFiles();

  void LoadPlayList();
  void SavePlayList();

  bool WantProgressWindow() const;
  const char *FileInProgress() const;
  int CurrentIndex() const;
  int TotalFiles() const;
  void AbortOperation();

private:
  int Run();
  void OnPlayFolder();
  void OnPlayFiles();
  void OnAddFolder();
  void OnAddFiles();
  void OnLoadPlayList();
  void OnSavePlayList();
  void StartThread();
  void StopThread();
  void ScanFiles(const char *path, bool empty_buffer = true);
  static unsigned int WINAPI ThreadFunction(void *arg);
  void EmptyFileCache();
  void WantProgress();

  HWND m_hwnd;

  bool m_play_folder;
  bool m_play_files;
  bool m_add_folder;
  bool m_add_files;
  bool m_load_pl;
  bool m_save_pl;

  LineParser m_lp;

  WDL_PtrList<WDL_FastString> m_file_cache;

  HANDLE m_thread;
  bool m_kill_thread;
  WDL_Mutex m_mutex;

  bool m_want_progress;
  bool m_scanning;
  bool m_cancel;

  WDL_FastString *m_curfn;
  int m_idx;

  char *m_selfiles;
  WDL_TypedBuf<char> m_selected_dir;
};

#endif // _EUTERPE_FILE_TASKS_H_
