// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_FIND_WINDOW_H_
#define _EUTERPE_FIND_WINDOW_H_

#include "euterpe/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/heapbuf.h"

class RSE_FindWnd
{
public:
  RSE_FindWnd();
  ~RSE_FindWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_FindWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET FindWndProc(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  HWND m_edit;

  WDL_TypedBuf<int> m_selected_items;
  int m_focused_item;

  int m_last_query;
};

#endif // _EUTERPE_FIND_WINDOW_H_
