// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "euterpe/keyboard_map.h"
#include "euterpe/definitions.h"

static KeyboardHotkey keyboard_hotkey[] =
{
  // Key, Ctrl, Menu, Shift, Action
  { VK_ESCAPE, 0, 0, 0, "EatEscape" },
  { 'Q', 1, 0, 0, "ExitEuterpe" },
  { 'S', 1, 0, 0, "PL_SortMenu" },
  { 'R', 1, 0, 0, "PL_Reverse" },
  { 'R', 1, 0, 1, "PL_Randomize" },
  { 'G', 1, 0, 1, "FindInPL" },
  { 'W', 1, 0, 0, "CutTracks" },
  { 'W', 0, 1, 0, "CopyTracks" },
  { 'Y', 1, 0, 0, "PasteTracks" },
  { 'A', 1, 0, 0, "PL_SelectAll" },
  { 'N', 1, 0, 0, "PL_SelectNone" },
  { 'I', 1, 0, 0, "PL_InvertSelection" },
  { VK_DELETE, 0, 0, 0, "PL_Delete" },
  { VK_DELETE, 1, 0, 0, "PL_Crop" },
  { VK_DELETE, 1, 0, 1, "PL_Clear" },
  { VK_DELETE, 0, 1, 0, "PL_RemoveMissingFiles" },
  { VK_DELETE, 0, 0, 1, "PL_RemoveDuplicateEntries" },
  { 'F', 1, 0, 0, "PlayFolder" },
  { 'O', 1, 0, 0, "PlayFiles" },
  { 'F', 1, 0, 1, "AddFolder" },
  { 'O', 1, 0, 1, "AddFiles" },
  { 'L', 1, 0, 0, "LoadPlayList" },
  { 'S', 1, 0, 1, "SavePlayList" },
  { 'F', 0, 0, 0, "VolumeUp" },
  { 'D', 0, 0, 0, "VolumeDown" },
  { 'E', 0, 0, 0, "PL_SelectCurrent" },
  { '0', 0, 0, 0, "MaxVolume" },
  { VK_INSERT, 0, 0, 0, "ExactVol" },
  { 'M', 0, 0, 0, "ToggleMute" },
  { 'R', 0, 0, 0, "Repeat" },
  { 'S', 0, 0, 0, "Shuffle" },
  { 'Q', 0, 0, 0, "AddToQueue" },
  { 'Q', 0, 0, 1, "RemoveFromQueue" },
  { 'C', 0, 0, 1, "ClearQueue" },
  { 'Z', 0, 0, 0, "Pause" },
  { 'X', 0, 0, 0, "Previous" },
  { 'X', 1, 0, 0, "Rewind" },
  { 'C', 0, 0, 0, "Next" },
  { 'C', 1, 0, 0, "Forward" },
  { 'V', 0, 0, 0, "Play" },
  { 'B', 0, 0, 0, "Stop" },
  { 'B', 1, 0, 0, "StopAfterCurrent" },
  { 'A', 0, 0, 0, "ViewArtwork" },
  { 'A', 1, 0, 1, "PreviewArtwork" },
  { VK_RETURN, 0, 0, 0, "PlaySelected" },
  { 'T', 0, 0, 0, "TS_ToggleTimeDisplay" },
  { 'P', 1, 0, 0, "Preferences" },
  { 'M', 1, 0, 0, "MoveAfterCurrent" },
  { '3', 0, 1, 0, "Properties" },
  { VK_UP, 0, 1, 0, "MoveUp" },
  { VK_DOWN, 0, 1, 0, "MoveDown" },
  { VK_F1, 1, 0, 0, "AboutEuterpe" },
  { VK_F2, 1, 0, 0, "Changelog" },
  { VK_F3, 1, 0, 0, "Version" }
};

RSE_KeyboardMap::RSE_KeyboardMap()
  : m_keymap(WDL_assocarray_cmpstr)
{
  int sz = sizeof(keyboard_hotkey) /
    sizeof(keyboard_hotkey[0]);

  for (int i = 0; i < sz; i++)
  {
    m_keymap.AddUnsorted(keyboard_hotkey[i].action,
      &keyboard_hotkey[i]);
  }

  m_keymap.Resort();
}

RSE_KeyboardMap::~RSE_KeyboardMap()
{
  m_keymap.DeleteAll();
}

unsigned char RSE_KeyboardMap::GetKey(const char *action)
{
  KeyboardHotkey *k = m_keymap.Get(action);

  if (k)
  {
    return k->key;
  }

  return ' ';
}

bool RSE_KeyboardMap::MatchModifier(const char *action)
{
  int c, m, s;
  c = m = s = 0;

  if (GetAsyncKeyState(VK_CONTROL) & 0x8000)
  {
    c = 1;
  }

  if (GetAsyncKeyState(VK_MENU) & 0x8000)
  {
    m = 1;
  }

  if (GetAsyncKeyState(VK_SHIFT) & 0x8000)
  {
    s = 1;
  }

  KeyboardHotkey *k = m_keymap.Get(action);

  if (!k) return false;

  return ((k->ctrl == c) && (k->menu == m) &&
    (k->shift == s));
}
