// Copyright (c) 2017 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include <main.h>
#include <core.h>
#include <wall_time.h>

#include <core/version.h>
#include <res/resource.h>

#if __linux__
HMENU SWELL_app_stocksysmenu;
#else
extern HMENU SWELL_app_stocksysmenu;
#endif

double wall_0, wall_1, cpu_0, cpu_1;

extern "C" {

  INT_PTR SWELLAppMain(int msg, INT_PTR parm1, INT_PTR parm2)
  {
    switch (msg)
    {
    case SWELLAPP_ONLOAD:
      {
        wall_0 = get_wall_time();
        cpu_0 = get_cpu_time();
      }
      break;

    case SWELLAPP_LOADED:
      {

        if (SWELL_app_stocksysmenu)
        {
          HMENU menu = CreatePopupMenu();
          HMENU nm = SWELL_DuplicateMenu(SWELL_app_stocksysmenu);

          if (nm)
          {
            MENUITEMINFO mi = { sizeof(mi), MIIM_STATE | MIIM_SUBMENU | MIIM_TYPE, MFT_STRING, 0, 0, nm, NULL, NULL, 0, "Euterpe" };
            InsertMenuItem(menu, 0, TRUE, &mi);
          }

          SWELL_SetDefaultWindowMenu(menu);
        }


        {
          HMENU menu = LoadMenu(NULL, MAKEINTRESOURCE(IDR_MENU1));
          {
            HMENU sm = GetSubMenu(menu, 0);
            DeleteMenu(sm, ID_FILE_QUIT, MF_BYCOMMAND);

            int a = GetMenuItemCount(sm);

            while (a > 0 && GetMenuItemID(sm, a - 1) == 0)
            {
              DeleteMenu(sm, a - 1, MF_BYPOSITION);
            }

            a--;
          }
          DeleteMenu(menu, GetMenuItemCount(menu) - 1, MF_BYPOSITION);


          if (SWELL_app_stocksysmenu)
          {
            HMENU nm = SWELL_DuplicateMenu(SWELL_app_stocksysmenu);

            if (nm)
            {
              MENUITEMINFO mi = { sizeof(mi), MIIM_STATE | MIIM_SUBMENU | MIIM_TYPE, MFT_STRING, 0, 0, nm, NULL, NULL, 0, "Euterpe"};

              InsertMenuItem(menu, 0, TRUE, &mi);
            }

          }

          main_dlg.Create(NULL, true);

          SetMenu(main_dlg.GetDialog(), menu);

          if (version.IsPrototypon())
          {
            const char msg[] =
            {
              "Welcome to " APP_NAME " (the ``Software'').\n\n"
              "THIS IS A PROTOTYPON STILL IN DEVELOPEMENT PHASE "
              "AND IS PROVIDED ON AN ``AS IS'' BASIS AND IS BELIEVED "
              "TO CONTAIN DEFECTS AND A PRIMARY PURPOSE OF THIS "
              "PROTOTYPON IS TO OBTAIN FEEDBACK ON SOFTWARE PERFORMANCE "
              "AND THE IDENTIFICATION OF DEFECTS.\n\n"
              "IT IS ADVISED TO SAFEGUARD IMPORTANT DATA, TO USE CAUTION AND NOT "
              "TO RELY IN ANY WAY ON THE CORRECT FUNCTIONING OF THIS VERSION.\n\n"
              APP_COPYRIGHT
            };


            double wall_1 = get_wall_time();
            double cpu_1 = get_cpu_time();
            double wall_elapsed_sec = wall_1 - wall_0;
            double cpu_elapsed_sec = cpu_1 - cpu_0;

            WDL_FastString prototype;
            prototype.Set(msg);
            prototype.AppendFormatted(128, "\n\nStartup time.\nWall time: "
                                      "%f sec.\nCPU time: "
                                      "%f sec.",
                                      wall_elapsed_sec,
                                      cpu_elapsed_sec);

            MessageBox(main_dlg.GetDialog(), prototype.Get(), "ALPHA PROTOTYPON", MB_OK);
          }
        }

      }
      break;

    case SWELLAPP_ONCOMMAND:
      {
        if (main_dlg.GetDialog() && (parm1 & 0xFFFF))
        {
          SendMessage(main_dlg.GetDialog(), WM_COMMAND, parm1 & 0xFFFF, 0);
        }
      }
      break;

    case SWELLAPP_DESTROY:
      {
        //if (g_main_wnd) DestroyWindow(g_main_wnd);
      } break;

    case SWELLAPP_PROCESSMESSAGE:
      {
        if (MainProcessMessage((MSG *) parm1) > 0)
        {
          return 1;
        }

        return 0;
      }
      break;
    }

    return 0;
  }

};

#include <whittle/swell/swell-dlggen.h>
#include <winclient/res/euterpe.rc_mac_dlg>

#undef BEGIN
#undef END
#include <whittle/swell/swell-menugen.h>
#include <winclient/res/euterpe.rc_mac_menu>

