// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_MAIN_WINDOW_H_
#define _EUTERPE_MAIN_WINDOW_H_

#include "euterpe/definitions.h"
#include "euterpe/playlist_wnd.h"
#include "euterpe/transport_wnd.h"
#include "euterpe/preferences_wnd.h"
#include "euterpe/find_wnd.h"
#include "euterpe/license_wnd.h"
#include "euterpe/about_wnd.h"
#include "euterpe/changelog_wnd.h"
#include "euterpe/file_tasks.h"
#include "euterpe/artwork_wnd.h"
#include "euterpe/file_prog_wnd.h"
#include "euterpe/exactvol_wnd.h"

#include "WDL/win32_utf8.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/lineparse.h"
#include "WDL/mutex.h"

class RSE_MainWnd
{
public:
  RSE_MainWnd();
  ~RSE_MainWnd();

  HWND Handle() const;

  void ShowArtwork();
  void ShowKillRegionInfo(const char *info);

  RSE_FileTasks *FileTask();

  bool IsEngineOnline() const;
  void SetEngineOnline();
  void SetEngineOffline();

  void RunMessageLoop();
  int ProcessMessage(MSG *msg);

  static WDL_DLGRET ST_MainWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET MainWndProc(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  HMENU m_main_menu;
  WDL_WndSizer m_resize;
  WDL_Mutex m_mutex;
  bool m_title_capture;

  int m_x, m_y, m_w, m_h;

  //WDL_VWnd_Painter m_painter;
  RSE_PlayListWnd m_pl_wnd;
  RSE_TransportWnd m_ts_wnd;

  RSE_PreferencesWnd m_pr_wnd;
  RSE_FindWnd m_find_wnd;

  RSE_LicenseWnd m_lic_wnd;
  RSE_AboutWnd m_about_wnd;
  RSE_ChangeLogWnd m_cl_wnd;

  RSE_ArtworkWnd m_artwork_wnd;

  RSE_FileTasks m_file_task;
  RSE_FileTasksProgressWnd m_ft_prog_wnd;
  WDL_FastString m_titstr;

  int m_cut_copy_paste_ms;
  WDL_FastString m_cut_copy_paste_info;

  RSE_ExactVolWnd m_exactvol_wnd;
};

#endif // _EUTERPE_MAIN_WINDOW_H_
