// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_MODULE_CREATION_H_
#define _EUTERPE_MODULE_CREATION_H_

#include "euterpe/definitions.h"
#include "euterpe/euterpe_plugin.h"

RSE_IFileInput *CreateAudioInput(const char *filename);
RSE_IFileTagger *CreateFileTagger(const char *filename);
RSE_IFilePic *CreateFilePic(const char *filename);
RSE_IAudioStreamer *CreateAudioStreamer(const char *name);
RSE_IAudioStreamerDevice *CreateAudioStreamerDevice(const char *name);
RSE_IAudioStreamerProperties *CreateAudioStreamerProperties(const char *name);

void LoadPlugins();
void ReleasePlugins();

#endif // _EUTERPE_MODULE_CREATION_H_
