// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_GENERAL_WINDOW_H_
#define _EUTERPE_GENERAL_WINDOW_H_

#include "euterpe/definitions.h"
#include "WDL/lice/lice.h"

class RSE_GeneralWnd
{
public:
  RSE_GeneralWnd();
  ~RSE_GeneralWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_GeneralWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET GeneralWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  void DoPaint(HDC dc);
  HWND m_hwnd;

  LICE_SysBitmap *m_bm_bg;
  LICE_SysBitmap *m_bm_txt;

#if defined(_WIN32)
  CHOOSECOLOR m_cc_bg;
  CHOOSECOLOR m_cc_txt;
#endif

  COLORREF m_bg;
  COLORREF m_bg_custom_colors[16];
  COLORREF m_bg_grad_start;
  COLORREF m_bg_grad_end;

  COLORREF txt_;
  COLORREF m_txt_custom_colors[16];
  COLORREF m_txt_grad_start;
  COLORREF m_txt_grad_end;
};

#endif // _EUTERPE_GENERAL_WINDOW_H_
