// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_DATABASE_WINDOW_H_
#define _EUTERPE_DATABASE_WINDOW_H_

#include "euterpe/definitions.h"
#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"

class RSE_MediaLibraryWnd
{
public:
  RSE_MediaLibraryWnd();
  ~RSE_MediaLibraryWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_MediaLibraryWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET MediaLibraryWndProc(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  HWND m_list;

  struct ColumnHeader
  {
    int id;
    const char *text;
    int width;
    int fmt;
    int sort_dir; // 1 ascending, -1 descending
    int sort_type; // 0 text, 1 numeric
  };

  WDL_TypedBuf<ColumnHeader> m_column_header;
  WDL_TypedBuf<int> m_selected_items;
  WDL_String m_music_paths;
  WDL_FastString m_files_dirs_info;
};

#endif // _EUTERPE_DATABASE_WINDOW_H_
