// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_PREFERENCES_WINDOW_H_
#define _EUTERPE_PREFERENCES_WINDOW_H_

#include "euterpe/definitions.h"
#include "euterpe/pr_general_wnd.h"
#include "euterpe/pr_media_library_wnd.h"
#include "euterpe/pr_audio_system_wnd.h"
#include "euterpe/pr_disk_io_wnd.h"

class RSE_PreferencesWnd
{
public:
  RSE_PreferencesWnd();
  ~RSE_PreferencesWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_PreferencesWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET PreferencesWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  HTREEITEM AddItem(HWND hwnd, HTREEITEM h, const char *str, int children, int data);

  HWND m_hwnd;
  int m_last_page;
  HTREEITEM m_last_page_item;
  HWND m_current_window;
  RSE_IAudioStreamerProperties *m_hw_prop;

  RSE_GeneralWnd m_gen_wnd;
  RSE_DiskIOWnd m_diskio_wnd;
  RSE_MediaLibraryWnd m_ml_wnd;
  RSE_AudioSystemWnd m_audio_system_wnd;
};

#endif // _EUTERPE_PREFERENCES_WINDOW_H_
