// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_PREVIEW_ARTWORK_WINDOW_H_
#define _EUTERPE_PREVIEW_ARTWORK_WINDOW_H_

#include "euterpe/definitions.h"

#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"
#include "WDL/wingui/scrollbar/coolscroll.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"

class RSE_SingleImage : public WDL_VWnd
{
public:
  RSE_SingleImage();
  ~RSE_SingleImage();

  void OnPaint(LICE_IBitmap *drawbm, int origin_x, int origin_y, RECT *cliprect, int rscale);
  int OnMouseDown(int xpos, int ypos);
  void OnMouseUp(int xpos, int ypos);

  LICE_IBitmap *m_img;
  LICE_IFont *m_font;
  int m_track;
  WDL_FastString m_fn;
  bool m_blur;
};

class RSE_PreviewArtworkWnd
{
public:
  RSE_PreviewArtworkWnd();
  ~RSE_PreviewArtworkWnd();

  HWND Handle() const;

  void PreviewArtwork(WDL_PtrList<char> *files, WDL_TypedBuf<int> *track, HWND parent);

  static WDL_DLGRET ST_PreviewArtworkWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  WDL_DLGRET PreviewArtworkWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  static unsigned int WINAPI ThreadFunction(void *arg);
  int Run();
  int OrganizeWindow();

  HWND m_hwnd;

  WDL_PtrList<char> *m_fns;
  WDL_TypedBuf<int> *m_trk;

  HANDLE m_thread;
  bool m_kill_thread;
  WDL_Mutex m_mutex;
  int m_idx;

  WDL_VWnd m_images;
  WDL_VWnd_Painter m_painter;
};

#endif // _EUTERPE_PREVIEW_ARTWORK_WINDOW_H_
