// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_PROPERTIES_WINDOW_H_
#define _EUTERPE_PROPERTIES_WINDOW_H_

#include "euterpe/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/heapbuf.h"
#include "WDL/ptrlist.h"

class RSE_PropertiesWnd
{
public:
  RSE_PropertiesWnd();
  ~RSE_PropertiesWnd();

  HWND Handle() const;

  void ShowProperties(WDL_PtrList<char> *files, HWND parent);
  void ApplyListViewColors(int bgc, int txtc);

  static WDL_DLGRET ST_PropertiesWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET PropertiesWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  static unsigned int WINAPI ThreadFunction(void *arg);
  int Run();

  HWND m_hwnd;
  HWND m_list;

  struct ColumnHeader
  {
    int id;
    const char *text;
    int width;
    int fmt;
    int sort_dir; // 1 ascending, -1 descending
    int sort_type; // 0 text, 1 numeric
  };

  WDL_TypedBuf<ColumnHeader> m_column_header;
  WDL_WndSizer m_resize;
  WDL_PtrList<char> *m_fns;

  HANDLE m_thread;
  bool m_kill_thread;
  WDL_Mutex m_mutex;
  int m_idx;

  WDL_PtrList<RSE_IFileTagger> m_fts;
};

#endif // _EUTERPE_PROPERTIES_WINDOW_H_
