// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_THEME_H_
#define _EUTERPE_THEME_H_

#include <string.h>
#include <stdlib.h>

//#define UNICODE
#include "WDL/zlib/unzip.h"
#include "WDL/assocarray.h"
#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"

class RSE_ITheme
{
public:
  RSE_ITheme();
  virtual ~RSE_ITheme();

  virtual bool LoadResource(const char *resource) = 0;
  virtual void UnloadResource() = 0;

  virtual const char *GetThemeResource() const = 0;
  virtual bool IsThemeLoaded() const = 0;

  WDL_StringKeyedArray<WDL_HeapBuf *> data;
};

class RSE_PackedTheme : public RSE_ITheme
{
public:
  RSE_PackedTheme();
  ~RSE_PackedTheme();

  // RSE_PackedTheme reads the contents of a zip file in memory.
  // In our case a packed resource is a zip file with renamed
  // extension to .euterpe_theme which is used to store all 
  // data required by the theme engine. Once the resource is
  // fully loaded you can access the individual bytes for each
  // file via |data|.

  // Loads a resource. If it fails it is necessary to run
  // UnloadResource in order to clean-up any partial loaded
  // data.
  bool LoadResource(const char *resource);
  void UnloadResource();

  const char *GetThemeResource() const;
  bool IsThemeLoaded() const;

private:
  WDL_FastString m_theme_res;

  unzFile m_zipfile;
  unz_global_info64 m_global_info;
  unz_file_info64 m_file_info;
};

#endif // _EUTERPE_THEME_H_
