// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_TRANSPORT_WINDOW_H_
#define _EUTERPE_TRANSPORT_WINDOW_H_

#include "euterpe/definitions.h"
#include "euterpe/artwork_wnd.h"

#include "WDL/wingui/virtwnd.h"
#include "WDL/wingui/virtwnd-controls.h"
#include "WDL/wingui/wndsize.h"

#define RSE_UPDATE_TRANSPORT_CONTROLS 700
#define RSE_UPDATE_TRANSPORT_CONTROLS_MS 90

class RSE_PauseButton : public WDL_VirtualIconButton
{
public:
  RSE_PauseButton();
  ~RSE_PauseButton();

  void OnMouseUp(int xpos, int ypos);
};

class RSE_PreviousButton : public WDL_VirtualIconButton
{
public:
  RSE_PreviousButton();
  ~RSE_PreviousButton();

  void OnMouseUp(int xpos, int ypos);
};

class RSE_NextButton : public WDL_VirtualIconButton
{
public:
  RSE_NextButton();
  ~RSE_NextButton();

  void OnMouseUp(int xpos, int ypos);
};

class RSE_PlayButton : public WDL_VirtualIconButton
{
public:
  RSE_PlayButton();
  ~RSE_PlayButton();

  int OnMouseDown(int xpos, int ypos);
  void OnMouseUp(int xpos, int ypos);
};

class RSE_StopButton : public WDL_VirtualIconButton
{
public:
  RSE_StopButton();
  ~RSE_StopButton();

  void OnMouseUp(int xpos, int ypos);
};

class RSE_TimeStaticText : public WDL_VirtualStaticText
{
public:
  RSE_TimeStaticText();
  ~RSE_TimeStaticText();

};

class RSE_PercDecibelStaticText : public WDL_VirtualStaticText
{
public:
  RSE_PercDecibelStaticText();
  ~RSE_PercDecibelStaticText();
};

class RSE_ProgressSlider : public WDL_VirtualSlider
{
public:
  RSE_ProgressSlider();
  ~RSE_ProgressSlider();

  int OnMouseDown(int xpos, int ypos);
  void OnMouseUp(int xpos, int ypos);
  void OnMouseMove(int xpos, int ypos);

private:
  LICE_IBitmap *m_img;
};

class RSE_VolumeSlider : public WDL_VirtualSlider
{
public:
  RSE_VolumeSlider();
  ~RSE_VolumeSlider();

  void OnMouseUp(int xpos, int ypos);
  void OnMouseMove(int xpos, int ypos);
  bool OnMouseDblClick(int xpos, int ypos);

private:
  LICE_IBitmap *m_img;
};

class RSE_RepeatButton : public WDL_VirtualIconButton
{
public:
  RSE_RepeatButton();
  ~RSE_RepeatButton();

  void OnMouseMove(int xpos, int ypos);
  void OnMouseUp(int xpos, int ypos);
};

class RSE_ShuffleButton : public WDL_VirtualIconButton
{
public:
  RSE_ShuffleButton();
  ~RSE_ShuffleButton();

  void OnMouseMove(int xpos, int ypos);
  void OnMouseUp(int xpos, int ypos);
};

class RSE_TransportWnd
{
public:
  RSE_TransportWnd();
  ~RSE_TransportWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_TransportWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET TransportWndProc(UINT msg, WPARAM wparam, LPARAM lparam);
  int sort_by_file_path(const void *a, const void *b);
  void DoPaint(HWND hwnd, HDC dc);

  HWND m_hwnd;

  enum
  {
    PAUSE_BUTTON = 1000,
    PREVIOUS_BUTTON,
    NEXT_BUTTON,
    PLAY_BUTTON,
    STOP_BUTTON,
    TIME_TEXT,
    PROGRESS_SLIDER,
    PERCDB_TEXT,
    VOLUME_SLIDER,
    REPEAT_BUTTON,
    SHUFFLE_BUTTON
  };

  WDL_WndSizer m_resize;
  WDL_VWnd m_vwnd;
  WDL_VWnd_Painter m_painter;
  WDL_PtrList<WDL_FastString> m_files;
  RSE_TimeStaticText m_time_static;
  RSE_RepeatButton m_repeat_button;
  RSE_ShuffleButton m_shuffle_button;
  RSE_ProgressSlider m_progress_slider;
  RSE_PercDecibelStaticText m_pdb_static;
  RSE_VolumeSlider m_volume_slider;
  RSE_PauseButton m_pause_button;
  RSE_PreviousButton m_previous_button;
  RSE_NextButton m_next_button;
  RSE_PlayButton m_play_button;
  RSE_StopButton m_stop_button;

  int m_button_height;
  int m_button_width;

  LICE_IBitmap *m_bm;
  LICE_CachedFont *m_font;
  LICE_CachedFont *m_time_font;
  LICE_CachedFont *m_perc_db_font;

  WDL_FastString m_strbuf;
};

#endif // _EUTERPE_TRANSPORT_WINDOW_H_
