// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_AUDIO_STREAMER_PA_DIRECTSOUND_DEVICE_H_
#define _EUTERPE_AUDIO_STREAMER_PA_DIRECTSOUND_DEVICE_H_

#include "euterpe/euterpe_plugin.h"

#include <portaudio.h>

#include "WDL/assocarray.h"

extern HINSTANCE directsound_instance;

class RSE_PaDirectSoundDevice : public RSE_IAudioStreamerDevice
{
public:
  RSE_PaDirectSoundDevice();
  ~RSE_PaDirectSoundDevice();

  void Scan();

  int GetDefaultInputDevice() const;
  int GetDefaultOutputDevice() const;

  //WDL_IntKeyedArray<const char *> input_dev;
  //WDL_IntKeyedArray<const char *> output_dev;

private:
  PaError m_error;

  int m_default_input_dev;
  int m_default_output_dev;

  PaHostApiTypeId m_host_api_id;
};

#endif // _EUTERPE_AUDIO_STREAMER_PA_DIRECTSOUND_DEVICE_H_
