// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "euterpe_ds/audio_streamer_pa_ds_prop.h"
#include "euterpe_ds/res/resource.h"

RSE_PaDirectSoundProperties::RSE_PaDirectSoundProperties()
{}

RSE_PaDirectSoundProperties::~RSE_PaDirectSoundProperties()
{
  if (m_prop_wnd.Handle())
  {
    DestroyWindow(m_prop_wnd.Handle());
  }
}

void RSE_PaDirectSoundProperties::PropertiesWindow(HWND parent, int rleft, int rtop)
{
  if (!m_prop_wnd.Handle())
  {
    CreateDialogParam(directsound_instance, MAKEINTRESOURCE(IDD_DIRECTSOUND),
      parent, RSE_DirectSoundWnd::ST_DirectSoundWndProc, (LPARAM)&m_prop_wnd);

    SetWindowPos(m_prop_wnd.Handle(), NULL, rleft, rtop, 0, 0,
      SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);

    ShowWindow(m_prop_wnd.Handle(), SW_SHOW);
  }
  else
  {
    SetFocus(m_prop_wnd.Handle());
  }
}
