// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_DIRECTSOUND_WINDOW_H_
#define _EUTERPE_DIRECTSOUND_WINDOW_H_

#include "euterpe/euterpe_plugin.h"
#include "euterpe/ini_file.h"
#include "euterpe_ds/audio_streamer_pa_ds_dev.h"

extern const char *(*GetSettingsPath)();

class RSE_DirectSoundWnd
{
public:
  RSE_DirectSoundWnd();
  ~RSE_DirectSoundWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_DirectSoundWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET DirectSoundWndProc(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  RSE_IniFile *m_ini_file;

  RSE_PaDirectSoundDevice *m_devlist;
};

#endif // _EUTERPE_DIRECTSOUND_WINDOW_H_
