// Based on:
// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license.

#include "euterpe_gen/ffmpeg_common.h"

static const AVRational micros_base = { 1, 1000000 };

double ConvertFromTimeBase(const AVRational& time_base, int64_t timestamp)
{
  int64_t microseconds = av_rescale_q(timestamp, time_base, micros_base);
  return (double)microseconds / 1000000;
}
