// Based on:
// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license.

#ifndef _EUTERPE_FFMPEG_COMMON_H_
#define _EUTERPE_FFMPEG_COMMON_H_

extern "C"
{
  #include <libavcodec/avcodec.h>
  #include <libavformat/avformat.h>
  #include <libavformat/avio.h>
  #include <libavutil/avutil.h>
  #include <libswresample/swresample.h>
  #include <libavutil/opt.h>
}

#include <stdint.h>

#include "euterpe_gen/ffmpeg_deleters.h"

inline void ScopedPtrAVFree::operator()(void *x) const
{
  av_free(x);
}

inline void ScopedPtrAVFreePacket::operator()(void *x) const
{
  AVPacket *packet = static_cast<AVPacket *>(x);
  av_packet_unref(packet);
  delete packet;
}

inline void ScopedPtrAVFreeContext::operator()(void *x) const
{
  AVCodecContext *codec_context = static_cast<AVCodecContext *>(x);
  avcodec_free_context(&codec_context);
}

inline void ScopedPtrAVFreeFrame::operator()(void *x) const
{
  AVFrame *frame = static_cast<AVFrame *>(x);
  av_frame_free(&frame);
}

double ConvertFromTimeBase(const AVRational& time_base, int64_t timestamp);

#endif // _EUTERPE_FFMPEG_COMMON_H_
