#ifndef _EUTERPE_FFMPEG_FILE_PICTURE_H_
#define _EUTERPE_FFMPEG_FILE_PICTURE_H_

#include "euterpe/euterpe_plugin_public.h"
#include "euterpe_gen/ffmpeg_input.h"
#include "WDL/heapbuf.h"
#include "WDL/fileread.h"

class RSE_FFmpegPic : public RSE_IFilePic
{
public:
  RSE_FFmpegPic();
  ~RSE_FFmpegPic();

  bool Open(const char *filename);

  int GetPicSize() const;
  void *GetPic() const;

private:
  void ReadPicture();
  bool FindCodec();
  CodecInfo m_codec_info;
  RSE_FFmpegFileProtocol *m_protocol;
  RSE_FFmpegGlue *m_glue;
  ScopedContext *m_context;

  bool m_eof;
  WDL_HeapBuf m_pic;
  WDL_FastString m_fn;
};

#endif // _EUTERPE_FFMPEG_FILE_PICTURE_H_
