// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MP3_AUDIO_INPUT_H_
#define _MP3_AUDIO_INPUT_H_

#if defined(__linux__)
#define NO_POSIX_FILEREAD
#include <sys/types.h>
#include <unistd.h>
#endif

#include "euterpe/euterpe_plugin.h"
#include "third_party/miniaudio/extras/dr_mp3.h"

#include "WDL/wdlstring.h"
#include "WDL/resample.h"

class RSE_Mp3Input : public RSE_IFileInput
{
public:
  RSE_Mp3Input();
  ~RSE_Mp3Input();

  bool Open(const char *filename);

  const char *GetType();

  const char *GetFileName();

  int GetChannels();

  double GetSampleRate();

  double GetLength();

  int GetBitsPerSample();

  double GetPosition();

  void Seek(double time);

  int GetSamples(SAM *buffer, int length);

  bool IsStreaming();

  int Extended(int call, void *parm1, void *parm2, void *parm3);

private:

  drmp3 m_mp3;

  WDL_FastString m_filename;
  WDL_TypedBuf<float> m_tmp;

  double m_length;

  int m_channels;
  int m_bits_per_sample;
  double m_sample_rate;
  //WDL_INT64 m_total_length;

  //WDL_HeapBuf m_buffer;
  //WDL_TypedQueue<SAM> m_samples;
  //WDL_Resampler m_resampler;

  double m_current_position;

  //double m_desired_samplerate;
  //int m_desired_channels;
};

#endif // _MP3_AUDIO_INPUT_H_
