// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "euterpe_wasapi/audio_streamer_wasapi_prop.h"
#include "euterpe_wasapi/res/resource.h"

RSE_WasapiProperties::RSE_WasapiProperties()
{}

RSE_WasapiProperties::~RSE_WasapiProperties()
{
  if (m_prop_wnd.Handle())
  {
    DestroyWindow(m_prop_wnd.Handle());
  }
}

void RSE_WasapiProperties::PropertiesWindow(HWND parent, int rleft, int rtop)
{
  if (!m_prop_wnd.Handle())
  {
    CreateDialogParam(wasapi_instance, MAKEINTRESOURCE(IDD_PULSEAUDIO),
      parent, RSE_WasapiWnd::ST_WasapiWndProc, (LPARAM)&m_prop_wnd);

    SetWindowPos(m_prop_wnd.Handle(), NULL, rleft, rtop, 0, 0,
      SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);

    ShowWindow(m_prop_wnd.Handle(), SW_SHOWNA);
  }
  else
  {
    SetFocus(m_prop_wnd.Handle());
  }
}
