// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_AUDIO_STREAMER_PA_WAVEOUT_H_
#define _EUTERPE_AUDIO_STREAMER_PA_WAVEOUT_H_

#include <windows.h>

#include <portaudio.h>
#include <pa_win_wmme.h>
#include <pa_util.h>

#include "euterpe/euterpe_plugin.h"
#include "euterpe/ini_file.h"

#include "WDL/heapbuf.h"
#include "WDL/queue.h"
#include "WDL/wdlstring.h"

extern const char *(*GetSettingsPath)();

class RSE_PaWaveOut : public RSE_IAudioStreamer
{
public:
  RSE_PaWaveOut();
  ~RSE_PaWaveOut();

  bool Open();
  void Start(AudioCallback callback);
  void Stop();
  void Close();
  bool IsRunning() const;
  double GetSampleRate() const;

private:
  static int pa_callback(const void *input, void *output, unsigned long frame_count,
    const PaStreamCallbackTimeInfo *time_info, PaStreamCallbackFlags status_flags,
    void *user_data);

  RSE_IniFile *m_ini_file;

  PaError m_error;
  PaStream *m_stream;
  bool m_running;

  AudioCallback m_callback;

  int m_sample_fmt;
  int m_samplerate;
  int m_output_nch;
  int m_output_dev;

  WDL_TypedBuf<SAM> m_buffer;
  WDL_HeapBuf m_pcm;
};

#endif // _EUTERPE_AUDIO_STREAMER_PA_WAVEOUT_H_
