// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "euterpe_wave/audio_streamer_pa_wave_prop.h"
#include "euterpe_wave/res/resource.h"

RSE_PaWaveOutProperties::RSE_PaWaveOutProperties()
{}

RSE_PaWaveOutProperties::~RSE_PaWaveOutProperties()
{
  if (m_prop_wnd.Handle())
  {
    DestroyWindow(m_prop_wnd.Handle());
  }
}

void RSE_PaWaveOutProperties::PropertiesWindow(HWND parent, int rleft, int rtop)
{
  if (!m_prop_wnd.Handle())
  {
    CreateDialogParam(waveout_instance, MAKEINTRESOURCE(IDD_WAVEOUT),
      parent, RSE_WaveOutWnd::ST_WaveOutWndProc, (LPARAM)&m_prop_wnd);

    SetWindowPos(m_prop_wnd.Handle(), NULL, rleft, rtop, 0, 0,
      SWP_NOACTIVATE | SWP_NOSIZE | SWP_NOZORDER);

    ShowWindow(m_prop_wnd.Handle(), SW_SHOW);
  }
  else
  {
    SetFocus(m_prop_wnd.Handle());
  }
}
