// Copyright (c) 2020 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "euterpe/euterpe_plugin.h"
#include "euterpe_wave/audio_streamer_pa_wave.h"
#include "euterpe_wave/audio_streamer_pa_wave_dev.h"
#include "euterpe_wave/audio_streamer_pa_wave_prop.h"

#if defined(_WIN32) && defined(_DEBUG)
#include <vld.h>
#endif

#include "WDL/wdlcstring.h"

HINSTANCE waveout_instance;
static HWND waveout_main_hwnd;

double (*GetHardwareSampleRate)();
const char *(*GetSettingsPath)();

RSE_IAudioStreamer *CreateAudioStreamer()
{
  return new RSE_PaWaveOut;
}

RSE_AudioStreamerRegister waveout_reg =
{
  &CreateAudioStreamer
};

RSE_IAudioStreamerDevice *CreateAudioStreamerDevice()
{
  return new RSE_PaWaveOutDevice;
}

RSE_AudioStreamerDeviceRegister waveout_dev_reg =
{
  &CreateAudioStreamerDevice
};

RSE_IAudioStreamerProperties *CreateAudioStreamerProperties()
{
  return new RSE_PaWaveOutProperties;
}

RSE_AudioStreamerPropertiesRegister waveout_prop_reg =
{
  &CreateAudioStreamerProperties
};

extern "C"
{
  EUTERPE_PLUGIN_EXPORT int EUTERPE_PLUGIN_ENTRYPOINT(
    EUTERPE_PLUGIN_HINSTANCE instance, RSE_PluginInfo *rec)
  {
    waveout_instance = instance;

    if (rec)
    {
      if (rec->caller_version != EUTERPE_PLUGIN_VERSION || !rec->GetFunc)
      {
        return 0;
      }

      *((void **)&GetSettingsPath) = rec->GetFunc("GetClientSettingsPath");
      *((void **)&GetHardwareSampleRate) = rec->GetFunc("GetHardwareSampleRate");

      waveout_main_hwnd = rec->hwnd_main;

      if (!GetHardwareSampleRate || !GetSettingsPath || !rec->Register)
      {
        return 0;
      }

      rec->Register("audio_streamer:WaveOut", &waveout_reg);
      rec->Register("audio_device:WaveOut", &waveout_dev_reg);
      rec->Register("audio_properties:WaveOut", &waveout_prop_reg);

      return 1;
    }
    else
    {
      return 0;
    }
  }
}
