// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _EUTERPE_WAVEOUT_WINDOW_H_
#define _EUTERPE_WAVEOUT_WINDOW_H_

#include "euterpe/euterpe_plugin.h"
#include "euterpe/ini_file.h"
#include "euterpe_wave/audio_streamer_pa_wave_dev.h"

extern const char *(*GetSettingsPath)();

class RSE_WaveOutWnd
{
public:
  RSE_WaveOutWnd();
  ~RSE_WaveOutWnd();

  HWND Handle() const;

  static WDL_DLGRET ST_WaveOutWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  WDL_DLGRET WaveOutWndProc(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  RSE_IniFile *m_ini_file;

  RSE_PaWaveOutDevice *m_devlist;
};

#endif // _EUTERPE_WAVEOUT_WINDOW_H_
