#!/bin/sh
#--arch=x86/x86_64 --cpu=i686/generic
#--disable-runtime-cpudetect \
#--enable-libmp3lame \
export CFLAGS=-static-libgcc
export CXXFLAGS=-static-libgcc
export LDFLAGS=-static-libgcc
./configure --target-os=mingw32 \
--cross-prefix=x86_64-w64-mingw32- \
--disable-x86asm \
--arch=x86_64 \
--cpu=generic \
--disable-static \
--enable-shared \
--build-suffix=-euterpe \
--prefix=./out \
--disable-programs \
--disable-doc \
--disable-avdevice \
--disable-swscale \
--disable-postproc \
--disable-avfilter \
--disable-network \
--disable-dxva2 \
--disable-vaapi \
--disable-vdpau \
--disable-everything \
--disable-iconv \
--disable-debug \
--disable-audiotoolbox \
--disable-cuda \
--disable-cuvid \
--disable-d3d11va \
--disable-dxva2 \
--disable-nvenc \
--disable-vaapi \
--disable-vdpau \
--disable-videotoolbox \
--disable-schannel \
--disable-xlib \
--disable-protocols \
--disable-asm \
--enable-small \
--enable-swresample \
--enable-runtime-cpudetect \
--enable-stripping \
--enable-protocol=file \
--enable-demuxer=flac \
--enable-demuxer=mp3 \
--enable-decoder=flac \
--enable-decoder=mp3 \
--enable-decoder=mp3float \
--enable-parser=flac \
--enable-parser=mpegaudio \
--enable-decoder=bmp \
--enable-decoder=mjpeg \
--enable-decoder=mjpegb \
--enable-decoder=png \
--enable-demuxer=mjpeg \
--enable-encoder=mjpeg \
--enable-encoder=png \
--enable-muxer=mjpeg \
--enable-muxer=singlejpeg \
--enable-parser=bmp \
--enable-parser=mjpeg \
--enable-parser=png

make -j3

mkdir -p ffmpeg-win-x64
mkdir -p ffmpeg-win-x64/libavcodec
mkdir -p ffmpeg-win-x64/libavformat
mkdir -p ffmpeg-win-x64/libavutil
mkdir -p ffmpeg-win-x64/libswresample

cp libavcodec/*euterpe-*.dll ffmpeg-win-x64
cp libavutil/*euterpe-*.dll ffmpeg-win-x64
cp libavformat/*euterpe-*.dll ffmpeg-win-x64
cp libswresample/*euterpe-*.dll ffmpeg-win-x64
strip ffmpeg-win-x64/*.dll

cp libavcodec/*euterpe-*.def ffmpeg-win-x64
cp libavutil/*euterpe-*.def ffmpeg-win-x64
cp libavformat/*euterpe-*.def ffmpeg-win-x64
cp libswresample/*euterpe-*.def ffmpeg-win-x64

cp libavcodec/*.h  ffmpeg-win-x64/libavcodec/
cp libavformat/*.h ffmpeg-win-x64/libavformat/
cp libavutil/*.h ffmpeg-win-x64/libavutil/
cp libswresample/*.h ffmpeg-win-x64/libswresample/

