#!/bin/sh
#--arch=x86/x86_64 --cpu=i686/generic
#--disable-runtime-cpudetect \
#--enable-libmp3lame \
export CFLAGS=-static-libgcc
export CXXFLAGS=-static-libgcc
export LDFLAGS=-static-libgcc
./configure --target-os=mingw32 \
--cross-prefix=i686-w64-mingw32- \
--disable-x86asm \
--arch=x86 \
--cpu=generic \
--disable-static \
--enable-shared \
--build-suffix=-euterpe \
--prefix=./out \
--disable-programs \
--disable-doc \
--disable-avdevice \
--disable-swscale \
--disable-postproc \
--disable-avfilter \
--disable-network \
--disable-dxva2 \
--disable-vaapi \
--disable-vdpau \
--disable-everything \
--disable-iconv \
--disable-debug \
--disable-audiotoolbox \
--disable-cuda \
--disable-cuvid \
--disable-d3d11va \
--disable-dxva2 \
--disable-nvenc \
--disable-vaapi \
--disable-vdpau \
--disable-videotoolbox \
--disable-schannel \
--disable-xlib \
--disable-protocols \
--disable-asm \
--enable-small \
--enable-swresample \
--enable-runtime-cpudetect \
--enable-stripping \
--enable-protocol=file \
--enable-demuxer=flac \
--enable-demuxer=mp3 \
--enable-decoder=flac \
--enable-decoder=mp3 \
--enable-decoder=mp3float \
--enable-parser=flac \
--enable-parser=mpegaudio \
--enable-decoder=bmp \
--enable-decoder=mjpeg \
--enable-decoder=mjpegb \
--enable-decoder=png \
--enable-demuxer=mjpeg \
--enable-encoder=mjpeg \
--enable-encoder=png \
--enable-muxer=mjpeg \
--enable-muxer=singlejpeg \
--enable-parser=bmp \
--enable-parser=mjpeg \
--enable-parser=png

make -j3

mkdir -p ffmpeg-win-x86
mkdir -p ffmpeg-win-x86/libavcodec
mkdir -p ffmpeg-win-x86/libavformat
mkdir -p ffmpeg-win-x86/libavutil
mkdir -p ffmpeg-win-x86/libswresample

cp libavcodec/*euterpe-*.dll ffmpeg-win-x86
cp libavutil/*euterpe-*.dll ffmpeg-win-x86
cp libavformat/*euterpe-*.dll ffmpeg-win-x86
cp libswresample/*euterpe-*.dll ffmpeg-win-x86
strip ffmpeg-win-x86/*.dll

cp libavcodec/*euterpe-*.def ffmpeg-win-x86
cp libavutil/*euterpe-*.def ffmpeg-win-x86
cp libavformat/*euterpe-*.def ffmpeg-win-x86
cp libswresample/*euterpe-*.def ffmpeg-win-x86

cp libavcodec/*.h  ffmpeg-win-x86/libavcodec/
cp libavformat/*.h ffmpeg-win-x86/libavformat/
cp libavutil/*.h ffmpeg-win-x86/libavutil/
cp libswresample/*.h ffmpeg-win-x86/libswresample/

