/* This file has been modified from Ken Silverman's original release */

  //I would like to thank Giorgos Vougioukas for the following ideas:
  // * Title bar information (SetWindowText())
  // * F1 help dialog

  //KC wishlist:
  // ! fix Shift+Home|End & CTRL+Ins|C|V jumping to end of text when typing too fast
  //      Shift+Home  Ctrl+Ins  End
  //      Shift+End   Ctrl+Ins  Home
  // * try ddraw blit for scrolling?
  // * option to invert colors
  // * split screen
  // * support larger files; don't crash when loading too large files
  // * support various fonts
  // * ME :P
  // * add list&ncd type interface
  // * support wildcards in search..find&change
  //
  //KRaspi port todo:
  // * open/save dialogs
  // * Clipboard (Ctrl+C/Ctrl+V)
  // * eval.c
  // * windowed mode
  // * F5
  // * F2
  // * F4
  // * F6
  // * MessageBox
  // * smartsleep

#define KCMMAJ 1
#define KCMMIN 61
#define KCMVER "1.61"

#include "WDL/eel2/ns-eel.h"
void NSEEL_HOSTSTUB_EnterMutex(){}
void NSEEL_HOSTSTUB_LeaveMutex(){}

#if defined(_MSC_VER)
#if defined(_M_AMD64) || defined(_M_X64)
#define KCMARCH "x64"
#elif defined(_M_IX86)
#define KCMARCH "x86"
#else
#define KCMARCH "unk"
#endif
#elif defined(__linux__) && (defined(__clang__) || defined(__GNUC__))
#if defined(__amd64__) || defined(__X86_64__)
#define KCMARCH "amd64"
#elif defined(__i386__)
#define KCMARCH "i686"
#else
#define KCMARCH "unk"
#endif
#elif defined(__APPLE__) && (defined(__clang__) || defined(__GNUC__))
#if defined(__amd64__) || defined(__X86_64__)
#define KCMARCH "x86-64"
#elif defined(__i386__)
#define KCMARCH "i386"
#else
#define KCMARCH "unk"
#endif
#endif

#if defined(_WIN32) && defined(_DEBUG)
// Oops! Optional.
#include <vld.h>
#endif

#if defined(_WIN32)
#include <windows.h>
#include <mmsystem.h>
#include <commdlg.h>
#include <process.h>
#include <direct.h>
#include <conio.h>
#else
#include "WDL/swell/swell.h"
#include "WDL/swell/swell-functions.h"
#include "WDL/filebrowse.h"
#endif

#include <memory.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <malloc.h>

#include "WDL/wdltypes.h"

#if defined(_WIN32)
#include "cwinmain.h"
#include "WDL/win32_utf8.h"
#include "WDL/wdlutf8.h"
#define LL(l) l##I64
#define PRINTF64 "I64d"
#else
#include "cwinmain.h"
#define LL(l) l##ll
#define PRINTF64 "lld"
//typedef long long __int64;
//#define stricmp strcasecmp

#if !defined(max)
#define max(a,b) (((a) > (b)) ? (a) : (b))
#endif
#if !defined(min)
#define min(a,b) (((a) < (b)) ? (a) : (b))
#endif

#endif

extern int showwindmode;
#if defined(_WIN32)
#include "eval.h"
#endif
static int fixprio = 0;

static tiletype gdd;

#define MAXLINES 4194304 //524288
#define NUMTABSTOPS 2
#define DEFCOL 0x07
#define ALTJCOL 0x17
#define SELCOL 0x70

//#define TXTFILES "C, H, CPP, TXT, JAVA, CS\0*.c;*.h;*.cpp;*.txt;*.java;*.cs\0All files (*.*)\0*.*\0\0"
#define TXTFILES "All supported files\0*.c;*.h;*.cpp;*.cc;*.txt;*.asm;*.s;*.S;*.m;*.mm;*.sql;*.cs;*.java;*.js;*.pl;*.php;*.mak;*.mk;*.sh;*.bat;*.cmd;*.nsi;*.tex;*.lua;*.eel;*.kc;*.html;*.css;*.xml\0"\
  "C files (*.c;*.h)\0*.c;*.h\0"\
  "C++ files (*.cpp;*.h;*.cc)\0*.cpp;*.h;*.cc\0"\
  "Assembly files (*.asm;*.s;*.S)\0*.asm;*.s;*.S\0"\
  "Text files (*.txt)\0*.txt\0"\
  "C# files (*.cs)\0*.cs\0"\
  "Java files (*.java)\0*.java\0"\
  "JavaScript files (*.js)\0*.js\0"\
  "Objective-C files (*.h;*.m;*.mm)\0*.h;*.m;*.mm\0"\
  "SQL files (*.sql)\0*.sql\0"\
  "Perl files (*.pl)\0*.pl\0"\
  "PHP files (*.php)\0*.php\0"\
  "Makefile files (*.mak;*.mk)\0*.mak;*.mk\0"\
  "Shell files (*.sh)\0*.sh\0"\
  "Batch files (*.bat;*.cmd)\0*.bat;*.cmd\0"\
  "NSIS files (*.nsi)\0*.nsi\0"\
  "TeX files (*.tex)\0*.tex\0"\
  "Lua files (*.lua)\0*.lua\0"\
  "EEL2 files (*.eel)\0*.eel\0"\
  "KC files (*.kc)\0*.kc\0"\
  "HTML files (*.html)\0*.html\0"\
  "CSS files (*.css)\0*.css\0"\
  "XML files (*.xml)\0*.xml\0"\
  "All files (*.*)\0*.*\0\0"
#define DEFEXT "c"

static char *buf, *buf2;
static int lineoffs[MAXLINES], lineoffs2[MAXLINES], selshapesave2;
static int numlines = 1, numlines2 = -1;
static INT_PTR cachesize = 0;
static char tempbuf[131072]; //worst case tempbuf memory (3840x2160 res): xdim = 427; ydim = 136; bytesperline = 858; bplo2 = 429; 137*429*2 = 117546 bytes
static int xdim, ydim, bytesperline, charxsiz, charysiz;
static char curfilename[MAX_PATH], lastfilename[MAX_PATH];
static char insertmode = 0, spookymode = 0, linedrawmode = 0;
static char showlinelengthmode = 0, savetab2spc = 1, showfps = 0;
#if defined(_WIN32)
static char savecrlf = 1;
static char maxi = 1;
#else
static char savecrlf = 0;
static char sleepstep = 33;
#endif
static char spooky[27] = "g׭km\x14$w*2";

  //Ŀ ķ ͸ ͻ
  //Ĵ Ķ ͵ ͹ 
  // Ľ ; ͼ
static char linechartable[4][17] = {"ĳ³","ĺкҺ",
                                    "ͳϳѳ","ͺʺ˺"};
static char lineconnect[256] = "CDDD99DC9555967BE3FEE6A7BE3F77DB66AAFF5A";

static signed int textfont9x16[256][4] =
{
  0x00000000,0x00000000,0x00000000,0x00000000,0x3c000000,0xa581a542,0x003c4299,0x00000000,
  0x3c000000,0xdbffdb7e,0x003c7ee7,0x00000000,0x00000000,0xfefefe6c,0x0010387c,0x00000000,
  0x00000000,0xfe7c3810,0x0010387c,0x00000000,0x00000000,0xfed63838,0x003810d6,0x00000000,
  0x10000000,0xfefe7c38,0x00381054,0x00000000,0x00000000,0x5c5c5c38,0x10fefe5c,0x00000000,
  0x00000000,0x82de6c38,0x00386cde,0x00000000,0x00000000,0x00000000,0x00000000,0x000000db,
  0x00000000,0xaaee6c38,0x00386cc6,0x00000000,0x0e1e0000,0xcc78321a,0x78cccccc,0x00000000,
  0x663c0000,0x3c666666,0x18187e18,0x00000000,0x18180000,0x18181818,0x70783818,0x00000000,
  0x730f0000,0x6363736f,0xe6e76763,0x000000c0,0x10000000,0xee385492,0x10925438,0x00000000,
  0xf0e0c080,0xfffefcf8,0xf0f8fcfe,0x0080c0e0,0x0f070301,0xff7f3f1f,0x0f1f3f7f,0x00010307,
  0x26140800,0x0808087f,0x7f080808,0x00081426,0x66660000,0x66666666,0x66660066,0x00000000,
  0xdb7f0000,0x1b7bdbdb,0x1b1b1b1b,0x00000000,0x60c67c00,0xc6c66c38,0xc60c386c,0x0000007c,
  0x00000000,0x00000000,0xfefefefe,0x00000000,0x26140800,0x0808087f,0x7f080808,0x007f1426,
  0x26140800,0x0808087f,0x08080808,0x00080808,0x08080800,0x08080808,0x7f080808,0x00081426,
  0x00000000,0xf90a0c08,0x00080c0e,0x00000000,0x00000000,0x9f503010,0x00103070,0x00000000,
  0x00000000,0xc0c0c000,0x0000fec0,0x00000000,0x00000000,0xff662400,0x00002466,0x00000000,
  0x00000000,0x14080000,0x00007f26,0x00000000,0x00000000,0x267f0000,0x00000814,0x00000000,
  0x00000000,0x00000000,0x00000000,0x00000000,0x3c180000,0x183c3c3c,0x18180018,0x00000000,
  0x66666600,0x00000024,0x00000000,0x00000000,0x6c000000,0x6c6cfe6c,0x006c6cfe,0x00000000,
  0xd67c1010,0x1c3870d6,0x7cd6d616,0x00001010,0x00000000,0x180cc6c2,0x86c66030,0x00000000,
  0x6c380000,0xdc76386c,0x76cccccc,0x00000000,0x30303000,0x00000060,0x00000000,0x00000000,
  0x180c0000,0x30303030,0x0c183030,0x00000000,0x18300000,0x0c0c0c0c,0x30180c0c,0x00000000,
  0x00000000,0xff3c6600,0x0000663c,0x00000000,0x00000000,0xff181800,0x00001818,0x00000000,
  0x00000000,0x00000000,0x18181800,0x00000030,0x00000000,0xff000000,0x00000000,0x00000000,
  0x00000000,0x00000000,0x18180000,0x00000000,0x00000000,0x180c0602,0x80c06030,0x00000000,
  0xc67c0000,0xd6d6cec6,0x7cc6c6e6,0x00000000,0x38180000,0x18181878,0x7e181818,0x00000000,
  0xc67c0000,0x30180c06,0xfec6c060,0x00000000,0xc67c0000,0x063c0606,0x7cc60606,0x00000000,
  0x1c0c0000,0xfecc6c3c,0x1e0c0c0c,0x00000000,0xc0fe0000,0x0efcc0c0,0x7cc60606,0x00000000,
  0x60380000,0xc6fcc0c0,0x7cc6c6c6,0x00000000,0xc6fe0000,0x180c0606,0x30303030,0x00000000,
  0xc67c0000,0xc67cc6c6,0x7cc6c6c6,0x00000000,0xc67c0000,0x067ec6c6,0x780c0606,0x00000000,
  0x00000000,0x00001818,0x00181800,0x00000000,0x00000000,0x00001818,0x30181800,0x00000000,
  0x06000000,0x6030180c,0x060c1830,0x00000000,0x00000000,0x00fe0000,0x0000fe00,0x00000000,
  0x60000000,0x060c1830,0x6030180c,0x00000000,0xc67c0000,0x18180cc6,0x18180018,0x00000000,
  0x7c000000,0xdedec6c6,0x7cc0dcde,0x00000000,0x38100000,0xfec6c66c,0xc6c6c6c6,0x00000000,
  0x66fc0000,0x667c6666,0xfc666666,0x00000000,0x663c0000,0xc0c0c0c2,0x3c66c2c0,0x00000000,
  0x6cf80000,0x66666666,0xf86c6666,0x00000000,0x66fe0000,0x68786862,0xfe666260,0x00000000,
  0x66fe0000,0x68786862,0xf0606060,0x00000000,0x663c0000,0xdec0c0c2,0x3a66c6c6,0x00000000,
  0xc6c60000,0xc6fec6c6,0xc6c6c6c6,0x00000000,0x183c0000,0x18181818,0x3c181818,0x00000000,
  0x0c1e0000,0x0c0c0c0c,0x78cccccc,0x00000000,0x66e60000,0x78786c6c,0xe666666c,0x00000000,
  0x60f00000,0x60606060,0xfe666260,0x00000000,0xe7c30000,0xc3dbdbff,0xc3c3c3c3,0x00000000,
  0xe6c60000,0xcedefef6,0xc6c6c6c6,0x00000000,0x6c380000,0xc6c6c6c6,0x386cc6c6,0x00000000,
  0x66fc0000,0x607c6666,0xf0606060,0x00000000,0xc67c0000,0xc6c6c6c6,0x7cded6c6,0x00000e0c,
  0x66fc0000,0x6c7c6666,0xe6666666,0x00000000,0xc67c0000,0x0c3860c6,0x7cc6c606,0x00000000,
  0xdbff0000,0x18181899,0x3c181818,0x00000000,0xc6c60000,0xc6c6c6c6,0x7cc6c6c6,0x00000000,
  0xc6c60000,0xc6c6c6c6,0x10386cc6,0x00000000,0xc3c30000,0xdbc3c3c3,0x6666ffdb,0x00000000,
  0xc6c60000,0x38386c6c,0xc6c66c6c,0x00000000,0x66660000,0x183c6666,0x3c181818,0x00000000,
  0xc3ff0000,0x180c0683,0xffc36130,0x00000000,0x303e0000,0x30303030,0x3e303030,0x00000000,
  0x80000000,0x3870e0c0,0x02060e1c,0x00000000,0x063e0000,0x06060606,0x3e060606,0x00000000,
  0xc66c3810,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x0000ff00,
  0x00183030,0x00000000,0x00000000,0x00000000,0x00000000,0x7c0c7800,0x76cccccc,0x00000000,
  0x60e00000,0x666c7860,0xdc666666,0x00000000,0x00000000,0xc0c67c00,0x7cc6c0c0,0x00000000,
  0x0c1c0000,0xcc6c3c0c,0x76cccccc,0x00000000,0x00000000,0xfec67c00,0x7cc6c0c0,0x00000000,
  0x6c380000,0x60f06064,0xf0606060,0x00000000,0x00000000,0xcccc7600,0x7ccccccc,0x0078cc0c,
  0x60e00000,0x66766c60,0xe6666666,0x00000000,0x18180000,0x18183800,0x3c181818,0x00000000,
  0x06060000,0x06060e00,0x06060606,0x003c6666,0x60e00000,0x786c6660,0xe6666c78,0x00000000,
  0x18380000,0x18181818,0x3c181818,0x00000000,0x00000000,0xdbffe600,0xdbdbdbdb,0x00000000,
  0x00000000,0x6666dc00,0x66666666,0x00000000,0x00000000,0xc6c67c00,0x7cc6c6c6,0x00000000,
  0x00000000,0x6666dc00,0x7c666666,0x00f06060,0x00000000,0xcccc7600,0x7ccccccc,0x001e0c0c,
  0x00000000,0x6276dc00,0xf0606060,0x00000000,0x00000000,0x60c67c00,0x7cc60c38,0x00000000,
  0x30100000,0x3030fc30,0x1c363030,0x00000000,0x00000000,0xcccccc00,0x76cccccc,0x00000000,
  0x00000000,0x66666600,0x183c6666,0x00000000,0x00000000,0xc3c3c300,0x66ffdbdb,0x00000000,
  0x00000000,0x386cc600,0xc66c3838,0x00000000,0x00000000,0xc6c6c600,0x7ec6c6c6,0x00f80c06,
  0x00000000,0x18ccfe00,0xfec66030,0x00000000,0x180e0000,0x18701818,0x0e181818,0x00000000,
  0x18180000,0x18001818,0x18181818,0x00000000,0x18700000,0x180e1818,0x70181818,0x00000000,
  0xdc760000,0x00000000,0x00000000,0x00000000,0x00000000,0xc66c3810,0x00fec6c6,0x00000000,
  0x663c0000,0xc0c0c0c2,0x3c66c2c0,0x00007804,0xcccc0000,0xcccccc00,0x76cccccc,0x00000000,
  0x30180c00,0xfec67c00,0x7cc6c0c0,0x00000000,0x6c381000,0x7c0c7800,0x76cccccc,0x00000000,
  0xcccc0000,0x7c0c7800,0x76cccccc,0x00000000,0x18306000,0x7c0c7800,0x76cccccc,0x00000000,
  0x386c3800,0x7c0c7800,0x76cccccc,0x00000000,0x00000000,0xc0c67c00,0x7cc6c0c0,0x00007808,
  0x6c381000,0xfec67c00,0x7cc6c0c0,0x00000000,0xc6c60000,0xfec67c00,0x7cc6c0c0,0x00000000,
  0x18306000,0xfec67c00,0x7cc6c0c0,0x00000000,0x66660000,0x18183800,0x3c181818,0x00000000,
  0x663c1800,0x18183800,0x3c181818,0x00000000,0x18306000,0x18183800,0x3c181818,0x00000000,
  0x3810c6c6,0xfec6c66c,0xc6c6c6c6,0x00000000,0x38103838,0xfec6c66c,0xc6c6c6c6,0x00000000,
  0x66fe3018,0x68786862,0xfe666260,0x00000000,0x00000000,0x1b3b6e00,0x77dcd87e,0x00000000,
  0x6c3e0000,0xccfecccc,0xcecccccc,0x00000000,0x6c381000,0xc6c67c00,0x7cc6c6c6,0x00000000,
  0xc6c60000,0xc6c67c00,0x7cc6c6c6,0x00000000,0x18306000,0xc6c67c00,0x7cc6c6c6,0x00000000,
  0xcc783000,0xcccccc00,0x76cccccc,0x00000000,0x18306000,0xcccccc00,0x76cccccc,0x00000000,
  0xc6c60000,0xc6c6c600,0x7ec6c6c6,0x00f80c06,0x6c38c6c6,0xc6c6c6c6,0x386cc6c6,0x00000000,
  0xc600c6c6,0xc6c6c6c6,0x7cc6c6c6,0x00000000,0x10000000,0xd0d67c10,0x7cd6d0d0,0x00001010,
  0x646c3800,0x6060f060,0xfce66060,0x00000000,0x66c30000,0x187e183c,0x1818187e,0x00000000,
  0x6666fc00,0x6f66627c,0xf3666666,0x00000000,0x181b0e00,0x187e1818,0x18181818,0x000070d8,
  0x60301800,0x7c0c7800,0x76cccccc,0x00000000,0x30180c00,0x18183800,0x3c181818,0x00000000,
  0x60301800,0xc6c67c00,0x7cc6c6c6,0x00000000,0x60301800,0xcccccc00,0x76cccccc,0x00000000,
  0xdc760000,0x6666dc00,0x66666666,0x00000000,0xc600dc76,0xcedef6e6,0xc6c6c6c6,0x00000000,
  0x6c6c3c00,0x007e003e,0x00000000,0x00000000,0x6c6c3800,0x007c0038,0x00000000,0x00000000,
  0x30300000,0x60303000,0x7cc6c6c0,0x00000000,0x00000000,0xc0fe0000,0x00c0c0c0,0x00000000,
  0x00000000,0x06fe0000,0x00060606,0x00000000,0xc2400000,0x2c104844,0x1e088452,0x00000000,
  0xc2400000,0x24104844,0x043e944c,0x00000000,0x18180000,0x3c181800,0x183c3c3c,0x00000000,
  0x00000000,0xcc663300,0x00003366,0x00000000,0x00000000,0x3366cc00,0x0000cc66,0x00000000,
  0x00490092,0x00490092,0x00490092,0x00490092,0xdb49db49,0xdb49db49,0xdb49db49,0xdb49db49,
  0xdbdbdbdb,0xdbdbdbdb,0xdbdbdbdb,0xdbdbdbdb,0x18181818,0x18181818,0x18181818,0x18181818,
  0x18181818,0xf8381818,0x181838f8,0x18181818,0x18181818,0x18f81818,0x181818f8,0x18181818,
  0x14141414,0xf4341414,0x141434f4,0x14141414,0x00000000,0xe0000000,0x14142cf8,0x14141414,
  0x00000000,0x30e00000,0x181838d8,0x18181818,0x14141414,0x04c42414,0x141424c4,0x14141414,
  0x14141414,0x14141414,0x14141414,0x14141414,0x00000000,0x30c00000,0x141428c8,0x14141414,
  0x14141414,0x30c82814,0x000000c0,0x00000000,0x14141414,0xf82c1414,0x000000e0,0x00000000,
  0x18181818,0x30d83818,0x000000e0,0x00000000,0x00000000,0x80000000,0x383070e0,0x18181818,
  0x18181818,0x070e0c1c,0x00000001,0x00000000,0x18181818,0xff3c1818,0x000000ff,0x00000000,
  0x00000000,0xff000000,0x18183cff,0x18181818,0x18181818,0x1f1c1818,0x18181c1f,0x18181818,
  0x00000000,0xff000000,0x000000ff,0x00000000,0x18181818,0xff3c1818,0x18183cff,0x18181818,
  0x18181818,0x181f1818,0x1818181f,0x18181818,0x14141414,0x17161414,0x14141617,0x14141414,
  0x14141414,0x06090a14,0x00000001,0x00000000,0x00000000,0x06010000,0x14140a09,0x14141414,
  0x14141414,0x00c12214,0x000000ff,0x00000000,0x00000000,0x00ff0000,0x141422c1,0x14141414,
  0x14141414,0x10111214,0x14141211,0x14141414,0x00000000,0x00ff0000,0x000000ff,0x00000000,
  0x14141414,0x00c12214,0x141422c1,0x14141414,0x18181818,0x00ff3c18,0x000000ff,0x00000000,
  0x14141414,0xff141414,0x000000ff,0x00000000,0x00000000,0x00ff0000,0x18183cff,0x18181818,
  0x00000000,0xff000000,0x141414ff,0x14141414,0x14141414,0x0f1a1414,0x00000003,0x00000000,
  0x18181818,0x0c1b1c18,0x00000007,0x00000000,0x00000000,0x0c070000,0x18181c1b,0x18181818,
  0x00000000,0x03000000,0x14141a0f,0x14141414,0x14141414,0xff141414,0x141414ff,0x14141414,
  0x18181818,0x18ff1818,0x181818ff,0x18181818,0x18181818,0xe0703038,0x00000080,0x00000000,
  0x00000000,0x01000000,0x1c0c0e07,0x18181818,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
  0x00000000,0x00000000,0xffffffff,0xffffffff,0xf0f0f0f0,0xf0f0f0f0,0xf0f0f0f0,0xf0f0f0f0,
  0x0f0f0f0f,0x0f0f0f0f,0x0f0f0f0f,0x0f0f0f0f,0xffffffff,0xffffffff,0x00000000,0x00000000,
  0x00000000,0xd8dc7600,0x76dcd8d8,0x00000000,0x00000000,0xc6c6fc00,0xfcc6c6fc,0x0000c0c0,
  0xc6fe0000,0xc0c0c0c6,0xc0c0c0c0,0x00000000,0x00000000,0x6c6cfe00,0x6c6c6c6c,0x00000000,
  0xc6fe0000,0x18183060,0xfec66030,0x00000000,0x00000000,0xd8d87e00,0x70d8d8d8,0x00000000,
  0x00000000,0x66666600,0x7c666666,0x0000c060,0x00000000,0x18dc7600,0x18181818,0x00000000,
  0x187e0000,0x6666663c,0x7e183c66,0x00000000,0x00000000,0xc66c3800,0x386cc6fe,0x00000000,
  0x6c380000,0x6cc6c6c6,0xee6c6c6c,0x00000000,0x301e0000,0x663e0c18,0x3c666666,0x00000000,
  0x00000000,0xdbdb7e00,0x00007edb,0x00000000,0x03000000,0xdbcf7e06,0xc0607ef3,0x00000000,
  0x301c0000,0x607c6060,0x1c306060,0x00000000,0x7c000000,0xc6c6c6c6,0xc6c6c6c6,0x00000000,
  0x00000000,0xfe0000fe,0x00fe0000,0x00000000,0x00000000,0x187e1818,0x7e000018,0x00000000,
  0x30000000,0x0c060c18,0x7e003018,0x00000000,0x0c000000,0x30603018,0x7e000c18,0x00000000,
  0x1b0e0000,0x1818181b,0x18181818,0x18181818,0x18181818,0x18181818,0x70d8d8d8,0x00000000,
  0x00000000,0xff001818,0x00181800,0x00000000,0x00000000,0x00dc7600,0x0000dc76,0x00000000,
  0x6c6c3800,0x00000038,0x00000000,0x00000000,0x00000000,0x18000000,0x00000018,0x00000000,
  0x00000000,0x00000000,0x00000018,0x00000000,0x18181f00,0x18181818,0x183878d8,0x00000000,
  0x6c6cd800,0x006c6c6c,0x00000000,0x00000000,0x30987000,0x00f8c860,0x00000000,0x00000000,
  0x00000000,0x7c7c7c7c,0x007c7c7c,0x00000000,0x806010e0,0x38203cf0,0x080f3804,0x000e010e,
};

static int lasttlx, lasttly, lastcurx, lastcury, lastotlx, lastotly;
static int lastgoalx, lastgoaly;

static int tlx = 0, tly = 0, curx = 0, cury = 0, otlx = 0, otly = 0, scrolled = 0;
static int goalx = -1, goaly = 0;
static int mousxplc, mousyplc;
static int gclipcurs = 0, gshowcurs = 0;
#if defined(_WIN32) || defined(_WDL_SWELL_H_)
static RECT gcursoldclip;
#endif
static int selx0, sely0, selx1, sely1, selmode = 0, selshape = 0;
  //selmode:
  //   0=no highlight
  //   1=live highlight (selx1&sely1 update while shift|(bstatus&1) down)
  //   2=dead highlight (disappears at next cursormove)
  //selshape:
  //   0=full line capture
  //   1=box capture

static void rmemmove (void *d, void *s, int c) { memmove(&((char *)d)[-c],&((char *)s)[-c],c); }

static short textfont2[256*16];
static const int paldos[16] =
{
  0x000000,0x0000aa,0x00aa00,0x00aaaa,0xaa0000,0xaa00aa,0xaa5500,0xaaaaaa,
  0x555555,0x5555ff,0x55ff55,0x55ffff,0xff5555,0xff55ff,0xffff55,0xffffff
};
static char pal_8[256*2];
static int pal_32[256*2];
static double otim, tim, dtim;
static int totclk;

#if defined(_WIN32) || defined(_WDL_SWELL_H_)

static void settitle (int chg)
{
  static int changed = 0;
  int i, j = 0;
  if (chg && changed) return;
  changed = chg;
  for(i=0;curfilename[i];i++) { if (curfilename[i] == WDL_DIRCHAR) j = i+1; }
  if (strlen(KCMVER) > 4) sprintf(tempbuf,"KCm " KCMVER " - %s%s",chg ? "*" : "",&curfilename[j]);
  else sprintf(tempbuf,"KCm - %s%s",chg ? "*" : "",&curfilename[j]);
  SetWindowText(ghwnd,tempbuf);
}

#else

static void settitle (int chg) {} //TODO!

#endif

//----------------------  WIN file select code begins ------------------------

#if defined(_WIN32)

static char relpathbase[MAX_PATH];
static void relpathinit (char *st)
{
  int i;

  for(i=0;st[i];i++) relpathbase[i] = st[i];
  if ((i) && (relpathbase[i-1] != '/') && (relpathbase[i-1] != '\\'))
    relpathbase[i++] = '\\';
  relpathbase[i] = 0;
}

static char fileselectnam[MAX_PATH+1];
static char *loadfileselect (char *mess, char *spec, char *defext)
{
  int i;
  for(i=0;fileselectnam[i];i++) if (fileselectnam[i] == '/') fileselectnam[i] = '\\';
  OPENFILENAME ofn =
  {
    sizeof(OPENFILENAME),ghwnd,0,spec,0,0,1,fileselectnam,MAX_PATH,0,0,relpathbase,mess,
    OFN_HIDEREADONLY,0,0,defext,0,0,0
  };
  if (!GetOpenFileName(&ofn)) return(0); else return(fileselectnam);
}
static char *savefileselect (char *mess, char *spec, char *defext)
{
  int i;
  for(i=0;fileselectnam[i];i++) if (fileselectnam[i] == '/') fileselectnam[i] = '\\';
  OPENFILENAME ofn =
  {
    sizeof(OPENFILENAME),ghwnd,0,spec,0,0,1,fileselectnam,MAX_PATH,0,0,relpathbase,mess,
    OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,0,0,defext,0,0,0
  };
  if (!GetSaveFileName(&ofn)) return(0); else return(fileselectnam);
}

  //Helper function for 'F5' key.
  //cmd: spawn command line. Note: "2>nul" doesn't work!
  //sobuf,sosiz: stdout of spawned application
  //sebuf,sesiz: stderr of spawned application
static int mypopen (char *exenam, char *cmd, char *sobuf, int sosiz, char *sebuf, int sesiz)
{
  SECURITY_ATTRIBUTES sa;
  PROCESS_INFORMATION pi;
  STARTUPINFO si;
  HANDLE sor, sow, ser, sew, cor2, cer2;
  int i, isalloced;
  unsigned long u;
  char ch;

    //Create new pipe for child STDOUT
  sa.nLength = sizeof(SECURITY_ATTRIBUTES);
  sa.bInheritHandle = 1;
  sa.lpSecurityDescriptor = 0;
  if (!CreatePipe(&sor,&sow,&sa,0)) return(-1);
  if (!CreatePipe(&ser,&sew,&sa,0)) return(-2);

  isalloced = AllocConsole();

    //Set parent STDOUT to pipe write handle, so it's inherited by child
  if (!SetStdHandle(STD_OUTPUT_HANDLE,sow)) { if (isalloced) FreeConsole(); return(-3); }
    //Create noninheritable duplicate of read handle & close inheritable read handle
  if (!DuplicateHandle(GetCurrentProcess(),sor,GetCurrentProcess(),&cor2,0,0,DUPLICATE_SAME_ACCESS))
    { if (isalloced) FreeConsole(); return(-4); }
  CloseHandle(sor);

    //Set parent STDERR to pipe write handle, so it's inherited by child
  if (!SetStdHandle(STD_ERROR_HANDLE,sew)) { if (isalloced) FreeConsole(); return(-5); }
    //Create noninheritable duplicate of read handle & close inheritable read handle
  if (!DuplicateHandle(GetCurrentProcess(),ser,GetCurrentProcess(),&cer2,0,0,DUPLICATE_SAME_ACCESS))
    { if (isalloced) FreeConsole(); return(-6); }
  CloseHandle(ser);

  memset(&pi,0,sizeof(pi));
  memset(&si,0,sizeof(si)); si.cb = sizeof(si);
  if (!CreateProcess(exenam,cmd,0,0,1,0,0,0,&si,&pi))
  {
    if (isalloced) FreeConsole();
    return(-7);
  }

    //Required for Windows 10 or else "The application was unable to start correctly (0xc0000142). Click OK to close the application."
  for(i=GetTickCount();GetTickCount() < i+512;) { if (GetExitCodeProcess(pi.hProcess,&u)) { if (u != STILL_ACTIVE) break; } }

  if (isalloced) FreeConsole();

  if (!CloseHandle(sow)) return(-8);
  if (!CloseHandle(sew)) return(-9);

  i = 0;
  while (1)
  {
    if (!ReadFile(cor2,&ch,1,&u,0)) break;
    if ((i < sosiz-1) && (ch)) sobuf[i++] = ch;
  }
  sobuf[i] = 0;

  i = 0;
  while (1)
  {
    if (!ReadFile(cer2,&ch,1,&u,0)) break;
    if ((i < sesiz-1) && (ch)) sebuf[i++] = ch;
  }
  sebuf[i] = 0;

  return(0);
}

#define TESTRENDERSPEED 0
#if (TESTRENDERSPEED == 1)
static _inline __int64 rdtsc64 (void)
{
  __int64 q;
  _asm
  {
    rdtsc
    mov dword ptr q[0], eax
    mov dword ptr q[4], edx
  }
  return(q);
}
#endif

#else

static char relpathbase[MAX_PATH];
static void relpathinit (char *st) { relpathbase[0] = 0; }
static char fileselectnam[MAX_PATH+1];

static char *loadfileselect (char *mess, char *spec, char *defext)
{
  char *fn = (char *)calloc(MAX_PATH+1,sizeof(char));
  fn = WDL_ChooseFileForOpen(ghwnd,"Open file",NULL,NULL,TXTFILES,DEFEXT,true,false);
  if (fn) { strcpy(fileselectnam,fn); free(fn); return(fileselectnam); }
  free(fn); return(0);
}
static char *savefileselect (char *mess, char *spec, char *defext)
{
  if (WDL_ChooseFileForSave(ghwnd,"Save file",NULL,NULL,TXTFILES,DEFEXT,true,fileselectnam,sizeof(fileselectnam)))
  {
    return(fileselectnam);
  }
  return(0);
}
static int mypopen (char *exenam, char *cmd, char *sobuf, int sosiz, char *sebuf, int sesiz) { return(-1); }

#endif

enum { LINEDRAWDIALOG,SEARCHDIALOG,FILEDIALOG,CHANGEYNADIALOG,\
     GOTODIALOG,FINDDIALOG,CHANGE0DIALOG,CHANGE1DIALOG,SETTABDIALOG,\
     OPENDIALOG,SAVEASDIALOG,INFODIALOG,VCERRDIALOG,GCCERRDIALOG,JAVERRDIALOG,NODIALOG };
static char kdialog[4096] = {0};
static int kdiacol, kdiacol2, kdiamode = NODIALOG, kdiagets0, kdiagets1, kdiacursor;
static int kdiafirstime, kdiamatchwordncase = 0;
static int kdiaxsiz, kdiaysiz; //Used with VCERRDIALOG/GCCERRDIALOG/JAVERRDIALOG only

#pragma warning(push)
#pragma warning(disable:4731) //I use a trick with ebp ;)
static void drawscreen (void)
{
  int i, j, k, x, y, start, end, ix, iy, x0, y0, x1, y1;
  int cursx, cursy, stx, sty, icol, bplo2;
  short *sptr;
  char ch, *cptr, dabuf[48];
#if (TESTRENDERSPEED == 1)
  __int64 t0, t1;
#endif

  if (!startdirectdraw(&gdd.f,&gdd.p,&gdd.x,&gdd.y)) return;
  if ((gdd.x <= 0) || (gdd.y <= 0) || (!gdd.f)) { stopdirectdraw(); return; }

  xdim = (gdd.x/charxsiz)+1; bytesperline = (xdim<<1)+4; bplo2 = (bytesperline>>1);
  ydim = (gdd.y/charysiz)+1;

#if (TESTRENDERSPEED == 1)
  t0 = rdtsc64();
#endif

  ix = (tlx>>8); iy = (tly>>8);

  sptr = (short *)tempbuf;
  for(y=0;y<=ydim;y++)
  {
    if (y+iy >= numlines)
    {
      for(x=0;x<bplo2;x++) *sptr++ = (DEFCOL<<8)+0x20;
      continue;
    }
    i = lineoffs[y+iy]+ix;
    end = lineoffs[y+iy+1];
    for(x=0;x<bplo2;x++)
    {
      if (i >= end)
      {
        for(;x<bplo2;x++) *sptr++ = (DEFCOL<<8)+0x20;
        break;
      }

      ch = buf[i++];
      if (spookymode)
        if (((ch >= 65) && (ch <= 90)) || ((ch >= 97) && (ch <= 122)))
          ch = spooky[(ch&31)-1];

      if (showlinelengthmode) *sptr++ = (ALTJCOL<<8)+ch; else
                      *sptr++ = (DEFCOL<<8)+ch;
    }
  }

  if (selmode)
  {
    x0 = min(selx0,selx1)-ix; if (x0 < 0) x0 = 0;
    x1 = max(selx0,selx1)-ix; if (x1 > bplo2-1) x1 = bplo2-1;
    y0 = min(sely0,sely1)-iy; if (y0 < 0) y0 = 0;
    y1 = max(sely0,sely1)-iy; if (y1 > ydim) y1 = ydim;
    if (!selshape)
    {
      if (sely0 == sely1)
      {
        if ((unsigned)(sely0-iy) < (unsigned)ydim)
        {
          i = lineoffs[sely0+1]-lineoffs[sely0]-ix; if (x1 > i) x1 = i;
          for(i=x0;i<x1;i++)
            *(char *)(((INT_PTR)tempbuf)+y0*bytesperline+(i<<1)+1) = SELCOL;
        }
      } else
      {
        for(y=y0;y<=y1;y++)
          for(x=0;x<bplo2;x++)
            *(char *)(((INT_PTR)tempbuf)+y*bytesperline+(x<<1)+1) = SELCOL;
      }
    } else
    {
      for(y=y0;y<=y1;y++)
        for(x=x0;x<=x1;x++)
          *(char *)(((INT_PTR)tempbuf)+y*bytesperline+(x<<1)+1) = SELCOL;
    }
  }

    //Show mouse cursor
  cptr = (char *)(((INT_PTR)tempbuf)+(((tly&255)+mousyplc)>>8)*bytesperline+(((mousxplc+(tlx&255))>>8)<<1)+1);
  *cptr = 0x40;

  INT_PTR slptr;
  int *lptr, *lptrend, nxsiz4, curscol, ich, *ppal, v0, v1;
  short *tf2;
  char *cptr2;
  stx = (((tlx&255)*charxsiz)>>8);
  sty = (((tly&255)*charysiz)>>8);
  iy = (sty%charysiz); tf2 = &textfont2[iy*256];
  cptr2 = tempbuf;
#if (defined(_WIN32)) && (!defined(_WIN64))
  stx = (0x400001<<stx);
#endif
  slptr = gdd.f;
  nxsiz4 = -(gdd.x<<2);
  for(y=0;y<gdd.y;y++,slptr+=gdd.p)
  {
#if (!defined(_WIN32)) || defined(_WIN64)
    lptrend = (int *)(slptr-nxsiz4);
    lptr = (int *)slptr; ix = stx; cptr = cptr2; ich = (int)tf2[cptr[0]]; ppal = &pal_32[((int)cptr[1])*2]; cptr += 2;
#if 0
      //RPi3:45.4fps
    do
    {
      *lptr++ = ppal[(ich>>ix)&1];
      ix++; if (ix >= 9) { ix = 0; ich = (int)tf2[cptr[0]]; ppal = &pal_32[((int)cptr[1])*2]; cptr += 2; }
    } while (lptr < lptrend);
#else
      //RPi3:98.7fps
    while (lptr < lptrend) { *lptr++ = ppal[(ich>>ix)&1]; ix++; if (ix >= 9) break; }
    lptrend -= 8;
    while (lptr < lptrend)
    {
      ich = (int)tf2[cptr[0]]; ppal = &pal_32[((int)cptr[1])*2]; cptr += 2;
      v0 = ppal[0]; v1 = ppal[1];
      lptr[0] = (ich&1)?v1:v0;
      lptr[1] = (ich&2)?v1:v0;
      lptr[2] = (ich&4)?v1:v0;
      lptr[3] = (ich&8)?v1:v0;
      lptr[4] = (ich&16)?v1:v0;
      lptr[5] = (ich&32)?v1:v0;
      lptr[6] = (ich&64)?v1:v0;
      lptr[7] = (ich&128)?v1:v0;
      lptr[8] = (ich&256)?v1:v0;
      lptr += 9;
    }
    lptrend += 8; ich = (int)tf2[cptr[0]]; ppal = &pal_32[((int)cptr[1])*2]; ix = 0;
    while (lptr < lptrend) { *lptr++ = ppal[(ich>>ix)&1]; ix++;   }
#endif
#else
    _asm
    {
      mov ebx, stx
      mov esi, cptr2
      xor eax, eax
      movd mm1, tf2
      movd mm2, ebp

      mov edi, nxsiz4
      mov ebp, slptr
      sub ebp, edi
      sar edi, 2

      mov al, [esi]
      movd ecx, mm1
      movzx ecx, word ptr [ecx+eax*2]
      mov al, [esi+1]
      lea edx, pal_32[eax*8]
begit0_32:  test ecx, ebx
      setnz al
      movd mm0, [edx+eax*4] ;lookup color (pal_32)
      movd [edi*4+ebp], mm0
      add ebx, ebx
      js short prebegit_32
      inc edi
      jnz short begit0_32
      jmp short endit_32

prebegit_32:inc edi
      jz short endit_32
      mov ebx, 0x400001
      add esi, 2
      mov al, [esi]
      movd ecx, mm1
      movzx ecx, word ptr [ecx+eax*2]
      mov al, [esi+1]
      lea edx, pal_32[eax*8]
begit_32:   test ecx, ebx         ;LOOP#0 (expanded 3x to allow perfect branching)
      setnz al
      movd mm0, [edx+eax*4] ;lookup color (pal_32)
      movd [edi*4+ebp], mm0
      add ebx, ebx
      inc edi
      jz short endit_32
      test ecx, ebx         ;LOOP#1
      setnz al
      movd mm0, [edx+eax*4] ;lookup color (pal_32)
      movd [edi*4+ebp], mm0
      add ebx, ebx
      inc edi
      jz short endit_32
      test ecx, ebx         ;LOOP#2
      setnz al
      movd mm0, [edx+eax*4] ;lookup color (pal_32)
      movd [edi*4+ebp], mm0
      add ebx, ebx
      js short prebegit_32
      inc edi
      jnz short begit_32
endit_32:   movd ebp, mm2
    }
#endif
    iy++; tf2 += 256;
    if (iy >= charysiz) { iy = 0; cptr2 += bytesperline; tf2 = textfont2; }
  }
#if defined(_WIN32) && (!defined(_WIN64))
  _asm emms
#endif

#if (TESTRENDERSPEED == 1)
  t1 = rdtsc64();
#endif

    //Display column:line info
  sprintf(dabuf,"%ld:%ld:%ld %s %s",
    curx+1,cury+1,numlines,
    savecrlf ? "CRLF" : "LF",
    savetab2spc ? "SPACE" : "TAB");
  stx = gdd.x-charxsiz*strlen(dabuf);
  sty = gdd.y-charysiz;
  slptr = sty*gdd.p+(stx<<2)+gdd.f;
  iy = 0; icol = 0x08*2; j = (1<<charxsiz);
  for(y=sty;y<gdd.y;y++,slptr+=gdd.p)
  {
    ix = 1; i = 0;
    ich = textfont2[(int)dabuf[i]+iy];
    lptr = (int *)slptr;
    for(x=stx;x<gdd.x;x++)
    {
      *lptr++ = pal_32[((ich&ix) != 0)+icol];
      //if (ich&ix) *lptr++ = paldos[icol&15]; else lptr++; //Transluscent
      ix <<= 1;
      if (ix >= j) { ix = 1; i++; ich = textfont2[(int)dabuf[i]+iy]; }
    }
    iy += 256;
  }

    //Set cursor draw position (if dialog enabled, it will overwrite it)
  cursx = (curx-(tlx>>8))*charxsiz-(((tlx&255)*charxsiz)>>8);
  cursy = (cury-(tly>>8))*charysiz-(((tly&255)*charysiz)>>8);
  curscol = pal_32[DEFCOL*2+1];

    //Display dialog window if it exists
  if (kdialog[0])
  {
    int endx, endy;

    cursy = 0x80000000;

    ix = 0; iy = 0; x = 0;
    for(i=0;kdialog[i];i++)
    {
      if (i == kdiacursor) { cursx = x; cursy = iy; }
      if (kdialog[i] == '\n') { iy++; if (x > ix) ix = x; x = 0; } else
      if (kdialog[i] != '\r') x++;
    }

    stx = ((gdd.x-charxsiz*ix)>>1); endx = charxsiz*ix+stx;
    sty = ((gdd.y-charysiz*iy)>>1); endy = charysiz*iy+sty;
    slptr = sty*gdd.p+(stx<<2)+gdd.f;
    iy = j = 0;
    for(y=sty;y<endy;y++,slptr+=gdd.p)
    {
      ix = 0; i = j;
      icol = kdiacol; ich = textfont2[(iy<<8)+(int)kdialog[i]];
      lptr = (int *)slptr;
      for(x=stx;x<endx;x++)
      {
        *lptr++ = pal_32[icol*2+((ich&(1<<ix)) != 0)];
        ix++;
        if (ix >= charxsiz)
        {
          ix = 0; i++;
          if ((kdialog[i] == '\n') || (!kdialog[i])) break;

          if (kdialog[i] == '\r') { icol = kdiacol2; i++; } else
          if ((i >= kdiagets0) && (i < kdiagets1)) { icol = 0x0f; } else icol = kdiacol;

          ich = textfont2[(iy<<8)+(int)kdialog[i]];
        }
      }

      iy++; if (iy >= charysiz) { iy = 0; j = i+1; }
    }

    if (cursy != 0x80000000)
    {
      cursx = charxsiz*cursx + stx;
      cursy = charysiz*cursy + sty;
      curscol = pal_32[15*2+1];
    }
  }

    //Draw cursor
  if (totclk&128)
  {
    y = ((charysiz-2)&(insertmode-1))+cursy;
    slptr = gdd.f+y*gdd.p+(cursx<<2); j = charysiz+cursy;
    for(;y<j;y++,slptr+=gdd.p)
      if ((unsigned)y < gdd.y)
        for(x=0;x<charxsiz;x++)
          if ((unsigned)(cursx+x) < gdd.x)
            *(int *)(slptr+(x<<2)) = curscol;
  }

  x = ((mousxplc*charxsiz)>>8);
  y = ((mousyplc*charysiz)>>8);
  if (((unsigned)x < (unsigned)gdd.x) && ((unsigned)y < (unsigned)gdd.y))
  {
    *(int *)(gdd.f+y*gdd.p+(x<<2)) = curscol;
  }

  if (showfps)
  {
    static float avgdtim = 0.f;
    avgdtim += (dtim-avgdtim)*.02f;
#if defined(_WIN32)
    print6x8(&gdd,0,gdd.y-8,0xffffff,0x000000,"%.1f FPS",1.0/avgdtim);
#else
    print6x8(&gdd,0,gdd.y-8,0xffffff,0x000000,"%.1f FPS (SLEEPSTEP %dms)",1.0/avgdtim,sleepstep);
#endif
  }

  stopdirectdraw();
  nextpage();

#if (TESTRENDERSPEED == 1)
  {
    FILE *fil = fopen("asdf.but","a+");
    fprintf(fil,PRINTF64 "\n",t1-t0);
    fclose(fil);
  }
#endif
}
#pragma warning(pop) //I use a trick with ebp ;)

static void backup (int dax0, int day0, int dax1, int day1, int dashape)
{
  int x, y, x0, y0, x1, y1;
  char *cptr;

  selshapesave2 = dashape;
  if (dashape == 0)
  {
    if ((day0 < day1) || ((day0 == day1) && (dax0 < dax1)))
    {
      x0 = dax0; y0 = day0;
      x1 = dax1; y1 = day1;
    } else
    {
      x0 = dax1; y0 = day1;
      x1 = dax0; y1 = day0;
    }
    if (y0 == y1) { x = x1-x0; } else
      { x = lineoffs[y1+1]-lineoffs[y0]; x0 = 0; x1 = 0; }
    memcpy(buf2,&buf[lineoffs[y0]+x0],x);
    numlines2 = 0;
    for(y=y0;y<=y1;y++) lineoffs2[numlines2++] = lineoffs[y]-lineoffs[y0];
    lineoffs2[numlines2] = x;
  } else
  {
    if (dax0 < dax1) { x0 = dax0; x1 = dax1+1; } else { x0 = dax1; x1 = dax0+1; }
    if (day0 < day1) { y0 = day0; y1 = day1+1; } else { y0 = day1; y1 = day0+1; }

    numlines2 = 0; cptr = buf2;
    for(y=y0;y<y1;y++)
    {
      x = lineoffs[y+1]-lineoffs[y]; if (x > x1) x = x1;
      if (x > x0) { memcpy(cptr,&buf[lineoffs[y]+x0],x-x0); cptr += x-x0; } //Copy text of line
      x = x1-max(x,x0); if (x > 0) { memset(cptr,0x20,x); cptr += x; } //Fill rest of line w/spaces
      lineoffs2[numlines2++] = (x1-x0)*(y-y0);
    }
    lineoffs2[numlines2] = (x1-x0)*(y1-y0);
  }
}

static void insertchar (int x, int y, int num2insert)
{
  int i, p;

  if (num2insert <= 0) return;
  x = min(x,lineoffs[y+1]-lineoffs[y]);
  for(i=y+1;i<=numlines;i++) lineoffs[i] += num2insert;
  p = lineoffs[y]+x;
  rmemmove(&buf[lineoffs[numlines]],&buf[lineoffs[numlines]-num2insert],lineoffs[numlines]-num2insert-p);
  for(i=num2insert-1;i>=0;i--) buf[p+i] = 32;
}

static void deletechar (int x, int y, int num2delete)
{
  int i, p;

  if (num2delete <= 0) return;
  for(i=y+1;i<=numlines;i++) lineoffs[i] -= num2delete;
  p = lineoffs[y]+x;
  memmove(&buf[p],&buf[p+num2delete],lineoffs[numlines]+num2delete-p);
}

static void deleteendspace (int y)
{
  int i;

  i = lineoffs[y+1];
  while ((i > lineoffs[y]) && (buf[i-1] == 32)) i--;
  deletechar(i-lineoffs[y],y,lineoffs[y+1]-i);
}

static int gethomepos (int y)
{
  int x;

  x = 0;
  while (buf[lineoffs[y]+x] == 32)
  {
    x++;
    if (x > lineoffs[y+1]-lineoffs[y]) return(0);
  }
  return(x);
}

static int getendpos (int y)
{
  int x;

  x = lineoffs[y+1]-lineoffs[y]-1;
  while (buf[lineoffs[y]+x] == 32)
  {
    x--;
    if (x < 0) return(lineoffs[y+1]-lineoffs[y]);
  }
  return(x+1);
}

static void loadfile (char *filename)
{
  FILE *fil;
  INT_PTR i, j, k, daline, buflen;
  char ch;

  if ((fil = fopen(filename,"rb")) == 0)
  {
    //if (strchr(filename,'.') == 0) strcat(filename,".c");
    if ((fil = fopen(filename,"rb")) == 0) return;
  }
  fseek(fil,0,SEEK_END); buflen = ftell(fil); fseek(fil,0,SEEK_SET);
  if (buflen > (cachesize>>1))
  {
#if defined(_WIN32) || defined(_WDL_SWELL_H_)
    MessageBox(ghwnd,"WARNING: File is too big, so it will be truncated",prognam,MB_OK);
#else
    printf("WARNING: File is too big, so it will be truncated");
#endif
  }
  fread(buf,1,min(buflen,cachesize>>1),fil);

  k = 0;
  for(i=0;i<buflen;i++) if (buf[i] == 9) k++;
  if (k) savetab2spc = 0; else savetab2spc = 1;
  j = buflen+k*(NUMTABSTOPS-1);
  for(i=buflen-1;i>=0;i--)
  {
    ch = buf[i];
    if (ch == 9)
    {
      for (int i=0;i<NUMTABSTOPS;i++) buf[--j] = 32;
    } else
    {
      buf[--j] = buf[i];
    }
  }
  buflen += k*(NUMTABSTOPS-1);

  numlines = 0;
  lineoffs[numlines++] = 0;
  buf[buflen] = 0;  //Set this to 0 to make nextline detection safe
  for(i=0;i<buflen;i++)
  {
    if (buf[i] >= 32) buf[j++] = buf[i];
    if ((buf[i] == 10) || ((buf[i] == 13) && (buf[i+1] != 10)))
    {
      if (numlines >= MAXLINES-1)
      {
#if defined(_WIN32) || defined(_WDL_SWELL_H_)
        MessageBox(ghwnd,"File has too many lines!",prognam,MB_OK);
#else
        printf("File has too many lines!");
#endif
        buf[0] = 0; lineoffs[1] = 0; numlines = 1; selmode = 0; return;
      }
      lineoffs[numlines++] = j;
    }
  }
  lineoffs[numlines] = j;
  while ((numlines > 1) && (lineoffs[numlines] == lineoffs[numlines-1])) numlines--;
  fclose(fil);

  selmode = 0;

  if (cury >= numlines) { cury = numlines-1; curx = getendpos(cury); }

  settitle(0);
}

static void savefile (char *filename)
{
  FILE *fil;
  int i, x, y;
  char ch, tabwasted;

  //savetab2spc = (keystatus[0x2a]|keystatus[0x36]);

  //if (filename[0] == 0) strcpy(filename,"UNTITLED.C");
  if ((fil = fopen(filename,"wb")) == 0)
  {
#if defined(_WIN32) || defined(_WDL_SWELL_H_)
    MessageBox(ghwnd,"ERROR: Could not save file!",prognam,MB_OK);
#else
    printf("ERROR: could not save file!");
#endif
    return;
  }
  for(y=0;y<numlines;y++)
  {
    tabwasted = 0;
    for(x=lineoffs[y];x<lineoffs[y+1];x++)
    {
      ch = buf[x];
      if ((ch == 32) && (tabwasted == 0) && (savetab2spc == 0))
      {
        if (x+NUMTABSTOPS <= lineoffs[y+1])
        {
          for(i=NUMTABSTOPS-1;i>0;i--)
            if (buf[x+i] != 32)
              break;
          if (i == 0)
          {
            fputc(9,fil);
            x += NUMTABSTOPS-1; continue;
          }
        }
      } else { tabwasted = 1; }
      fputc(ch,fil);
    }
    if (savecrlf) { fputc(13,fil); fputc(10,fil); }
    else { fputc(10,fil); }
  }
  fclose(fil);

  settitle(0);
}

static int findnext (char *str)
{
  int findcnt, leng, ocurx, ocury, dastrlen;
  char ch1, ch2, firstime;

  dastrlen = strlen(str);

  ocurx = curx; ocury = cury;
  curx++; firstime = 1;
  while (1)
  {
    leng = lineoffs[cury+1]-lineoffs[cury];

    findcnt = 0;
    for(;curx<leng;curx++)
    {
      ch1 = buf[lineoffs[cury]+curx]; ch2 = str[findcnt];
      if (!kdiamatchwordncase)
      {
        if ((ch1 >= 97) && (ch1 <= 122)) ch1 -= 32;
        if ((ch2 >= 97) && (ch2 <= 122)) ch2 -= 32;
      }
      if (ch1 == ch2)
      {
        findcnt++;
        if (findcnt >= dastrlen)
        {
          if (kdiamatchwordncase)
          {
            if (curx-dastrlen >= 0)
            {
              ch1 = buf[lineoffs[cury]+curx-dastrlen];
              if (((ch1 >= '0') && (ch1 <= '9')) || (((ch1-'A')&0xdf) <= 'Z'-'A'))
                { curx += 1-findcnt; findcnt = 0; continue; } //deny match
            }
            if (curx+1 < leng)
            {
              ch1 = buf[lineoffs[cury]+curx+1];
              if (((ch1 >= '0') && (ch1 <= '9')) || (((ch1-'A')&0xdf) <= 'Z'-'A'))
                { curx += 1-findcnt; findcnt = 0; continue; } //deny match
            }
          }

          selx0 = curx-dastrlen+1; sely0 = cury;
          selx1 = curx+1; sely1 = cury; selmode = 2; selshape = 0;
          curx = selx0;
          return(0);
        }
      } else { curx -= findcnt; findcnt = 0; }
    }
    if ((cury == ocury) && (firstime == 0))
    {
      curx = ocurx; cury = ocury;
      return(-1);
    }
    curx = 0;
    cury++; if (cury >= numlines) cury = 0;
    firstime = 0;
  }
}

static int findlast (char *str)
{
  int findcnt, leng, ocurx, ocury, dastrlen;
  char ch1, ch2, firstime;

  dastrlen = strlen(str);

  ocurx = curx; ocury = cury;
  curx--; firstime = 1;
  while (1)
  {
    leng = lineoffs[cury+1]-lineoffs[cury];

    findcnt = dastrlen-1;
    for(;curx>=0;curx--)
    {
      ch1 = buf[lineoffs[cury]+curx]; ch2 = str[findcnt];
      if (!kdiamatchwordncase)
      {
        if ((ch1 >= 97) && (ch1 <= 122)) ch1 -= 32;
        if ((ch2 >= 97) && (ch2 <= 122)) ch2 -= 32;
      }

      if (ch1 == ch2)
      {
        findcnt--;
        if (findcnt < 0)
        {
          if (kdiamatchwordncase)
          {
            if (curx > 0)
            {
              ch1 = buf[lineoffs[cury]+curx-1];
              if (((ch1 >= '0') && (ch1 <= '9')) || (((ch1-'A')&0xdf) <= 'Z'-'A'))
                { curx += dastrlen-findcnt-2; findcnt = dastrlen-1; continue; } //deny match
            }
            if (curx+dastrlen < leng)
            {
              ch1 = buf[lineoffs[cury]+curx+dastrlen];
              if (((ch1 >= '0') && (ch1 <= '9')) || (((ch1-'A')&0xdf) <= 'Z'-'A'))
                { curx += dastrlen-findcnt-2; findcnt = dastrlen-1; continue; } //deny match
            }
          }

          selx0 = curx; sely0 = cury;
          selx1 = curx+dastrlen; sely1 = cury; selmode = 2; selshape = 0;
          curx = selx0;
          return(0);
        }
      } else { curx += (dastrlen-1)-findcnt; findcnt = dastrlen-1; }
    }
    if ((cury == ocury) && (firstime == 0))
    {
      curx = ocurx; cury = ocury;
      return(-1);
    }
    cury--; if (cury < 0) cury = numlines-1;
    curx = lineoffs[cury+1]-lineoffs[cury]-1;
    firstime = 0;
  }
}

static void cursormove (int ostat, int stat, int ncurx, int ncury)
{
  if (!(stat&3))
  {
    selmode = 0;
  } else
  {
    if (((~ostat)&stat&3) || (selmode != 1)) //Equivalent to: (stat&1)>(ostat&1))||((stat&2)>(ostat&2)))
      { selx0 = curx; sely0 = cury; if (!selmode) selshape = 0; }
    selx1 = ncurx; sely1 = ncury; selmode = 1;
  }
  curx = ncurx; cury = ncury;
}

static void shifttextleft (int sely0, int sely1, int numtabs, int compactit)
{
  int i, j, k, l, y1, y2;

  if ((sely0 != sely1) && (selmode))
  {
    y1 = min(sely0,sely1);
    y2 = max(sely0,sely1)+1;

    if (!compactit)
    {
      for(i=y1;i<y2;i++)
      {
        for(j=min(lineoffs[i+1]-lineoffs[i],numtabs)-1;j>=0;j--)
          if (buf[lineoffs[i]+j] != 32) return;
      }

      j = 0;
      for(i=y1;i<y2;i++)
      {
        k = min(lineoffs[i+1]-lineoffs[i],numtabs);
        memmove(&buf[lineoffs[i]+j],&buf[lineoffs[i]+numtabs],lineoffs[i+1]-lineoffs[i]-k);
        lineoffs[i] += j; j -= k;
      }
    } else
    {
      j = 0;
      for(i=y1;i<y2;i++)
      {
        l = min(lineoffs[i+1]-lineoffs[i],numtabs);
        for(k=0;k<l;k++) if (buf[lineoffs[i]+k] != 32) break;
        memmove(&buf[lineoffs[i]+j],&buf[lineoffs[i]+k],lineoffs[i+1]-lineoffs[i]-k);
        lineoffs[i] += j; j -= k;
      }
    }
    memmove(&buf[lineoffs[y2]+j],&buf[lineoffs[y2]],lineoffs[numlines]-lineoffs[y2]);
    for(i=y2;i<=numlines;i++) lineoffs[i] += j;
  }
}

static void shifttextright (int sely0, int sely1, int numtabs)
{
  int i, j, k, y1, y2;

  if ((sely0 != sely1) && (selmode))
  {
    y1 = min(sely0,sely1);
    y2 = max(sely0,sely1)+1;

    j = numtabs*(y2-y1);
    rmemmove(&buf[lineoffs[numlines]+j],&buf[lineoffs[numlines]],lineoffs[numlines]-lineoffs[y2]);
    for(i=y2-1;i>=y1;i--)
    {
      rmemmove(&buf[lineoffs[i+1]+j],&buf[lineoffs[i+1]],lineoffs[i+1]-lineoffs[i]);
      j -= numtabs;
    }

    j = 0;
    for(i=y1;i<y2;i++)
    {
      lineoffs[i] += j; j += numtabs;
      for(k=0;k<numtabs;k++) buf[lineoffs[i]+k] = 32;
    }
    for(i=y2;i<=numlines;i++) lineoffs[i] += j;
  }
}

//--------------------------------------------------------------------------------------------------
#if defined(__NS_EEL_H__)
#if defined(__linux__)
#define __cdecl __attribute((__cdecl__))
#define _snprintf(a,b,c,...) snprintf(a,b,c,__VA_ARGS__)
#endif

static void quickeval (int dax0, int day0, int dax1, int day1, int dashape)
{
  double d, (__cdecl *quickfunc)(void);
  int i, j, x, y, xe, x0, y0, x1, y1, siz;
  char *quickbuf, tbuf[256], *cptr;

  if (!dashape)
  {
    if ((day0 < day1) || ((day0 == day1) && (dax0 < dax1)))
        { x0 = dax0; y0 = day0; x1 = dax1; y1 = day1; } else
        { x0 = dax1; y0 = day1; x1 = dax0; y1 = day0; }
    if (y0 == y1) { siz = min(x1,lineoffs[y0+1]-lineoffs[y0])-x0; } else
              { siz = lineoffs[y1+1]-lineoffs[y0]; x0 = 0; x1 = 0; }

    quickbuf = (char *)malloc(siz+3); if (!quickbuf) return;
    quickbuf[0] = 'x'; quickbuf[1] = '=';
    memcpy(&quickbuf[2],&buf[lineoffs[y0]+x0],siz);
    quickbuf[siz+2] = 0;
  } else
  {
    if (dax0 < dax1) { x0 = dax0; x1 = dax1+1; } else { x0 = dax1; x1 = dax0+1; }
    if (day0 < day1) { y0 = day0; y1 = day1+1; } else { y0 = day1; y1 = day0+1; }

    quickbuf = (char *)malloc((x1-x0+1)+3); if (!quickbuf) return;
    for(y=y1-1;y>=y0;y--)
    {
      quickbuf[0] = 'x'; quickbuf[1] = '=';
      cptr = &quickbuf[2];

      x = max(x0,0); xe = min(lineoffs[y+1]-lineoffs[y],x1);
      if (x < xe) { memcpy(cptr,&buf[lineoffs[y]+x],xe-x); cptr += xe-x; }
      *cptr++ = 13;

      cptr[0] = 0;

      NSEEL_VMCTX vm = NSEEL_VM_alloc();
      double *varx = NSEEL_VM_regvar(vm, "x");
      NSEEL_CODEHANDLE codehand = NSEEL_code_compile(vm,quickbuf,0);
      NSEEL_code_execute(codehand); d = *varx;
      NSEEL_code_free(codehand);
      NSEEL_VM_free(vm);

      _snprintf(tbuf,sizeof(tbuf),"%.20g",d);
      i = strlen(tbuf);
      insertchar(curx,y,max(curx-(lineoffs[y+1]-lineoffs[y]),0)+i);
      memcpy(&buf[lineoffs[y]+curx],tbuf,i);
    }
    free(quickbuf);
    return;
  }

  NSEEL_VMCTX vm = NSEEL_VM_alloc();
  double *varx = NSEEL_VM_regvar(vm, "x");
  NSEEL_CODEHANDLE codehand = NSEEL_code_compile(vm,quickbuf,0);
  NSEEL_code_execute(codehand); d = *varx;
  NSEEL_code_free(codehand);
  NSEEL_VM_free(vm);

  _snprintf(tbuf,sizeof(tbuf),"%.20g",d);
  i = strlen(tbuf);
  insertchar(curx,cury,max(curx-(lineoffs[cury+1]-lineoffs[cury]),0)+i);
  memcpy(&buf[lineoffs[cury]+curx],tbuf,i); curx += i;
  free(quickbuf);
}

#else

#if defined(_WIN32) && (!defined(_WIN64))
static char *safeparmstack;
static int safeparmbytes;
static double saferetdouble;
static unsigned __stdcall safethreadretdouble (void *dafunc)
{
  _asm
  {
    mov eax, safeparmbytes ;Copy safeparmstack to local stack
    mov edx, safeparmstack
    sub eax, 4
bpush:push dword ptr [edx+eax]
    sub eax, 4
    jge short bpush

    call dafunc
    fstp [saferetdouble]

    mov eax, safeparmbytes ;Copy local stack to safeparmstack
    mov edx, safeparmstack
    add edx, eax
    neg eax
bpop: pop dword ptr [edx+eax]
    add eax, 4
    jl short bpop
  }
  return(0);
}
static double dsafecall (int maxtims, int *success, int parmbytes, void *dafunc, ...) //double return
{
  int i; char *parms; unsigned win98requiresme;

  va_start((char *)parms,dafunc);
  safeparmstack = (char *)_alloca(parmbytes+4); if (!safeparmstack) { (*success) = 0; return(0); }
  safeparmbytes = parmbytes;
  for(i=safeparmbytes-4;i>=0;i-=4) *(int *)&safeparmstack[i] = *(int *)&parms[i];
  HANDLE evalth = (HANDLE)_beginthreadex(0,1048576,&safethreadretdouble,dafunc,0,&win98requiresme);
  if (WaitForSingleObject(evalth,maxtims) == WAIT_TIMEOUT)
  {
    kasm87jumpback(dafunc,0);
    WaitForSingleObject(evalth,INFINITE);
    kasm87jumpback(dafunc,1);
    CloseHandle(evalth);
    if (success) (*success) = 0;
    return(0.0);
  }
  for(i=safeparmbytes-4;i>=0;i-=4) *(int *)&parms[i] = *(int *)&safeparmstack[i];
  CloseHandle(evalth); if (success) (*success) = 1; return(saferetdouble);
}
static void quickeval (int dax0, int day0, int dax1, int day1, int dashape)
{
  double d, (__cdecl *quickfunc)(void);
  int i, j, x, y, xe, x0, y0, x1, y1, siz;
  char *quickbuf, tbuf[256], *cptr;

  if (!dashape)
  {
    if ((day0 < day1) || ((day0 == day1) && (dax0 < dax1)))
        { x0 = dax0; y0 = day0; x1 = dax1; y1 = day1; } else
        { x0 = dax1; y0 = day1; x1 = dax0; y1 = day0; }
    if (y0 == y1) { siz = min(x1,lineoffs[y0+1]-lineoffs[y0])-x0; } else
              { siz = lineoffs[y1+1]-lineoffs[y0]; x0 = 0; x1 = 0; }

    quickbuf = (char *)malloc(siz+3); if (!quickbuf) return;
    quickbuf[0] = '('; quickbuf[1] = ')';
    memcpy(&quickbuf[2],&buf[lineoffs[y0]+x0],siz);
    quickbuf[siz+2] = 0;
  } else
  {
    if (dax0 < dax1) { x0 = dax0; x1 = dax1+1; } else { x0 = dax1; x1 = dax0+1; }
    if (day0 < day1) { y0 = day0; y1 = day1+1; } else { y0 = day1; y1 = day0+1; }

#if 0
    quickbuf = (char *)malloc((x1-x0+1)*(y1-y0)+3); if (!quickbuf) return;
    quickbuf[0] = '('; quickbuf[1] = ')';
    cptr = &quickbuf[2];
    for(y=y0;y<y1;y++)
    {
      x = max(x0,0); xe = min(lineoffs[y+1]-lineoffs[y],x1);
      if (x < xe) { memcpy(cptr,&buf[lineoffs[y]+x],xe-x); cptr += xe-x; }
      *cptr++ = 13;
    }
    cptr[0] = 0;
#else
    quickbuf = (char *)malloc((x1-x0+1)+3); if (!quickbuf) return;
    for(y=y1-1;y>=y0;y--)
    {
      quickbuf[0] = '('; quickbuf[1] = ')';
      cptr = &quickbuf[2];

      x = max(x0,0); xe = min(lineoffs[y+1]-lineoffs[y],x1);
      if (x < xe) { memcpy(cptr,&buf[lineoffs[y]+x],xe-x); cptr += xe-x; }
      *cptr++ = 13;

      cptr[0] = 0;

      quickfunc = (double (__cdecl *)(void))kasm87(quickbuf); if (!quickfunc) continue;
      d = dsafecall(1000,&i,0,quickfunc);
      if (!i) { kasm87free((void *)quickfunc); continue; }

      _snprintf(tbuf,sizeof(tbuf),"%.20g",d);
      i = strlen(tbuf);
      insertchar(curx,y,max(curx-(lineoffs[y+1]-lineoffs[y]),0)+i);
      memcpy(&buf[lineoffs[y]+curx],tbuf,i);
    }
    free(quickbuf);
    return;
#endif
  }

  quickfunc = (double (__cdecl *)(void))kasm87(quickbuf);
  if (!quickfunc) { free(quickbuf); return; }
  d = dsafecall(1000,&i,0,quickfunc);
  if (!i) { kasm87free((void *)quickfunc); free(quickbuf); return; }

  _snprintf(tbuf,sizeof(tbuf),"%.20g",d);
  i = strlen(tbuf);
  insertchar(curx,cury,max(curx-(lineoffs[cury+1]-lineoffs[cury]),0)+i);
  memcpy(&buf[lineoffs[cury]+curx],tbuf,i); curx += i;
  free(quickbuf);
}

#else

static void quickeval (int dax0, int day0, int dax1, int day1, int dashape)
{
  sprintf(tempbuf,
    " ͻ \n"\
    "  Info                                             \n"\
    "                                                   \n"\
    "  Ctrl+=  Evaluate highlighted text                \n"\
    "                                                   \n"\
    "  The above functionality is not present at the    \n"\
    "  current architecture. This feature is available  \n"\
    "  only for the Windows executable, KCm (x86).      \n"\
    "                                                   \n"\
    "  Sorry for the inconvenience.                     \n"\
    " ͼ \n");
  kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
  kdiamode = INFODIALOG; kdiafirstime = 1;
  kdiagets0 = kdiagets1 = 0; kdiacursor = -1;
  strcpy(kdialog,tempbuf);
}
#endif
#endif // __NS_EEL_H__
//--------------------------------------------------------------------------------------------------

static int checklinechar (int x, int y)
{
  if ((unsigned)y >= (unsigned)numlines) return(0);
  if ((unsigned)x >= (unsigned)(lineoffs[y+1]-lineoffs[y])) return(0);
  return(lineconnect[buf[lineoffs[y]+x]]);
}

static void connectline (int x1, int y1, int x2, int y2)
{
  int o1, o2;

  o1 = (int)lineconnect[buf[lineoffs[y1]+x1]];
  o2 = (int)lineconnect[buf[lineoffs[y2]+x2]];
  if ((checklinechar(x1-1,y1)&2) == 0) o1 &= ~1;
  if ((checklinechar(x1+1,y1)&1) == 0) o1 &= ~2;
  if ((checklinechar(x1,y1-1)&8) == 0) o1 &= ~4;
  if ((checklinechar(x1,y1+1)&4) == 0) o1 &= ~8;
  if ((checklinechar(x2-1,y2)&2) == 0) o2 &= ~1;
  if ((checklinechar(x2+1,y2)&1) == 0) o2 &= ~2;
  if ((checklinechar(x2,y2-1)&8) == 0) o2 &= ~4;
  if ((checklinechar(x2,y2+1)&4) == 0) o2 &= ~8;
  if (x1 < x2) o1 |= 2, o2 |= 1;
  if (x1 > x2) o1 |= 1, o2 |= 2;
  if (y1 < y2) o1 |= 8, o2 |= 4;
  if (y1 > y2) o1 |= 4, o2 |= 8;
  buf[lineoffs[y1]+x1] = linechartable[linedrawmode-1][o1];
  buf[lineoffs[y2]+x2] = linechartable[linedrawmode-1][o2];
}

static int ocurx, ocury;
static char origcursx, origcursy, origcurl1, origcurl2;
static char searchstr[MAX_PATH], replacestr[MAX_PATH];
static int oshiftstat, shiftstat, altkpcharstat = -1;
static char altkpcharadd[12] = {7,8,9,0,4,5,6,0,1,2,3,0}; //#=altkpcharadd[(key&255)-0x47]

#if defined(_WDL_SWELL_H_)
LPARAM scancode (WPARAM wparm)
{
  LPARAM lparm = 0;
  switch (wparm)
  {
  case ('a'): lparm = ((0x1e<<16)|(1)); return lparm;
  case ('b'): lparm = ((0x30<<16)|(1)); return lparm;
  case ('c'): lparm = ((0x2e<<16)|(1)); return lparm;
  case ('d'): lparm = ((0x20<<16)|(1)); return lparm;
  case ('e'): lparm = ((0x12<<16)|(1)); return lparm;
  case ('f'): lparm = ((0x21<<16)|(1)); return lparm;
  case ('g'): lparm = ((0x22<<16)|(1)); return lparm;
  case ('h'): lparm = ((0x23<<16)|(1)); return lparm;
  case ('i'): lparm = ((0x17<<16)|(1)); return lparm;
  case ('j'): lparm = ((0x24<<16)|(1)); return lparm;
  case ('k'): lparm = ((0x25<<16)|(1)); return lparm;
  case ('l'): lparm = ((0x26<<16)|(1)); return lparm;
  case ('m'): lparm = ((0x32<<16)|(1)); return lparm;
  case ('n'): lparm = ((0x31<<16)|(1)); return lparm;
  case ('o'): lparm = ((0x18<<16)|(1)); return lparm;
  case ('p'): lparm = ((0x19<<16)|(1)); return lparm;
  case ('q'): lparm = ((0x10<<16)|(1)); return lparm;
  case ('r'): lparm = ((0x13<<16)|(1)); return lparm;
  case ('s'): lparm = ((0x1f<<16)|(1)); return lparm;
  case ('t'): lparm = ((0x14<<16)|(1)); return lparm;
  case ('u'): lparm = ((0x16<<16)|(1)); return lparm;
  case ('v'): lparm = ((0x2f<<16)|(1)); return lparm;
  case ('w'): lparm = ((0x11<<16)|(1)); return lparm;
  case ('x'): lparm = ((0x2d<<16)|(1)); return lparm;
  case ('y'): lparm = ((0x15<<16)|(1)); return lparm;
  case ('z'): lparm = ((0x2c<<16)|(1)); return lparm;
  case ('A'): lparm = ((0x1e<<16)|(1)); return lparm;
  case ('B'): lparm = ((0x30<<16)|(1)); return lparm;
  case ('C'): lparm = ((0x2e<<16)|(1)); return lparm;
  case ('D'): lparm = ((0x20<<16)|(1)); return lparm;
  case ('E'): lparm = ((0x12<<16)|(1)); return lparm;
  case ('F'): lparm = ((0x21<<16)|(1)); return lparm;
  case ('G'): lparm = ((0x22<<16)|(1)); return lparm;
  case ('H'): lparm = ((0x23<<16)|(1)); return lparm;
  case ('I'): lparm = ((0x17<<16)|(1)); return lparm;
  case ('J'): lparm = ((0x24<<16)|(1)); return lparm;
  case ('K'): lparm = ((0x25<<16)|(1)); return lparm;
  case ('L'): lparm = ((0x26<<16)|(1)); return lparm;
  case ('M'): lparm = ((0x32<<16)|(1)); return lparm;
  case ('N'): lparm = ((0x31<<16)|(1)); return lparm;
  case ('O'): lparm = ((0x18<<16)|(1)); return lparm;
  case ('P'): lparm = ((0x19<<16)|(1)); return lparm;
  case ('Q'): lparm = ((0x10<<16)|(1)); return lparm;
  case ('R'): lparm = ((0x13<<16)|(1)); return lparm;
  case ('S'): lparm = ((0x1f<<16)|(1)); return lparm;
  case ('T'): lparm = ((0x14<<16)|(1)); return lparm;
  case ('U'): lparm = ((0x16<<16)|(1)); return lparm;
  case ('V'): lparm = ((0x2f<<16)|(1)); return lparm;
  case ('W'): lparm = ((0x11<<16)|(1)); return lparm;
  case ('X'): lparm = ((0x2d<<16)|(1)); return lparm;
  case ('Y'): lparm = ((0x15<<16)|(1)); return lparm;
  case ('Z'): lparm = ((0x2c<<16)|(1)); return lparm;
  case ('`'): lparm = ((0x29<<16)|(1)); return lparm;
  case ('1'): lparm = ((0x02<<16)|(1)); return lparm;
  case ('2'): lparm = ((0x03<<16)|(1)); return lparm;
  case ('3'): lparm = ((0x04<<16)|(1)); return lparm;
  case ('4'): lparm = ((0x05<<16)|(1)); return lparm;
  case ('5'): lparm = ((0x06<<16)|(1)); return lparm;
  case ('6'): lparm = ((0x07<<16)|(1)); return lparm;
  case ('7'): lparm = ((0x08<<16)|(1)); return lparm;
  case ('8'): lparm = ((0x09<<16)|(1)); return lparm;
  case ('9'): lparm = ((0x0a<<16)|(1)); return lparm;
  case ('0'): lparm = ((0x0b<<16)|(1)); return lparm;
  case ('-'): lparm = ((0x0c<<16)|(1)); return lparm;
  case ('='): lparm = ((0x0d<<16)|(1)); return lparm;
  case ('['): lparm = ((0x1a<<16)|(1)); return lparm;
  case (']'): lparm = ((0x1b<<16)|(1)); return lparm;
  case ('\\'): lparm = ((0x2b<<16)|(1)); return lparm;
  case (';'): lparm = ((0x27<<16)|(1)); return lparm;
  case ('\''): lparm = ((0x28<<16)|(1)); return lparm;
  case (','): lparm = ((0x33<<16)|(1)); return lparm;
  case ('.'): lparm = ((0x34<<16)|(1)); return lparm;
  case ('/'): lparm = ((0x35<<16)|(1)); return lparm;
  case ('~'): lparm = ((0x29<<16)|(1)); return lparm;
  case ('!'): lparm = ((0x02<<16)|(1)); return lparm;
  case ('@'): lparm = ((0x03<<16)|(1)); return lparm;
  case ('#'): lparm = ((0x04<<16)|(1)); return lparm;
  case ('$'): lparm = ((0x05<<16)|(1)); return lparm;
  case ('%'): lparm = ((0x06<<16)|(1)); return lparm;
  case ('^'): lparm = ((0x07<<16)|(1)); return lparm;
  case ('&'): lparm = ((0x08<<16)|(1)); return lparm;
  case ('*'): lparm = ((0x09<<16)|(1)); return lparm;
  case ('('): lparm = ((0x0a<<16)|(1)); return lparm;
  case (')'): lparm = ((0x0b<<16)|(1)); return lparm;
  case ('_'): lparm = ((0x0c<<16)|(1)); return lparm;
  case ('+'): lparm = ((0x0d<<16)|(1)); return lparm;
  case ('{'): lparm = ((0x1a<<16)|(1)); return lparm;
  case ('}'): lparm = ((0x1b<<16)|(1)); return lparm;
  case ('|'): lparm = ((0x2b<<16)|(1)); return lparm;
  case (':'): lparm = ((0x27<<16)|(1)); return lparm;
  case ('"'): lparm = ((0x28<<16)|(1)); return lparm;
  case ('<'): lparm = ((0x33<<16)|(1)); return lparm;
  case ('>'): lparm = ((0x34<<16)|(1)); return lparm;
  case ('?'): lparm = ((0x35<<16)|(1)); return lparm;
  }

  return(0);
}

void keychar (WPARAM wParam, LPARAM lParam)
{
  if (!(GetAsyncKeyState(VK_SHIFT)&0x8000))
  {
    if (wParam>='A' && wParam<='Z')
    {
      wParam += 'a'-'A';
    }
    SendMessage(ghwnd,WM_CHAR,wParam,lParam);
    return;
  }
  SendMessage(ghwnd,WM_CHAR,wParam,lParam);
}

void keydown (WPARAM wParam, LPARAM lParam)
{
  LPARAM ldn, lup;
  switch (wParam)
  {
  case VK_RETURN:
    SendMessage(ghwnd,WM_KEYDOWN,wParam,lParam);
    SendMessage(ghwnd,WM_CHAR,'\r',lParam);
    return;
  case VK_BACK:
    SendMessage(ghwnd,WM_KEYDOWN,wParam,lParam);
    SendMessage(ghwnd,WM_CHAR,'\b',lParam);
    return;
  }

  if ((GetAsyncKeyState(VK_CONTROL)&0x8000))
  {
    ldn = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x1d<<16)|(1));
    lup = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x1d<<16)|(1));
    SendMessage(ghwnd,WM_KEYDOWN,wParam,ldn);
    SendMessage(ghwnd,WM_KEYDOWN,wParam,lParam);
    SendMessage(ghwnd,WM_KEYUP,wParam,lup);
  }
  else if ((GetAsyncKeyState(VK_MENU)&0x8000))
  {
    if (!(GetAsyncKeyState(VK_SHIFT)&0x8000))
    {
      if (wParam>='A' && wParam<='Z')
      {
        wParam += 'a'-'A';
        ldn = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x38<<16)|(1));
        lup = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x38<<16)|(1));
        SendMessage(ghwnd,WM_KEYDOWN,wParam,ldn);
        SendMessage(ghwnd,WM_KEYDOWN,wParam,lParam);
        SendMessage(ghwnd,WM_KEYUP,wParam,lup);
        SendMessage(ghwnd,WM_KEYUP,wParam,lParam);
      }
      else
      {
        ldn = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x38<<16)|(1));
        lup = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x38<<16)|(1));
        SendMessage(ghwnd,WM_KEYDOWN,wParam,ldn);
        SendMessage(ghwnd,WM_KEYDOWN,wParam,lParam);
        SendMessage(ghwnd,WM_KEYUP,wParam,lup);
      }
    }
  }
  else if ((GetAsyncKeyState(VK_SHIFT)&0x8000))
  {
    ldn = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x2a<<16)|(1));
    lup = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x2a<<16)|(1));
    SendMessage(ghwnd,WM_KEYDOWN,wParam,ldn);
    SendMessage(ghwnd,WM_KEYDOWN,wParam,lParam);
    SendMessage(ghwnd,WM_KEYUP,wParam,lup);
  }
  else
  {
    SendMessage(ghwnd,WM_KEYDOWN,wParam,lParam);
  }
}

void keyup (WPARAM wParam, LPARAM lParam)
{
  SendMessage(ghwnd,WM_KEYUP,wParam,lParam);
}

int promsg (MSG *msg)
{
  if (msg->hwnd == ghwnd || IsChild(ghwnd, msg->hwnd))
  {
    LPARAM lparm = 0;
    if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN)
    {
      if (msg->lParam & FVIRTKEY)
      {
        switch (msg->wParam)
        {
        case VK_HOME:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x47<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_UP:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x48<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_PRIOR:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x49<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_LEFT:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x4b<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_RIGHT:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x4d<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_END:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x4f<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_DOWN:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x50<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_NEXT:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x51<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_INSERT:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x52<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_DELETE:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x53<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F1:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x3b<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F2:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x3c<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F3:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x3d<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F4:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x3e<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F5:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x3f<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F6:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x40<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F7:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x41<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F8:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x42<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F9:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x43<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F10:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x44<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F11:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x57<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_F12:
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x58<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case (32768|VK_RETURN):
        {
          lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x1c<<16)|(1));
          keydown(msg->wParam,lparm); return(1);
        }
        case VK_SUBTRACT: msg->wParam = '-'; break;
        case VK_ADD: msg->wParam = '+'; break;
        case VK_MULTIPLY: msg->wParam = '*'; break;
        case VK_DIVIDE: msg->wParam = '/'; break;
        case VK_DECIMAL: msg->wParam = '.'; break;
        case VK_NUMPAD0: msg->wParam = '0'; break;
        case VK_NUMPAD1: msg->wParam = '1'; break;
        case VK_NUMPAD2: msg->wParam = '2'; break;
        case VK_NUMPAD3: msg->wParam = '3'; break;
        case VK_NUMPAD4: msg->wParam = '4'; break;
        case VK_NUMPAD5: msg->wParam = '5'; break;
        case VK_NUMPAD6: msg->wParam = '6'; break;
        case VK_NUMPAD7: msg->wParam = '7'; break;
        case VK_NUMPAD8: msg->wParam = '8'; break;
        case VK_NUMPAD9: msg->wParam = '9'; break;
        }
      }

      switch (msg->wParam)
      {
      case VK_RETURN:
      {
        lparm = ((0<<31)|(1<<30)|(0<<29)|(1<<24)|(0x1c<<16)|(1));
        keydown(msg->wParam,lparm); return(1);
      }
      break;
      case VK_BACK:
      {
        lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x0e<<16)|(1));
        keydown(msg->wParam,lparm); return(1);
      }
      case VK_TAB:
      {
        lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x0f<<16)|(1));
        keydown(msg->wParam,lparm); return(1);
      }
      case VK_ESCAPE:
      {
        lparm = ((0<<31)|(1<<30)|(0<<29)|(0<<24)|(0x01<<16)|(1));
        keydown(msg->wParam,lparm); return(1);
      }
      }

      if (msg->wParam>=32)
      {
        keydown(msg->wParam,scancode(msg->wParam));
        keychar(msg->wParam,scancode(msg->wParam));
      }
    }

    if (msg->message == WM_KEYUP || msg->message == WM_SYSKEYUP)
    {
      if (msg->lParam & FVIRTKEY)
      {
        switch (msg->wParam)
        {
        case VK_HOME:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x47<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_UP:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x48<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_PRIOR:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x49<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_LEFT:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x4b<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_RIGHT:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x4d<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_END:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x4f<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_DOWN:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x50<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_NEXT:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x51<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_INSERT:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x52<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_DELETE:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x53<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F1:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x3b<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F2:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x3c<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F3:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x3d<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F4:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x3e<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F5:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x3f<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F6:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x40<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F7:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x41<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F8:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x42<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F9:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x43<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F10:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x44<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F11:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x57<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case VK_F12:
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x58<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        case (32768|VK_RETURN):
        {
          lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x1c<<16)|(1));
          keyup(msg->wParam,lparm); return(1);
        }
        }
      }

      switch (msg->wParam)
      {
      case VK_RETURN:
      {
        lparm = ((1<<31)|(0<<30)|(0<<29)|(1<<24)|(0x1c<<16)|(1));
        keyup(msg->wParam,lparm); return(1);
      }
      break;
      case VK_BACK:
      {
        lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x0e<<16)|(1));
        keyup(msg->wParam,lparm); return(1);
      }
      case VK_TAB:
      {
        lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x0f<<16)|(1));
        keyup(msg->wParam,lparm); return(1);
      }
      case VK_ESCAPE:
      {
        lparm = ((1<<31)|(0<<30)|(0<<29)|(0<<24)|(0x01<<16)|(1));
        keyup(msg->wParam,lparm); return(1);
      }
      }

      if (msg->wParam>=32)
      {
        keyup(msg->wParam,scancode(msg->wParam)); return(1);
      }
    }
  }
  return(1);
}

INT_PTR SWELLAppMain (int msg, INT_PTR parm1, INT_PTR parm2)
{
  switch (msg)
  {
    case SWELLAPP_ONLOAD: break;
    case SWELLAPP_LOADED: break;
    case SWELLAPP_DESTROY: if (ghwnd) DestroyWindow(ghwnd); break;
    case SWELLAPP_ACTIVATE:
      if (parm1) SendMessage(ghwnd,WM_ACTIVATEAPP,TRUE,0);
      break;
    case SWELLAPP_ONCOMMAND:
      if (ghwnd && (parm1&0xffff)) SendMessage(ghwnd,WM_COMMAND,parm1&0xffff,0);
      break;
    case SWELLAPP_PROCESSMESSAGE:
      if (((MSG *)parm1)->hwnd != ghwnd) return 0;
      if (promsg((MSG *)parm1)>0) return(1);
      return(1);
  }
  return(0);
}
#endif

#if defined(_WIN32)
int WINAPI wWinMain (HINSTANCE hinst, HINSTANCE hpinst, LPWSTR cmdlinewide, int ncmdshow)
#else
#if defined(_WDL_SWELL_H_)
extern int reqquit;
static HINSTANCE hinst;

#if 0
#ifdef ShowCursor
#undef ShowCursor
#endif
int ShowCursorSafe (BOOL bShow)
{
  if (SWELL_IsCursorVisible() && !bShow) { return SWELL_ShowCursor(bShow); }
  else if (!SWELL_IsCursorVisible() && bShow) { return SWELL_ShowCursor(bShow); }
  return 0;
}
#define ShowCursor ShowCursorSafe

BOOL GetClipCursor (RECT *rect)
{
  // TODO
  // Finish the implementation.
  // Ideally this function should
  // be part of SWELL.
  return FALSE;
}

BOOL ClipCursor (RECT *rect)
{
  // TODO
  // Finish the implementation.
  // Ideally this function should
  // be part of SWELL.
  return FALSE;
}
#endif

#endif // _WDL_SWELL_H_
int main (int argc, char **argv)
#endif
{
#if defined(_WIN32)
  char cmdline[2048];
  WDL_WideToMBStr(cmdline,cmdlinewide,sizeof(cmdline));
#endif

  FILE *fil;
  int i, j, k, x, y, xx, yy, x1, y1, x2, y2, key, mode, bad, obstatus = 0;
  char ch, ch1, ch2, *cptr, *v;
  float fmousx, fmousy;
#if defined(_WIN32)
  int argc;
  char *argv[MAX_PATH>>1];
  RECT rw;
  POINT p0;
  argc = cmdline2arg(cmdline,argv);
  xres = 800; yres = 600;
#elif defined(_WDL_SWELL_H_)
  POINT p0;
  xres = 800; yres = 600;
#else
  typedef struct { int x, y; } POINT;
  POINT p0;
#if defined(KXWIN_H)
  xres = 800; yres = 600;
#else
  xres = 0; yres = 0; //autodetect
#endif
#endif


      //\
     //  \
    //    \`~-O-~~-O-~~-O-~~-O-~~-O-~~-O-~~-O-~~-O-~
   //      \`~-O-~~-O-~~-O-~~-O-~~-O-~~-O-~~-O-~~-O-~
  //  THE   \`~-O-~~-O-~~-O-~~-O-~~-O-~~-O-~~-O-~~-O-~
  prognam = "KCm"; //"KC Text Editor by Ken Silverman";
  //ohvyg sbe cresbeznapr
  //abg nccrnenapr
  //:::::::::::`KCm (KC Modificata) by Giorgos Vougioukas \
  //`-O--O--O--O--O--O--O--O--O--O--O--O--O--O--O--O--O--O-O


#if defined(_WIN32) //|| defined(_WDL_SWELL_H_)
  char snotbuf[MAX_PATH];
  GetCurrentDirectory(sizeof(snotbuf),snotbuf);
  relpathinit(snotbuf);
#if defined(_WIN32)
  timeBeginPeriod(1);
#endif

  GetClipCursor(&gcursoldclip);
#endif

  charxsiz = 9; charysiz = 16;
  xdim = (xres/charxsiz)+1; bytesperline = (xdim<<1)+4;
  ydim = (yres/charysiz)+1;

  cachesize = (256<<20); //TEMP HACK!!!
  while (!(buf = (char *)malloc(cachesize)))
  {
    cachesize -= 65536;
    if (cachesize < 262144)
    {
#if defined(_WIN32) || defined(_WDL_SWELL_H_)
      MessageBox(ghwnd,"NOT ENOUGH MEMORY!",prognam,MB_OK);
#else
      printf("NOT ENOUGH MEMORY!");
#endif
      return(-1);
    }
  }
  buf2 = buf+(cachesize>>1);

#if defined(_WIN32) || defined(_WDL_SWELL_H_)
  //showwindmode = SW_NORMAL;
  //showwindmode = SW_MAXIMIZE;
  //showwindmode = SW_SHOWMAXIMIZED;
  if (!initapp(hinst)) return(-1);
#else
  if (!initapp()) return(-1);
#endif

  if (strlen(KCMVER) > 4) sprintf(tempbuf,"KCm " KCMVER);
  else sprintf(tempbuf,"KCm");
  SetWindowText(ghwnd,tempbuf);

  for(i=0;i<40;i++)
  {
    lineconnect[i+179] = lineconnect[i]-48;
    if (lineconnect[i+179] >= 10) lineconnect[i+179] -= 7;
  }
  for(i=0;i<179;i++) lineconnect[i] = 0;
  for(i=179+40;i<256;i++) lineconnect[i] = 0;

  lastfilename[0] = 0;
  curfilename[0] = 0;
  if (argc == 2)
  {
#if defined(_WIN32)
    _fullpath(curfilename,argv[1],MAX_PATH);
#else
    strcpy(curfilename,argv[1]);
#endif
    strcpy(lastfilename,curfilename);
    loadfile(curfilename);
  } else
  {
    lineoffs[0] = lineoffs[1] = lineoffs[2] = 0;
  }

  searchstr[0] = 0;
  replacestr[0] = 0;

    //int textfont9x16[256][4];
    //short textfont2[16*256];
  memset(textfont2,0,sizeof(textfont2));
  for(j=0;j<16;j++)
    for(i=0;i<256;i++)
      for(k=0;k<8;k++)
        if (textfont9x16[i][j>>2]&(1<<(((j&3)<<3)+7-k)))
          textfont2[j*256+i] |= (1<<k);
    //Fix for linedraw characters
  for(j=0;j<16;j++)
    for(i=192;i<224;i++)
      if (textfont2[j*256+i]&128) textfont2[j*256+i] |= 256;

  for(i=0;i<256;i++)
  {
    j = paldos[i>>4];
    pal_32[i*2+0] = ((((((unsigned)j)<< 8)&0xff000000)>>24) << 16)+
               ((((((unsigned)j)<<16)&0xff000000)>>24) <<  8)+
               ((((((unsigned)j)<<24)           )>>24)      );
    j = paldos[i&15];
    pal_32[i*2+1] = ((((((unsigned)j)<< 8)&0xff000000)>>24) << 16)+
               ((((((unsigned)j)<<16)&0xff000000)>>24) <<  8)+
               ((((((unsigned)j)<<24)           )>>24)      );
  }

#if defined(_WIN32) //|| defined(_WDL_SWELL_H_)
  ShowCursor(0);
#endif

  while (!breath())
  {
    //Read keyboard, mouse, and timer
    otim = tim; tim = klock(); dtim = tim-otim;
    totclk = (int)(tim*1000.0);

    if (ActiveApp)
    {
      if (bstatus&3)
      {
        if (!gclipcurs)
        {
#if defined(_WIN32) //|| defined(_WDL_SWELL_H_)
          RECT rect;

          gclipcurs = 1;

          GetCursorPos(&p0);
          rect.left = p0.x; rect.right  = p0.x+1;
          rect.top  = p0.y; rect.bottom = p0.y+1;

          ClipCursor(&rect);
#else
          p0.x = mousx; p0.y = mousy;
#endif
        }

        scrolled |= (dmousx|dmousy);
        mousxplc += min(max(dmousx*32,-4<<8),4<<8);
        mousyplc += min(max(dmousy*32,-4<<8),4<<8);
        mousxplc =     max(mousxplc,0)                     ;
        mousyplc = min(max(mousyplc,0),(numlines<<8)-tly-1);
        goalx = mousxplc+tlx;
        goaly = mousyplc+tly;
        curx =     max((mousxplc+tlx)>>8,0)            ;
        cury = min(max((mousyplc+tly)>>8,0),numlines-1);
        p0.x = ((mousxplc*charxsiz)>>8);
        p0.y = ((mousyplc*charysiz)>>8);

      } else
      {
        if (gclipcurs)
        {
          gclipcurs = 0;
#if defined(_WIN32) //|| defined(_WDL_SWELL_H_)
          ClipCursor(&gcursoldclip);
#endif

          p0.x = ((mousxplc*charxsiz)>>8);
          p0.y = ((mousyplc*charysiz)>>8);
#if defined(_WIN32) //|| defined(_WDL_SWELL_H_)
          ClientToScreen(ghwnd,&p0);
          SetCursorPos(p0.x,p0.y);
#else
          mousx = p0.x; mousy = p0.y;
#endif
        }
#if defined(_WIN32) //|| defined(_WDL_SWELL_H_)
        GetCursorPos(&p0); ScreenToClient(ghwnd,&p0);
#else
        p0.x = mousx; p0.y = mousy;
#endif
        mousxplc = (p0.x<<8)/charxsiz;
        mousyplc = (p0.y<<8)/charysiz;
        goalx = -1;
      }

#if defined(_WIN32) //|| defined(_WDL_SWELL_H_)
      if (((unsigned)p0.x < (unsigned)xres) && ((unsigned)p0.y < (unsigned)yres))
        { if ( gshowcurs) { gshowcurs = 0; ShowCursor(0); } } else
          if (!gshowcurs) { gshowcurs = 1; ShowCursor(1); }
#endif

      if ((bstatus&2) && (selmode == 1))
      {
        if (!(obstatus&2)) selshape ^= 1;
        selmode = 2;
      }
      if (bstatus&1)
      {
        if (!(obstatus&1)) { selx0 = curx; sely0 = cury; selshape = 0; }
        selx1 = curx; sely1 = cury; selmode = 1;
      } else if (obstatus&1) { selx1 = curx; sely1 = cury; selmode = 2; }

      xx = tlx; yy = tly;
      if (goalx >= 0)
      {
        i = 0;
        if ((goalx-(xdim<<7)) > tlx) i = (((goalx-(xdim<<7))-tlx)>>3)+1 ; else
        if ((goalx-(xdim<<7)) < tlx) i = -(((tlx-(goalx-(xdim<<7)))>>3)+1);
        j = tlx; tlx = max(tlx+i,0);
        mousxplc = max(mousxplc+(j-tlx),0);

        i = 0;
        if ((goaly-(ydim<<7)) > tly) i = (((goaly-(ydim<<7))-tly)>>3)+1 ; else
        if ((goaly-(ydim<<7)) < tly) i = -(((tly-(goaly-(ydim<<7)))>>3)+1);
        j = tly; tly = min(max(tly+i,0),numlines<<8);
        mousyplc = min(max(mousyplc+(j-tly),0),(numlines<<8)-tly-1);
      } else
      {
        i = tlx+(4<<8) - (curx<<8);          if (i > 0) tlx = max(tlx-16*((i>>6)+1),0);
        i = (curx<<8) - (tlx+((xdim-4)<<8)); if (i > 0) tlx += 16*((i>>6)+1);
        i = tly+(4<<8) - (cury<<8);          if (i > 0) tly = max(tly-16*((i>>6)+1),0);
        i = (cury<<8) - (tly+((ydim-4)<<8)); if (i > 0) tly += 16*((i>>6)+1);
      }

      scrolled |= ((xx^tlx)&~255);
      scrolled |= ((yy^tly)&~255);
      scrolled |= ((((xx&255)*charxsiz)^((tlx&255)*charxsiz))&~255);
      scrolled |= ((((yy&255)*charysiz)^((tly&255)*charysiz))&~255);

      if (dmousz)
      {
        tly -= dmousz*4;
        tly = max(tly,(cury+4-ydim)<<8);
        tly = min(tly,(cury-4     )<<8);
        tly = max(tly,          0);
        tly = min(tly,numlines<<8);
      }

      if (bstatus&3)
      {
        curx = max((mousxplc+tlx)>>8,0);
        cury = min(max((mousyplc+tly)>>8,0),numlines-1);
      }
    } else
    {
#if defined(_WIN32) //|| defined(_WDL_SWELL_H_)
      if (!gshowcurs) { gshowcurs = 1; ShowCursor(1); }

      GetCursorPos(&p0); ScreenToClient(ghwnd,&p0);
#else
      p0.x = mousx; p0.y = mousy;
#endif
      mousxplc = (p0.x<<8)/charxsiz;
      mousyplc = (p0.y<<8)/charysiz;
    }

    dmousx = 0; dmousy = 0; dmousz = 0;

    drawscreen();

#if defined(_WIN32)
    if (fixprio)
    {
      fixprio = 0;
      SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_NORMAL);
    }
#endif

    switch(kdiamode)
    {
      case INFODIALOG:
        while (key = keyread()) { kdialog[0] = 0; kdiamode = NODIALOG; } //any key exits
        goto doframe_ret;
      case VCERRDIALOG: case GCCERRDIALOG: case JAVERRDIALOG:
        while (key = keyread())
          switch((key>>8)&255)
          {
            case 0x1: kdialog[0] = 0; kdiamode = NODIALOG; break;
            case 0xc8:
              if (kdiagets0 > kdiaxsiz+2)
              {
                kdiagets0 -= kdiaxsiz;
                kdiagets1 -= kdiaxsiz;
              }
              break;
            case 0xd0:
              if (kdiagets0 < (kdiaysiz+1)*kdiaxsiz+2)
              {
                kdiagets0 += kdiaxsiz;
                kdiagets1 += kdiaxsiz;
              }
              break;
            case 0x1c: case 0x9c:
              switch (kdiamode)
              {
                case VCERRDIALOG:
                  j = 0;
                  for(i=kdiagets0;i<kdiagets1;i++)
                  {
                    if (kdialog[i] == '(') { j = i+1; continue; }
                    if ((kdialog[i] == ':') && (kdialog[j] >= '0') && (kdialog[j] <= '9'))
                    {
                      i = j;
                      cury = min(max(atoi(&kdialog[i])-1,0),numlines-1); //Jump to line
                      curx = gethomepos(cury);
                      for(;i<kdiagets1;i++)
                      {
                        if (kdialog[i] == ',') //Jump to column (if available)
                        {
                          x = atoi(&kdialog[i+1])-1;
                          if (savetab2spc) { curx = x; } else
                          {
                              //CSC counts tabs as 1 character in error display...
                            for(curx;x>0;x--,curx++)
                              if (curx+NUMTABSTOPS <= lineoffs[cury+1]-lineoffs[cury])
                              {
                                for(i=NUMTABSTOPS-1;i>0;i--)
                                  if (buf[x+i] != 32) break;
                                if (!i) curx += NUMTABSTOPS-1;
                              }
                          }
                          curx = min(max(curx,0),getendpos(cury));
                          break;
                        }
                        if ((kdialog[i] < '0') || (kdialog[i] > '9')) break;
                      }
                      break;
                    }
                  }
                  break;
                case GCCERRDIALOG:
                  for(i=kdiagets0;i<kdiagets1;i++)
                    if ((i > 0) && (kdialog[i-1] == ':') && (kdialog[i] >= '0') && (kdialog[i] <= '9'))
                    {
                      cury = min(max(atoi(&kdialog[i])-1,0),numlines-1); //Jump to line
                      curx = gethomepos(cury);
                      break;
                    }
                  break;
                case JAVERRDIALOG:
                  for(i=kdiagets0;i<kdiagets1;i++)
                    if ((i > 0) && (kdialog[i-1] == ':') && (kdialog[i] >= '0') && (kdialog[i] <= '9'))
                    {
                      cury = min(max(atoi(&kdialog[i])-1,0),numlines-1); //Jump to line
                      curx = gethomepos(cury);
                      break;
                    }
                  break;
              }
              kdialog[0] = 0; kdiamode = NODIALOG; break;
              break;
          }
        goto doframe_ret;
      case LINEDRAWDIALOG:
        while (key = keyread())
          switch((key>>8)&255)
          {
            case 0x1: linedrawmode = 0; kdialog[0] = 0; kdiamode = NODIALOG; break;
            case 0x2: linedrawmode = 1; kdialog[0] = 0; kdiamode = NODIALOG; break;
            case 0x3: linedrawmode = 2; kdialog[0] = 0; kdiamode = NODIALOG; break;
            case 0x4: linedrawmode = 3; kdialog[0] = 0; kdiamode = NODIALOG; break;
            case 0x5: linedrawmode = 4; kdialog[0] = 0; kdiamode = NODIALOG; break;
          }
        goto doframe_ret;
      case SEARCHDIALOG:
        while (key = keyread())
        {
          switch((key>>8)&255)
          {
            case 1: kdialog[0] = 0; kdiamode = NODIALOG; goto doframe_ret;
            case 0x21: //F
              kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
              kdiamode = FINDDIALOG; kdiafirstime = 1;
              kdiamatchwordncase = ((key&0x30000) != 0);
              kdiacursor = kdiagets0 = 69; kdiagets1 = kdiagets0+32;
              strcpy(kdialog," ͻ \n"\
                             "  Find what:                                     \n"\
                             " ͼ \n");
              strcpy(&kdialog[kdiacursor],searchstr);
              kdiacursor += strlen(&kdialog[kdiacursor]);
              kdialog[kdiacursor] = ' ';
              goto doframe_ret;
            case 0x2e: //C
              kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
              kdiamode = CHANGE0DIALOG; kdiafirstime = 1;
              kdiamatchwordncase = ((key&0x30000) != 0);
              kdiacursor = kdiagets0 = 69; kdiagets1 = kdiagets0+32;
              strcpy(kdialog," ͻ \n"\
                             "  Find what:                                     \n"\
                             " Ķ \n"\
                             "  Change to:                                     \n"\
                             " ͼ \n");
              strcpy(&kdialog[kdiacursor],searchstr);
              kdiacursor += strlen(&kdialog[kdiacursor]);
              kdialog[kdiacursor] = ' ';
              goto doframe_ret;
          }
        }
        goto doframe_ret;
      case FILEDIALOG:
        while (key = keyread())
        {
          switch((key>>8)&255)
          {
            case 1: kdialog[0] = 0; kdiamode = NODIALOG; goto doframe_ret;
            case 0x31: //N
              curfilename[0] = 0; settitle(0);
              tlx = 0; tly = 0; curx = 0; cury = 0;
              lineoffs[0] = lineoffs[1] = lineoffs[2] = 0; numlines = 1;
              kdialog[0] = 0; kdiamode = NODIALOG;
                            goto doframe_ret;
            case 0x18: //O
              strcpy(fileselectnam,curfilename);
#if defined(_WIN32) //|| defined(_WDL_SWELL_H_)
              if (!gshowcurs) { gshowcurs = 1; ShowCursor(1); }
#endif
              if (v = (char *)loadfileselect("Open file...",TXTFILES,DEFEXT))
              {
#if defined(_WIN32)
                _fullpath(tempbuf,v,MAX_PATH);
#else
                strcpy(tempbuf,v);
#endif
                if ((stricmp(curfilename,tempbuf) != 0) && (curfilename != 0))
                {
                  strcpy(lastfilename,curfilename);
                  lasttlx = tlx; tlx = 0;
                  lasttly = tly; tly = 0;
                  lastcurx = curx; curx = 0;
                  lastcury = cury; cury = 0;
                  lastotlx = otlx; otlx = 0;
                  lastotly = otly; otly = 0;
                  lastgoalx = goalx; goalx = -1;
                  lastgoaly = goaly; goaly = 0;
                }
                strcpy(curfilename,tempbuf);
                loadfile(curfilename);
              }
              bstatus = 0;
              kdialog[0] = 0; kdiamode = NODIALOG;
              goto doframe_ret;
            case 0x1f: //S
              if (!curfilename[0]) { goto saveas; }
              savefile(curfilename);
              kdialog[0] = 0; kdiamode = NODIALOG;
              goto doframe_ret;
            case 0x1e: //A
saveas:       strcpy(fileselectnam,curfilename);
#if defined(_WIN32) //|| defined(_WDL_SWELL_H_)
              if (!gshowcurs) { gshowcurs = 1; ShowCursor(1); }
#endif
              if (v = (char *)savefileselect("Save file...",TXTFILES,DEFEXT))
              {
#if defined(_WIN32)
                _fullpath(curfilename,v,MAX_PATH);
#else
                strcpy(curfilename,v);
#endif
                savefile(curfilename);
              }
              bstatus = 0;
              kdialog[0] = 0; kdiamode = NODIALOG;
              goto doframe_ret;
            case 0x2d: //X
              quitloop();
#if defined(_WIN32)
              timeEndPeriod(1);
#endif
              if (buf) { free(buf); buf = 0; }
              uninitapp();
              return(0);
          }
        }
        goto doframe_ret;
      case CHANGEYNADIALOG:
        while (key = keyread())
        {
          switch((key>>8)&255)
          {
            case 1: kdialog[0] = 0; kdiamode = NODIALOG; goto doframe_ret;
            case 0x1c: case 0x9c: //Enter
            case 0x15: //Y
              settitle(1);
              i = strlen(searchstr);
              j = strlen(replacestr);
              if (j > i) insertchar(curx,cury,j-i);
              if (j < i) deletechar(curx,cury,i-j);
              for(cptr=replacestr;*cptr;cptr++,curx++)
                buf[lineoffs[cury]+curx] = *cptr;
              curx--;
              //NOTE: NO BREAK INTENTIONAL!
            case 0x31: //N
              if (findnext(searchstr) < 0)
              {
                curx = ocurx; cury = ocury;
                kdialog[0] = 0; kdiamode = NODIALOG; goto doframe_ret;
              }
              goto doframe_ret;
            case 0x1e: //A
              settitle(1);
              i = strlen(searchstr);
              j = strlen(replacestr);
              if (j <= i)
              {
                x1 = x2 = 0;
                for(yy=0;yy<numlines;yy++)
                {
                  k = 0;  //k is current # chars matching
                  while (x1 < lineoffs[yy+1])
                  {
                    ch1 = buf[x1]; ch2 = searchstr[k];
                    if ((ch1 >= 97) && (ch1 <= 122)) ch1 -= 32;
                    if ((ch2 >= 97) && (ch2 <= 122)) ch2 -= 32;
                    if (ch1 == ch2)
                    {
                      k++;
                      if (k >= i)
                      {
                        for(cptr=replacestr;*cptr;cptr++) buf[x2++] = *cptr;
                        k = 0;
                      }
                    } else
                    {
                      if (k > 0) { x1 -= k; k = 0; } //Bug fix 7/6/1999!
                      buf[x2++] = buf[x1];
                    }
                    x1++;
                  }
                  while (k > 0)
                  {
                    buf[x2++] = buf[x1-k];
                    k--;
                  }
                  lineoffs[yy+1] = x2;
                }
              } else
              {
                x2 = 0;  //This mode UGLY because must find unknown write start position!
                x1 = lineoffs[numlines];
                for(yy=numlines-1;yy>=0;yy--)
                {
                  k = i;  //k is current # chars matching
                  while (x1 > lineoffs[yy]) //Bug fix 09/10/2000!
                  {
                    x1--;
                    ch1 = buf[x1]; ch2 = searchstr[k-1];
                    if ((ch1 >= 97) && (ch1 <= 122)) ch1 -= 32;
                    if ((ch2 >= 97) && (ch2 <= 122)) ch2 -= 32;
                    if (ch1 == ch2)
                    {
                      k--; if (k <= 0) { x2++; k = i; }
                    } else
                    {
                      if (k < i) x1 += i-k; //Bug fix 7/6/1999!
                      k = i;
                    }
                  }
                }

                x1 = lineoffs[numlines];
                x2 = (j-i)*x2 + x1;
                lineoffs[numlines] = x2;
                for(yy=numlines-1;yy>=0;yy--)
                {
                  k = i;  //k is current # chars matching
                  while (x1 > lineoffs[yy])
                  {
                    x1--;
                    ch1 = buf[x1]; ch2 = searchstr[k-1];
                    if ((ch1 >= 97) && (ch1 <= 122)) ch1 -= 32;
                    if ((ch2 >= 97) && (ch2 <= 122)) ch2 -= 32;
                    if (ch1 == ch2)
                    {
                      k--;
                      if (k <= 0)
                      {
                        for(cptr=&replacestr[j-1];cptr>=replacestr;cptr--) buf[--x2] = *cptr;
                        k = i;
                      }
                    } else
                    {
                      if (k < i) { x1 += i-k; k = i; }  //Bug fix 7/6/1999!
                      buf[--x2] = buf[x1];
                    }
                  }

                  x1 += i-k; k = i;          //Bug fix 09/10/2000!
                  while (x1 > lineoffs[yy])  //Bug fix 09/10/2000!
                    buf[--x2] = buf[--x1];  //Bug fix 09/10/2000!

                  lineoffs[yy] = x2;
                }
              }
              curx = ocurx; cury = ocury;
              kdialog[0] = 0; kdiamode = NODIALOG; goto doframe_ret;
          }
        }
        goto doframe_ret;
      case GOTODIALOG: case FINDDIALOG: case CHANGE0DIALOG: case CHANGE1DIALOG: case SETTABDIALOG: 
      case OPENDIALOG: case SAVEASDIALOG:
        while (key = keyread())
        {
          if (((key>>8)&255) == 1) { kdialog[0] = 0; kdiamode = NODIALOG; goto doframe_ret; } else
          if (((key>>8)&255) == 0xcb) { if (kdiacursor > kdiagets0) kdiacursor--; } else
          if (((key>>8)&255) == 0xcd) { if (kdiacursor < kdiagets1) kdiacursor++; } else
          if (((key>>8)&255) == 0xc7) { kdiacursor = kdiagets0; } else
          if (((key>>8)&255) == 0xcf)
          {
            for(kdiacursor=kdiagets1;kdiacursor>kdiagets0;kdiacursor--)
              if (kdialog[kdiacursor-1] != 32) break;
          } else if ((key&255) >= 32)
          {
              //Allow only numbers in GOTO dialog
            if ((((key-'0')&255) >= 10) && (kdiamode == GOTODIALOG)) break;
            if ((((key-'0')&255) >= 10) && (kdiamode == SETTABDIALOG)) break;
              //String is full!
            if (kdialog[kdiagets1-1] != 32) break;

            if (kdiafirstime) //Clear string if first key is character
            {
              for(i=kdiagets0;i<kdiagets1;i++) kdialog[i] = ' ';
              kdiacursor = kdiagets0;
            }
            if (kdiacursor < kdiagets1)
            {
              for(i=kdiagets1-1;i>kdiacursor;i--) kdialog[i] = kdialog[i-1];
              kdialog[kdiacursor++] = (key&255);
            }
          } else if ((key&255) == 8)
          {
            if (kdiacursor > kdiagets0)
              { for(i=--kdiacursor;i<kdiagets1;i++) kdialog[i] = kdialog[i+1]; }
          } else if (((key>>8)&255) == 0xd3)
          {
            for(i=kdiacursor;i<kdiagets1;i++) kdialog[i] = kdialog[i+1];
          } else if (((key&255) == 13) || (((key&255) == 9) && (kdiamode == CHANGE0DIALOG)))
          {
            switch(kdiamode)
            {
              case SETTABDIALOG:
                j = 0;
                for(i=kdiagets0;i<kdiagets1;i++)
                {
                  if ((kdialog[i] < '0') || (kdialog[i] > '9')) break;
                  j = j*10+kdialog[i]-'0';
                }
                //if (j > 0) NUMTABSTOPS = min(max(j,2),8);
                break;
              case GOTODIALOG:
                j = 0;
                for(i=kdiagets0;i<kdiagets1;i++)
                {
                  if ((kdialog[i] < '0') || (kdialog[i] > '9')) break;
                  j = j*10+kdialog[i]-'0';
                }
                if (j > 0) cury = min(max(j-1,0),numlines-1);
                break;
              case FINDDIALOG:
                for(i=kdiagets1;i>kdiagets0;i--)
                  if (kdialog[i-1] != 32) break;
                if (kdiacursor > i) i = kdiacursor;
                kdialog[i] = 0;
                strcpy(searchstr,&kdialog[kdiagets0]);
                findnext(searchstr);
                break;
              case CHANGE0DIALOG:
                for(i=kdiagets1;i>kdiagets0;i--)
                  if (kdialog[i-1] != 32) break;
                if (kdiacursor > i) i = kdiacursor;
                kdialog[i] = 0;
                strcpy(searchstr,&kdialog[kdiagets0]);
                kdialog[i] = 32;

                ocurx = curx; ocury = cury;
                if (findnext(searchstr) < 0) break;

                kdiamode = CHANGE1DIALOG; kdiafirstime = 1;
                kdiacursor = kdiagets0 = 175; kdiagets1 = kdiagets0+32;
                strcpy(&kdialog[kdiacursor],replacestr);
                kdiacursor += strlen(&kdialog[kdiacursor]);
                kdialog[kdiacursor] = ' ';
                goto doframe_ret;
              case CHANGE1DIALOG:
                for(i=kdiagets1;i>kdiagets0;i--)
                  if (kdialog[i-1] != 32) break;
                if (kdiacursor > i) i = kdiacursor;
                kdialog[i] = 0;
                strcpy(replacestr,&kdialog[kdiagets0]);

                kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
                kdiamode = CHANGEYNADIALOG; kdiafirstime = 1;
                kdiagets0 = kdiagets1 = 0; kdiacursor = -1;
                strcpy(kdialog," ͻ \n"\
                               "  Change? \rYes/\rNo/\rAll  \n"\
                               " ͼ \n");
                goto doframe_ret;
              case OPENDIALOG:
                for(i=kdiagets1;i>kdiagets0;i--)
                  if (kdialog[i-1] != 32) break;
                kdialog[i] = 0;
                if ((stricmp(curfilename,&kdialog[kdiagets0]) != 0) && (curfilename != 0))
                {
                  strcpy(lastfilename,curfilename);
                  lasttlx = tlx; tlx = 0;
                  lasttly = tly; tly = 0;
                  lastcurx = curx; curx = 0;
                  lastcury = cury; cury = 0;
                  lastotlx = otlx; otlx = 0;
                  lastotly = otly; otly = 0;
                  lastgoalx = goalx; goalx = -1;
                  lastgoaly = goaly; goaly = 0;
                }
#if defined(_WIN32)
                _fullpath(curfilename,&kdialog[kdiagets0],MAX_PATH);
#else
                strcpy(curfilename,&kdialog[kdiagets0]);
#endif
                loadfile(curfilename);
                break;
              case SAVEASDIALOG:
                for(i=kdiagets1;i>kdiagets0;i--)
                  if (kdialog[i-1] != 32) break;
                kdialog[i] = 0;
#if defined(_WIN32)
                _fullpath(curfilename,&kdialog[kdiagets0],MAX_PATH);
#else
                strcpy(curfilename,&kdialog[kdiagets0]);
#endif
                savefile(curfilename);
                break;
            }
            kdialog[0] = 0; kdiamode = NODIALOG;
          }
          if (kdiafirstime) kdiafirstime = 0;
        }
        goto doframe_ret;
      default:;
    }

    if (!(keystatus[0x38]|keystatus[0xb8]))
    {
      if ((altkpcharstat >= 32) && (altkpcharstat < 256))
      {
        if (insertmode)
          { insertchar(curx,cury,curx-(lineoffs[cury+1]-lineoffs[cury])+1); } else
          { insertchar(curx,cury,(int)max(curx-(lineoffs[cury+1]-lineoffs[cury]-1),1)); }
        buf[lineoffs[cury]+curx] = altkpcharstat;
        curx++;
        selmode = 0;
        shiftstat = 0;
      }
      altkpcharstat = -1;
    }

      //Byte 0: ASCII character, or 0 if non-ASCII key such as arrows, etc...
      //Byte 1: Scan code: same format as keystatus[]. Always written.
      //Byte 2: 0:LShift,1:RShift,2=LCtrl,3=RCtrl,4=LAlt,5=RAlt
      //If buffer is empty, then all 4 bytes are 0. Check this first!
    while (key = keyread())
    {
      shiftstat = ((key>>16)&63);
      if (((key&0xff) >= 32) && (!(key&0x3c0000)))
      {
          //Don't insert spaces after the end of a line
        if (((key&0xff) > 32) || (curx < lineoffs[cury+1]-lineoffs[cury]))
        {
          if (insertmode)
            { insertchar(curx,cury,curx-(lineoffs[cury+1]-lineoffs[cury])+1); } else
            { insertchar(curx,cury,(int)max(curx-(lineoffs[cury+1]-lineoffs[cury]-1),1)); }
          buf[lineoffs[cury]+curx] = (key&255);
        }
        curx++;
        selmode = 0;
        shiftstat = 0;
        settitle(1);
      } else
      {
        oshiftstat = shiftstat;
        switch ((key>>8)&255)
        {
          case 0x0d: //'='
            if (key&0xc0000) //CTRL+'='
            {
              if (selmode) { quickeval(selx0,sely0,selx1,sely1,selshape); selmode = 0; shiftstat = 0; settitle(1); }
            }
            break;
          case 0x0f: //Tab
            if (key&0x30000) //SHIFT+Tab
            {
              shifttextleft(sely0,sely1,NUMTABSTOPS,1);
              settitle(1);
              break;
            }
            if ((sely0 != sely1) && (selmode)) { shifttextright(sely0,sely1,NUMTABSTOPS); } else
            {
              selmode = 0;
              insertchar(curx,cury,(int)max(curx-(lineoffs[cury+1]-lineoffs[cury]-1),NUMTABSTOPS));
              curx += NUMTABSTOPS;
            }
            settitle(1);
            break;
          case 0x0e: //Backspace
            selmode = 0;
            if (curx == 0)
            {
              if (cury > 0)
              {
                curx = lineoffs[cury]-lineoffs[cury-1];
                for(i=cury;i<numlines;i++) lineoffs[i] = lineoffs[i+1];
                numlines--;
                if (numlines <= 0) { numlines = 1; lineoffs[0] = lineoffs[1] = lineoffs[2] = 0; }
                cury--;
              }
            } else
            {
              j = min(NUMTABSTOPS,curx);
              for(i=1;i<=NUMTABSTOPS;i++)
                if (buf[lineoffs[cury]+curx-i] != 32) { j = 1; break; }
              curx -= j;
              if (curx < lineoffs[cury+1]-lineoffs[cury])
                deletechar(curx,cury,j);
            }
            settitle(1);
            break;
          case 0x1c: case 0x9c: //Enter
            j = min(curx,lineoffs[cury+1]-lineoffs[cury]);
            numlines++;
            for(i=numlines;i>cury;i--) lineoffs[i] = lineoffs[i-1];
            lineoffs[cury+1] = lineoffs[cury]+j;

            i = curx;
            curx = gethomepos(cury);
            if ((curx == 0) && (buf[lineoffs[cury]] == 32)) curx = i;
            cury++;

            insertchar(0L,cury,curx);

            deleteendspace(cury-1);
            settitle(1);
            break;
          case 0x15: //Y
            if (key&0xc0000) //CTRL+Y
            {
              deletechar(0L,cury,lineoffs[cury+1]-lineoffs[cury]);
              if (cury < numlines-1)
              {
                numlines--;
                for(i=cury;i<=numlines;i++) lineoffs[i] = lineoffs[i+1];
              }
              settitle(1);
            }
            break;
          case 0xcb: //Left
            if (key&0xc0000) //CTRL+Left
            {
              i = lineoffs[cury]+min(curx,lineoffs[cury+1]-lineoffs[cury]);
              while ((((buf[i] >= 48) && (buf[i] <= 57)) ||
                    ((buf[i] >= 65) && (buf[i] <= 90)) ||
                    ((buf[i] >= 97) && (buf[i] <= 122))) && (i > 0)) i--;
              while ((((buf[i] < 48) || (buf[i] > 57)) &&
                    ((buf[i] < 65) || (buf[i] > 90)) &&
                    ((buf[i] < 97) || (buf[i] > 122))) && (i > 0)) i--;
              while ((((buf[i] >= 48) && (buf[i] <= 57)) ||
                    ((buf[i] >= 65) && (buf[i] <= 90)) ||
                    ((buf[i] >= 97) && (buf[i] <= 122))) && (i > 0)) i--;
              i++;
              for(j=0;i>=lineoffs[j+1];j++);
              cursormove(oshiftstat,shiftstat,i-lineoffs[j],j);
              break;
            }
            if (!linedrawmode)
            {
              if (curx > 0) cursormove(oshiftstat,shiftstat,curx-1,cury);
            } else
            {
              ocurx = curx; ocury = cury;
              if (curx > 0)
              {
                curx--;
                insertchar(ocurx,ocury,ocurx-(lineoffs[ocury+1]-lineoffs[ocury])+1);
                insertchar(curx,cury,curx-(lineoffs[cury+1]-lineoffs[cury])+1);
                connectline(ocurx,ocury,curx,cury);
                settitle(1);
              }
            }
            break;
          case 0xcd: //Right
            if (key&0xc0000) //CTRL+Right
            {
              i = lineoffs[cury]+min(curx,lineoffs[cury+1]-lineoffs[cury]);
              while ((((buf[i] >= 48) && (buf[i] <= 57)) ||
                    ((buf[i] >= 65) && (buf[i] <= 90)) ||
                    ((buf[i] >= 97) && (buf[i] <= 122))) && (i < lineoffs[numlines])) i++;
              while ((((buf[i] < 48) || (buf[i] > 57)) &&
                    ((buf[i] < 65) || (buf[i] > 90)) &&
                    ((buf[i] < 97) || (buf[i] > 122))) && (i < lineoffs[numlines])) i++;
              if (i < lineoffs[numlines])
              {
                for(j=0;i>=lineoffs[j+1];j++);
                cursormove(oshiftstat,shiftstat,i-lineoffs[j],j);
              }
              break;
            }
            if (!linedrawmode)
            {
              cursormove(oshiftstat,shiftstat,curx+1,cury);
            } else
            {
              ocurx = curx; ocury = cury;
              curx++;
              insertchar(ocurx,ocury,ocurx-(lineoffs[ocury+1]-lineoffs[ocury])+1);
              insertchar(curx,cury,curx-(lineoffs[cury+1]-lineoffs[cury])+1);
              connectline(ocurx,ocury,curx,cury);
              settitle(1);
            }
            break;
          case 0xc8: //Up
            if (key&0xc0000) //CTRL+Up
            {
              if (cury < (tly>>8)+ydim-4) tly = max((tly-1)&~255,0);

              //tly = max((tly-1)&~255,0);
              //if (cury > (tly>>8)+ydim-4)
              //   cursormove(oshiftstat,shiftstat,curx,max(cury-1,0));
              break;
            }
            if (!linedrawmode)
            {
              if (cury > 0) cursormove(oshiftstat,shiftstat,curx,cury-1);
            } else
            {
              ocurx = curx; ocury = cury;
              if (cury > 0)
              {
                cury--;
                insertchar(ocurx,ocury,ocurx-(lineoffs[ocury+1]-lineoffs[ocury])+1);
                insertchar(curx,cury,curx-(lineoffs[cury+1]-lineoffs[cury])+1);
                connectline(ocurx,ocury,curx,cury);
                settitle(1);
              }
            }
            break;
          case 0xd0: //Down
            if (key&0xc0000) //CTRL+Down
            {
              if (cury > (tly>>8)+4) tly = max(min((tly|255)+1,(numlines-4)<<8),0);

                //tly = max(min((tly|255)+1,(numlines-(ydim>>1))<<8),0);
              //if (cury < (tly>>8)+4)
              //   cursormove(oshiftstat,shiftstat,curx,min(cury+1,numlines-1));
              break;
            }
            if (!linedrawmode)
            {
              if (cury < numlines-1) cursormove(oshiftstat,shiftstat,curx,cury+1);
            } else
            {
              ocurx = curx; ocury = cury;
              cury++;
              if (cury >= numlines)
                { lineoffs[numlines+1] = lineoffs[numlines]; numlines++; }
              insertchar(ocurx,ocury,ocurx-(lineoffs[ocury+1]-lineoffs[ocury])+1);
              insertchar(curx,cury,curx-(lineoffs[cury+1]-lineoffs[cury])+1);
              connectline(ocurx,ocury,curx,cury);
              settitle(1);
            }
            break;
          case 0xc7: //Home
            if (key&0xc0000) //CTRL+Home
            {
              cursormove(oshiftstat,shiftstat,0,0);
              break;
            }
            if (curx == gethomepos(cury))
            {
              cursormove(oshiftstat,shiftstat,0,cury);
            } else
            {
              cursormove(oshiftstat,shiftstat,gethomepos(cury),cury);
            }
            break;
          case 0xcf: //End
            if (key&0xc0000) //CTRL+End
            {
              cursormove(oshiftstat,shiftstat,lineoffs[numlines]-lineoffs[numlines-1],numlines-1);
              break;
            }
            cursormove(oshiftstat,shiftstat,getendpos(cury),cury);
            break;
          case 0xc9: //PGUP
            cursormove(oshiftstat,shiftstat,curx,max(cury-ydim,0));
            break;
          case 0xd1: //PGDN
            cursormove(oshiftstat,shiftstat,curx,min(cury+ydim,numlines-1));
            break;
          case 0x3b: //F1
            if (key&0xc0000) //CTRL+F1
            {
              sprintf(tempbuf,
                " ͻ \n"\
                "  About KCm (KC Modificata)                     \n"\
                "                                                \n"\
                "  KC original author ... Ken Silverman          \n"\
                "  Website .............. http://advsys.net/ken  \n"\
                "                                                \n"\
                "  KCm (KC Modificata) .. Giorgos Vougioukas     \n"\
                "  Website .............. http://www.grafmin.gr  \n"\
                "                                                \n"\
                "  WDL .................. Cockos Incorporated    \n"\
                "  Website .............. http://www.cockos.com  \n"\
                " ͼ \n");
              kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
              kdiamode = INFODIALOG; kdiafirstime = 1;
              kdiagets0 = kdiagets1 = 0; kdiacursor = -1;
              strcpy(kdialog,tempbuf);
              break;
            }
            sprintf(tempbuf,
              " ͻ \n"\
              "  KCm quick help                                                                                     \n"\
              "                                                                                                     \n"\
              "  Ctrl+F1 ... About KCm                   Alt+F ........... File dialog                              \n"\
              "  Ctrl+F2 ... Open changelog.txt          Alt+S ........... Search dialog                            \n"\
              "  Ctrl+F3 ... Version details             Shift+Tab ....... Move highlighted text left               \n"\
              "  F1 ........ Quick help                  Tab ............. Move highlighted text right              \n"\
              "  F2 ........ Load previous file          Alt+[ ........... Move highlighted text left; if (space)   \n"\
              "  F3 ........ Find next                   Alt+] ........... Move highlighted text right; if (space)  \n"\
              "  Alt+F3 .... Find previous               Alt+J ........... Toggle show line length                  \n"\
              "  F4 ........ Minimize window             Alt+K ........... Toggle spooky                            \n"\
              "  F5 ........ Save and compile            Alt+L ........... Line draw dialog                         \n"\
              "  F9 ........ Toggle CRLF/LF              F12 ............. Toggle show FPS                          \n"\
              "  F10 ....... Toggle TAB/SPACE            Ctrl+C .......... Copy (clipboard)                         \n"\
              "  Ctrl+Y .... Delete line                 Ctrl+V .......... Paste (clipboard)                        \n"\
              "  Alt+G ..... Goto line                   Ctrl+INS ........ Copy (internal buffer)                   \n"\
              "  Ctrl+= .... Evaluate highlighted text   Shift+INS ....... Paste (internal buffer)                  \n"\
              "  RClick .... Smooth scrolling            Alt+[3 keypad #]  Enter ASCII character                    \n"\
              " ͼ \n");
            kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
            kdiamode = INFODIALOG; kdiafirstime = 1;
            kdiagets0 = kdiagets1 = 0; kdiacursor = -1;
            strcpy(kdialog,tempbuf);
            break;
          case 0x3c: //F2
            if (key&0xc0000) //CTRL+F2
            {
#if defined(_WIN32) || defined(_WDL_SWELL_H_)
              char modfn[2048];
              GetModuleFileName(hinst,modfn,sizeof(modfn));
              char *mfp = modfn;
              while (*mfp++);
              while (*mfp != WDL_DIRCHAR) *mfp--;
              strcpy(mfp+1,"changelog.txt");
#if defined(_WIN32)
              _fullpath(curfilename,modfn,MAX_PATH);
#else
              strcpy(curfilename,&modfn[0]);
#endif
              loadfile(curfilename);
#endif
              break;
            }

            if (lastfilename[0])
            {
              strcpy(tempbuf,curfilename);
              strcpy(curfilename,lastfilename);
              strcpy(lastfilename,tempbuf);
              i = lasttlx; lasttlx = tlx; tlx = i;
              i = lasttly; lasttly = tly; tly = i;
              i = lastcurx; lastcurx = curx; curx = i;
              i = lastcury; lastcury = cury; cury = i;
              i = lastotlx; lastotlx = otlx; otlx = i;
              i = lastotly; lastotly = otly; otly = i;
              i = lastgoalx; lastgoalx = goalx; goalx = i;
              i = lastgoaly; lastgoaly = goaly; goaly = i;

#if defined(_WIN32)
                //This makes sure F5 command works after doing some F2
              _splitpath(curfilename,tempbuf,&tempbuf[MAX_PATH],0,0);
              strcat(tempbuf,&tempbuf[MAX_PATH]);
              _chdir(tempbuf);
#endif

              loadfile(curfilename);
            }
            break;
          case 0x3d: //F3
            if (key&0xc0000) //CTRL+F3
            {
              const char *dati = __DATE__ " " __TIME__;
              const char *kcve = KCMVER " (" KCMARCH ")";
              sprintf(tempbuf,
              " ͻ \n"\
              "  Version details                           \n"\
              "                                            \n"\
              "  KCm version .......                       \n"\
              "                                            \n"\
              "  Build timestamp ...                       \n"\
              " ͼ \n");
              memcpy(&tempbuf[164],kcve,strlen(kcve));
              memcpy(&tempbuf[258],dati,strlen(dati));
              kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
              kdiamode = INFODIALOG; kdiafirstime = 1;
              kdiagets0 = kdiagets1 = 0; kdiacursor = -1;
              strcpy(kdialog,tempbuf);
              break;
            }
            if (key&0x300000) { findlast(searchstr); goto doframe_ret; } //ALT+F3
            findnext(searchstr); goto doframe_ret;
            break;
#if defined(_WIN32)
          case 0x3e: //F4
            WINDOWPLACEMENT wp;
            wp.length = sizeof(WINDOWPLACEMENT);
            GetWindowPlacement(ghwnd,&wp);
            if (wp.showCmd == SW_SHOWNORMAL)
            {
              maxi = 0; wp.showCmd = SW_SHOWMINIMIZED;
            } else if (wp.showCmd == SW_SHOWMAXIMIZED)
            {
              maxi = 1; wp.showCmd = SW_SHOWMINIMIZED;
            } else
            {
              if (maxi) wp.showCmd = SW_SHOWMAXIMIZED;
               else wp.showCmd = SW_SHOWNORMAL;
            }
            SetWindowPlacement(ghwnd,&wp);
            break;
#endif
          case 0x3f: //F5
            savefile(curfilename);
#if defined(_WIN32)
            i = strlen(curfilename);
            if ((i >= 5) && (!stricmp(&curfilename[i-5],".JAVA")))
                mode = 2; else mode = 0;

            switch(mode)
            {
              case 0:/*VC6*/ case 1:/*GCC*/
                {
                char tbuf[MAX_PATH];
                _searchenv("nmake.exe","PATH",tbuf);
                sprintf(tempbuf,"nmake -f \"%s\" /s /nologo",curfilename);
                cptr = &tempbuf[sizeof(tempbuf)>>1];
                j = mypopen(tbuf,tempbuf,tempbuf,sizeof(tempbuf)>>1,cptr,sizeof(tempbuf)-(sizeof(tempbuf)>>1));
                i = strlen(cptr);
                if (i >= sizeof(tempbuf)-(sizeof(tempbuf)>>1)-1) { bad = 1; } else
                if ((i >= 9) && (!memcmp(&cptr[i-9],"\r\nStop.\r\n",9))) { bad = 1; } else
                bad = 0;
                break;
                }
              case 2:
                {
                char tbuf[MAX_PATH];
                _searchenv("javac.exe","PATH",tbuf);
                if (tbuf[0])
                {
                  sprintf(tempbuf,"%s %s",tbuf,curfilename);
                  j = mypopen(tbuf,tempbuf,(char *)&bad,2,tempbuf,sizeof(tempbuf));
                } else j = -1;
                break;
                }
            }
            if (j >= 0)
            {
              fixprio = 1;
              SetThreadPriority(GetCurrentThread(),THREAD_PRIORITY_IDLE);
              //setacquire(0,1);

                //Write NMAKE stdout&stderr to tempbuf (length is j)
              j = 0; x = 0; xx = 0; yy = 0; //xx,yy = size of rectangle
              if ((tempbuf[0]) || (mode == 2)) { k = 0; } else //VC6 outputs errors on stdout
                                    { k = (sizeof(tempbuf)>>1); mode = 1; } //GCC outputs errors on stderr
              while ((i = tempbuf[k++]) && (j < min(sizeof(tempbuf),sizeof(kdialog))-1))
              {
                if (i >= 32) { tempbuf[j++] = i; x++; } else
                if (i ==  9) { tempbuf[j++] = ' '; x++; } else
                if (i == 13) { tempbuf[j++] = '\n'; if (x > xx) xx = x; yy++; x = 0; }
              }
              if (x > xx) xx = x; yy++;
              tempbuf[j] = 0;

                //If no compile errors, then run program (must be same filename with .EXE extension)
              if (((mode == 0) || (mode == 1)) && (!bad))
              {
                if (!memcmp(buf,"#if 0 //F5NORUN",15)) //..Hack (10/21/2019):don't run if this is 1st line
                {  ;
                } else
                {
                  kdialog[0] = 0; kdiamode = NODIALOG;
                  strcpy(tempbuf,curfilename);
                  for(i=0,j=0;tempbuf[i];i++) if (tempbuf[i] == '.') j = i;
                  strcpy(&tempbuf[j],".exe");
                  _spawnlp(_P_NOWAIT,tempbuf,tempbuf,0);
                }
              } else if ((mode == 2) && (yy < 2))
              {
                kdialog[0] = 0; kdiamode = NODIALOG;
                if (!memicmp(buf,"//<applet code=",15))
                {
                  strcpy(tempbuf,curfilename);
                  for(i=0,j=-1;tempbuf[i];i++) if (tempbuf[i] == '\\') j = i;
                  _spawnlp(_P_NOWAIT,"appletviewer.exe","appletviewer.exe",&tempbuf[j+1],0);
                } else
                {
                  _fullpath(tempbuf,curfilename,sizeof(tempbuf));
                  for(i=j=0;tempbuf[i];i++) if (tempbuf[i] == '\\') j = i;
                  for(i=k=j;tempbuf[i];i++) if (tempbuf[i] == '.') k = i;
                  tempbuf[j] = tempbuf[k] = 0;
                  _spawnlp(_P_NOWAIT,"java.exe","java.exe","-cp",tempbuf,&tempbuf[j+1],0);
                }
              } else
              {
                if ((xx <= 0) || (yy <= 0)) goto nmakeerr;
                i = xres/charxsiz-4; if (xx > i) xx = i;

                  //Fit compile error dialog to rectangle
                k = 0; y = 0;
                kdialog[k++] = ' '; kdialog[k++] = '';
                for(x=0;x<xx;x++) kdialog[k++] = '';
                kdialog[k++] = ''; kdialog[k++] = ' '; kdialog[k++] = '\n';

                kdialog[k++] = ' '; kdialog[k++] = ''; x = 0;
                for(i=0;i<j;i++)
                {
                  if (tempbuf[i] >= 32)
                  {
                    if (x < xx) { kdialog[k++] = tempbuf[i]; } else
                    if (xx > 0) { kdialog[k-1] = 175; } //(double right arrow)
                    x++;
                  } else if (tempbuf[i] == '\n')
                  {
                    y++; if ((y >= 16) || (i == j-1)) break;
                    for(;x<xx;x++) kdialog[k++] = ' ';
                    kdialog[k++] = ''; kdialog[k++] = ' '; kdialog[k++] = '\n';
                    kdialog[k++] = ' '; kdialog[k++] = ''; x = 0;
                  }
                }
                for(;x<xx;x++) kdialog[k++] = ' ';
                kdialog[k++] = ''; kdialog[k++] = ' '; kdialog[k++] = '\n';

                kdialog[k++] = ' '; kdialog[k++] = '';
                for(x=0;x<xx;x++) kdialog[k++] = '';
                kdialog[k++] = ''; kdialog[k++] = ' '; kdialog[k++] = '\n';

                kdialog[k] = 0;

                kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
                switch (mode)
                {
                  case 0: kdiamode = VCERRDIALOG; break;
                  case 1: kdiamode = GCCERRDIALOG; break;
                  case 2: kdiamode = JAVERRDIALOG; break;
                }
                kdiafirstime = 1;
                kdiagets0 = kdiagets1 = 0; kdiacursor = -1;

                kdiaxsiz = xx+5; kdiaysiz = y-1;
                kdiagets0 = kdiaxsiz+2;
                kdiagets1 = kdiaxsiz+kdiaxsiz-3;
              }
            } else
            {
              switch(mode)
              {
                case 0: case 1:
nmakeerr:                  strcpy(kdialog,
                    " ͻ \n"\
                    "  Error with in-line makefile.  \n"\
                    "  To use this feature, format   \n"\
                    "  your program like this:       \n"\
                    " Ķ \n"\
                    "  #if 0 //C:\\>nmake -f a.c      \n"\
                    "  a.exe: a.c; cl a.c /nologo    \n"\
                    "  !if 0                         \n"\
                    "  #endif                        \n"\
                    "                                \n"\
                    "  #include <stdio.h>            \n"\
                    "  void main ()                  \n"\
                    "     { puts(\"hi\"); getch(); }   \n"\
                    "                                \n"\
                    "  #if 0                         \n"\
                    "  !endif                        \n"\
                    "  #endif                        \n"\
                    " ͼ \n");
                  break;
                case 2:
                  strcpy(kdialog,
                    " ͻ \n"\
                    "  Error: JAVA SDK not in path. F5 compile logic is:  \n"\
                    " Ķ \n"\
                    "  if (current file extension is .java)               \n"\
                    "  {                                                  \n"\
                    "     >javac.exe THIS.java                            \n"\
                    "     if (THIS.java begins with \"//<applet code=\")    \n"\
                    "          >appletviewer.exe THIS.java                \n"\
                    "     else >java.exe -cp [THIS path] THIS             \n"\
                    "  } else nmake ...                                   \n"\
                    " ͼ \n");
                  break;
              }
              kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
              kdiamode = INFODIALOG; kdiafirstime = 1;
              kdiagets0 = kdiagets1 = 0; kdiacursor = -1;
            }
#endif
            break;
          case 0x40: break; //F6
          case 0x2e: //C
#if defined(_WIN32) || defined(_WDL_SWELL_H_)
            if (key&0xc0000) //CTRL+C
            {
              if (selmode)
              {
                HANDLE hbuf;

                if ((sely0 < sely1) || ((sely0 == sely1) && (selx0 < selx1)))
                {
                  x1 = selx0; y1 = sely0;
                  x2 = selx1; y2 = sely1;
                } else
                {
                  x1 = selx1; y1 = sely1;
                  x2 = selx0; y2 = sely0;
                }
                if (y1 == y2)
                {
                  j = x2-x1;
                  if (OpenClipboard(ghwnd))
                  {
                    EmptyClipboard();
                    hbuf = GlobalAlloc(GMEM_MOVEABLE,j+1);
                    if (hbuf)
                    {
                      cptr = (char *)GlobalLock(hbuf);
                      memcpy(cptr,&buf[lineoffs[y1]+x1],j);
                      cptr[j] = 0;
                      GlobalUnlock(hbuf);
                      SetClipboardData(CF_TEXT,hbuf);
                    }
                    CloseClipboard();
                  }
                } else
                {
                  j = lineoffs[y2+1]-lineoffs[y1];
                  if (OpenClipboard(ghwnd))
                  {
                    EmptyClipboard();
                    hbuf = GlobalAlloc(GMEM_MOVEABLE,((y2+1-y1)<<1)+j+1);
                    if (hbuf)
                    {
                      cptr = (char *)GlobalLock(hbuf);
                      for(y=y1;y<=y2;y++)
                      {
                        for(x=lineoffs[y];x<lineoffs[y+1];x++) *cptr++ = buf[x];
                        *cptr++ = 13; *cptr++ = 10;
                      }
                      *cptr++ = 0;
                      GlobalUnlock(hbuf);
                      SetClipboardData(CF_TEXT,hbuf);
                    }
                    CloseClipboard();
                  }
                }

                //memcpy(buf2,&buf[lineoffs[y1]+x1],j);
                //numlines2 = 0;
                //for(i=y1;i<=y2;i++) lineoffs2[numlines2++] = lineoffs[i]-lineoffs[y1];
                //lineoffs2[numlines2] = j;
              }

              break;
            }
#endif
            break;
          case 0x43: //F9
            savecrlf ^= 1;
            break;
          case 0x44: //F10
            //if (key&0x300000) //ALT+F10
            //{
            //  kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+18;
            //  kdiamode = SETTABDIALOG; kdiafirstime = 1;
            //  kdiagets0 = 53; kdiagets1 = 62; kdiacursor = kdiagets0;
            //  strcpy(kdialog," ͻ \n"\
            //                 "  Set TAB (2-8):             \n"\
            //                 " ͼ \n");
            //  sprintf(&kdialog[kdiacursor],"%d",2);
            //  kdiacursor += strlen(&kdialog[kdiacursor]);
            //  kdialog[kdiacursor] = ' ';
            //  break;
            //}
            savetab2spc ^= 1;
            break;
          case 0x57: //F11
            break;
          case 0x58: //F12
#if defined(_WDL_SWELL_H_)
            if (key&0xc0000)
            {
              if (sleepstep >= 66) sleepstep = 1;
              else if (sleepstep == 1) sleepstep = 8;
              else if (sleepstep == 8) sleepstep = 16;
              else if (sleepstep == 16) sleepstep = 33;
              else if (sleepstep == 33) sleepstep = 66;
              break;
            }
#endif
            showfps ^= 1;
            break;
          case 0x2f: //V
#if defined(_WIN32) || defined(_WDL_SWELL_H_)
            if (key&0xc0000) //CTRL+V
            {
              HANDLE hbuf;
              if (
#if defined(_WIN32)
                (IsClipboardFormatAvailable(CF_TEXT)) &&
#endif
                (OpenClipboard(ghwnd)))
              {
                hbuf = GetClipboardData(CF_TEXT);
                if (hbuf)
                {
                  cptr = (char *)GlobalLock(hbuf);
                  if (cptr)
                  {

                    selmode = 0;

                    //x = number of valid chars in clipboard text
                    //k = number of lines in clipboard text
                    for(i=0,k=1,x=0;cptr[i];i++)
                    {
                      if (cptr[i] == 13) { k++; continue; }
                      if (cptr[i] == 10) continue;
                      if (cptr[i] == 9) { x += NUMTABSTOPS; continue; }
                      x++;
                    }
                    if (k == 1)
                    {
                      insertchar((int)getendpos(cury),cury,(int)max(curx-(lineoffs[cury+1]-lineoffs[cury]-1),1));
                      insertchar(curx,cury,x);
                      j = lineoffs[cury]+curx;
                      for(i=0;cptr[i];i++)
                      {
                        if ((cptr[i] != 13) && (cptr[i] != 10))
                        {
                          if (cptr[i] == 9) { for(yy=0;yy<NUMTABSTOPS;yy++) buf[j++] = 32; continue; }
                          buf[j++] = cptr[i];
                        }
                      }
                    } else if (k > 1)
                    {
                      j = lineoffs[cury];
                      rmemmove(&buf[lineoffs[numlines]+x],&buf[lineoffs[numlines]],lineoffs[numlines]-j);
                      for(i=numlines;i>=cury;i--) lineoffs[i+k] = lineoffs[i]+x;
                      for(i=0,xx=cury+1;cptr[i];i++)
                      {
                        if (cptr[i] == 13) { lineoffs[xx++] = j; } else
                        if (cptr[i] != 10)
                        {
                          if (cptr[i] == 9) { for(yy=0;yy<NUMTABSTOPS;yy++) buf[j++] = 32; continue; }
                          buf[j++] = cptr[i];
                        }
                      }
                      numlines += k;
                    }
                    GlobalUnlock(hbuf);
                    settitle(1);
                  }
                }
                CloseClipboard();
              }
              break;
            }
#endif
            break;
          case 0x22: //G
            if (key&0x300000) //ALT+G
            {
              kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
              kdiamode = GOTODIALOG; kdiafirstime = 1;
              kdiagets0 = 45; kdiagets1 = 53; kdiacursor = kdiagets0;
              strcpy(kdialog," ͻ \n"\
                             "  Goto line:             \n"\
                             " ͼ \n");
              sprintf(&kdialog[kdiacursor],"%d",cury+1);
              kdiacursor += strlen(&kdialog[kdiacursor]);
              kdialog[kdiacursor] = ' ';
              break;
            }
            break;
          case 0xd3: //Delete
            if ((selmode) && (selshape))
            {     //Box delete (not optimized: moves all text after cursor for each line deleted)
              backup(selx0,sely0,selx1,sely1,selshape);
              x1 = min(selx0,selx1); x2 = max(selx0,selx1)+1;
              y1 = min(sely0,sely1); y2 = max(sely0,sely1);
              for(y=y2;y>=y1;y--)
              {
                x = min(x2,lineoffs[y+1]-lineoffs[y]);
                if (x > x1) deletechar(x1,y,x-x1);
              }
            } else if ((sely0 != sely1) && (selmode) && (!selshape)) //Delete highlight if selected first
            {
              backup(selx0,sely0,selx1,sely1,selshape);
              y1 = min(sely0,sely1);
              y2 = max(sely0,sely1);
              deletechar(0L,y1,lineoffs[y2+1]-lineoffs[y1]);
              numlines -= (y2+1-y1);
              if (numlines <= 0)
              {
                numlines = 1; lineoffs[0] = lineoffs[1] = lineoffs[2] = 0;
                curx = 0; cury = 0;
              } else
              {
                for(i=y1;i<=numlines;i++) lineoffs[i] = lineoffs[i+(y2+1-y1)];
                cury = min(y1,numlines-1);
                curx = gethomepos(cury);
              }
            } else if ((selx0 != selx1) && (selmode) && (!selshape))
            {
              backup(selx0,sely0,selx1,sely1,selshape);
              x1 = min(selx0,selx1);
              x2 = max(selx0,selx1);
              y1 = lineoffs[sely0+1]-lineoffs[sely0];
              x1 = min(max(x1,0),y1);
              x2 = min(max(x2,0),y1);
              if (x2 > x1) { deletechar(x1,cury,x2-x1); curx = x1; }
            } else
            {
              i = getendpos(cury);
              if (curx >= i)
              {
                if (cury < numlines-1)
                {
                  insertchar(curx,cury,curx-(lineoffs[cury+1]-lineoffs[cury]-1));
                  deletechar(curx,cury,1L);
                  i = gethomepos(cury+1);
                  if ((i == 0) && (buf[lineoffs[cury+1]] == 32))
                    i = getendpos(cury+1);
                  deletechar(0L,cury+1,i);
                  for(i=cury+1;i<numlines;i++) lineoffs[i] = lineoffs[i+1];
                  numlines--;
                }
              } else { deletechar(curx,cury,1L); }
            }
            selmode = 0;
            settitle(1);
            break;
          case 0xd2: //Insert
            if (key&0xc0000) //CTRL+Ins
            {
              if (selmode) backup(selx0,sely0,selx1,sely1,selshape); else
                       backup(0,0,0,0,0);
              break;
            }
            if (shiftstat&3) //Shift+Ins
            {
              selmode = 0;
              if (!selshapesave2)
              {
                if (numlines2 == 1)
                {
                  insertchar((int)getendpos(cury),cury,(int)max(curx-(lineoffs[cury+1]-lineoffs[cury]-1),1));
                  insertchar(curx,cury,lineoffs2[numlines2]);
                  j = lineoffs[cury]+curx;
                  memcpy(&buf[j],&buf2[0],lineoffs2[numlines2]);
                } else if (numlines2 > 1)
                {
                  j = lineoffs[cury];
                  rmemmove(&buf[lineoffs[numlines]+lineoffs2[numlines2]],&buf[lineoffs[numlines]],lineoffs[numlines]-j);
                  memcpy(&buf[j],&buf2[0],lineoffs2[numlines2]);
                  for(i=numlines;i>=cury;i--) lineoffs[i+numlines2] = lineoffs[i]+lineoffs2[numlines2];
                  for(i=1;i<numlines2;i++) lineoffs[i+cury] = lineoffs2[i]+j;
                  numlines += numlines2;
                }
              } else
              {     //Box insert (not optimized: moves all text after cursor for each line inserted)
                for(y=0;y<numlines2;y++)
                {
                  if (cury+y >= numlines) //Insert line at end of file if necessary
                    { lineoffs[numlines+1] = lineoffs[numlines]; numlines++; }
                  insertchar((int)getendpos(cury+y),cury+y,(int)max(curx-(lineoffs[cury+y+1]-lineoffs[cury+y]-1),1));
                  insertchar(curx,cury+y,lineoffs2[1]);
                  memcpy(&buf[lineoffs[cury+y]+curx],&buf2[lineoffs2[y]],lineoffs2[1]);
                }
              }
              settitle(1);
            } else { insertmode ^= 1; }
            break;
          case 0x1a: //[
            if (key&0x300000) //ALT+[
            {
              shifttextleft(sely0,sely1,NUMTABSTOPS,0); settitle(1); break;
            }
            break;
          case 0x1b: //]
            if (key&0x300000) //ALT+]
            {
              shifttextright(sely0,sely1,NUMTABSTOPS); settitle(1); break;
            }
            break;
          case 0x1f: //S
            if (key&0x300000) //ALT+S
            {
              kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
              kdiamode = SEARCHDIALOG; kdiafirstime = 1;
              kdiagets0 = kdiagets1 = 0; kdiacursor = -1;
              strcpy(kdialog," ͻ \n"\
                             "  \rFind        \n"\
                             "  \rChange      \n"\
                             "  \rE\rS\rC-cancel  \n"\
                             " ͼ \n");
              break;
            }
            break;
          case 0x21: //F
            if (key&0x300000) //ALT+F
            {
              kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
              kdiamode = FILEDIALOG; kdiafirstime = 1;
              kdiagets0 = kdiagets1 = 0; kdiacursor = -1;
              strcpy(kdialog," ͻ \n"\
                             "  \rNew         \n"\
                             "  \rOpen        \n"\
                             "  \rSave        \n"\
                             "  Save \ras     \n"\
                             "  E\rxit        \n"\
                             "  \rE\rS\rC-cancel  \n"\
                             " ͼ \n");
              break;
            }
            break;
          case 0x24: //J
            if (key&0x300000) //ALT+J
              { showlinelengthmode ^= 1; break; }
            break;
          case 0x25: //K
            if (key&0x300000) //ALT+K
              { spookymode ^= 1; break; }
            break;
          case 0x26: //L
            if (key&0x300000) //ALT+L (line-draw mode)
            {
              if (!linedrawmode)
              {
                kdiacol = (3<<4)+0; kdiacol2 = (3<<4)+14;
                kdiamode = LINEDRAWDIALOG; kdiafirstime = 1;
                kdiagets0 = kdiagets1 = 0; kdiacursor = -1;
                strcpy(kdialog," ͻ \n"\
                               "   Pick a line-draw mode   \n"\
                               " Ķ \n"\
                               "    Ŀ ķ    \n"\
                               "     1  1   2  2     \n"\
                               "    Ĵ Ķ    \n"\
                               "     1  1   2  2     \n"\
                               "     Ľ    \n"\
                               "    ͸ ͻ    \n"\
                               "     3  3   4  4     \n"\
                               "    ͵ ͹    \n"\
                               "     3  3   4  4     \n"\
                               "    ; ͼ    \n"\
                               " ͼ \n");
              } else linedrawmode = 0;
              break;
            }
            break;
          case 0x52: case 0x4f: case 0x50: case 0x51: case 0x4b: //KP#'s for ALT+### sequences
          case 0x4c: case 0x4d: case 0x47: case 0x48: case 0x49:
            if (key&0x300000) //ALT+KP#
            {
              if (altkpcharstat < 0) altkpcharstat = 0;
              altkpcharstat = altkpcharstat*10+altkpcharadd[((key>>8)&255)-0x47];
            }
            break;
        }
      }
    }
    deleteendspace(cury);

doframe_ret:;
    if (scrolled) { scrolled = 0; i = 10; } else i = 128;
#if defined(_WIN32)
    MsgWaitForMultipleObjects(0,0,0,i,QS_KEY|QS_MOUSE|QS_PAINT); //smartsleep
#else
    Sleep(sleepstep);
    if (reqquit) break;
#endif

    obstatus = bstatus;
  }
#if defined(_WIN32)
  timeEndPeriod(1);
#endif

  if (buf) { free(buf); buf = 0; }
  uninitapp();
  return(0);
}
