!include "MUI2.nsh"
!include "LogicLib.nsh"

;Unicode true

;SetCompress off
SetCompressor zlib
;SetCompressor /solid LZMA
;SetCompressorDictSize 8
;RequestExecutionLevel highest
RequestExecutionLevel admin

;!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\nsis3-install-alt.ico"
;!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\nsis3-uninstall.ico"
;!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\nsis3-metro.bmp"
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\orange.bmp"
!define MUI_COMPONENTSPAGE_NODESC
!define MUI_FINISHPAGE_NOAUTOCLOSE

!searchparse /file ..\src\markella\app_info.h '#define MAR_MAJOR_VERSION ' MAJOR
!searchparse /file ..\src\markella\app_info.h '#define MAR_MINOR_VERSION ' MINOR
!searchparse /file ..\src\markella\app_info.h '#define MAR_RELEASE "' RELEASE '"'
!searchparse /file ..\src\markella\app_info.h '#define MAR_COPYRIGHT "' COPYRIGHT '"'
!searchparse /file ..\src\markella\app_info.h '#define MAR_COMPANY_URL "' COMPANY '"'

Name "Markella"
OutFile "markella-${MAJOR}.${MINOR}${RELEASE}-x86-install.exe"
;BrandingText "Grafmin"

VIAddVersionKey "ProductName" "Markella"
VIAddVersionKey "CompanyName" "${COMPANY}"
VIAddVersionKey "FileDescription" "Markella installer (x86)"
VIAddVersionKey "FileVersion" "${MAJOR}.${MINOR}.0.0"
VIAddVersionKey "ProductVersion" "${MAJOR}.${MINOR}"
VIAddVersionKey "LegalCopyright" "${COPYRIGHT}"
VIProductVersion "${MAJOR}.${MINOR}.0.0"

InstallDir "$PROGRAMFILES32\Markella"

;Get installation folder from registry if available
InstallDirRegKey HKCU "Software\Markella (x86)" ""

!define MUI_ABORTWARNING
!define MUI_FINISHPAGE_RUN $INSTDIR\markella.exe

!insertmacro MUI_PAGE_LICENSE "..\doc\license.txt"
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
;AutoCloseWindow true

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

!insertmacro MUI_LANGUAGE "English"

Section "Markella" SecMarkella
  SectionIn RO

  SetOutPath "$INSTDIR"

  File "..\build\vc\Win32\Release\markella.exe"
  ;File "..\build\vc\Win32\Release\*.dll"
  File "..\build\vc\Win32\Release\changelog.txt"
  File "..\build\vc\Win32\Release\license.txt"
  File "..\build\vc\Win32\Release\documentation.txt"

  ;SetOutPath "$INSTDIR\ext"
  ;File /r "..\build\vc\Win32\Release\ext\*.dll"

  SetOutPath "$INSTDIR\skin"
  File /r "..\build\vc\Win32\Release\skin\*.*"

  ;Store installation folder
  WriteRegStr HKCU "Software\Markella (x86)" "" $INSTDIR

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\uninstall.exe"
SectionEnd

Section "Start menu shortcuts" SecStart
  SetOutPath "$SMPROGRAMS\Markella (x86)"
  CreateShortcut "$OUTDIR\Markella (x86).lnk" "$INSTDIR\markella.exe"
  CreateShortcut "$OUTDIR\Uninstall Markella (x86).lnk" "$INSTDIR\uninstall.exe"
SectionEnd

Section "Context menu entry (File Explorer)" SecContext
  WriteRegStr HKCR "*\shell\Markella (x86)" "" "Edit with &Markella (x86)"
  WriteRegStr HKCR "*\shell\Markella (x86)\command" "" '"$INSTDIR\markella.exe" "%1"'
SectionEnd

Section /o "Desktop icon" SecDesktop
  SetOutPath $DESKTOP
  CreateShortcut "$OUTDIR\Markella (x86).lnk" "$INSTDIR\markella.exe"
SectionEnd

;Language strings
LangString DESC_SecMarkella ${LANG_ENGLISH} "Markella core (required)."
LangString DESC_SecStart ${LANG_ENGLISH} "Start menu shortcuts."
LangString DESC_SecDesktop ${LANG_ENGLISH} "Desktop icon."

;Assign language strings to sections
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SecMarkella} $(DESC_SecMarkella)
!insertmacro MUI_DESCRIPTION_TEXT ${SecStart} $(DESC_SecStart)
!insertmacro MUI_DESCRIPTION_TEXT ${SecDesktop} $(DESC_SecDesktop)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"
  StrCpy $1 "markella.exe"

retry:
  nsProcess::_FindProcess "$1"

  Pop $R0
  ${if} $R0 = 0
    MessageBox MB_RETRYCANCEL "Markella is running. Close Markella and hit Retry." /SD IDRETRY IDCANCEL cancel
    Goto retry
  ${endif}

  Delete "$DESKTOP\Markella (x86).lnk"
  Delete "$SMPROGRAMS\Markella (x86)\Markella (x86).lnk"
  Delete "$SMPROGRAMS\Markella (x86)\Uninstall Markella (x86).lnk"
  RMDir /r "$SMPROGRAMS\Markella (x86)"

  Delete "$INSTDIR\markella.exe"
  Delete "$INSTDIR\*.dll"
  Delete "$INSTDIR\changelog.txt"
  Delete "$INSTDIR\license.txt"
  Delete "$INSTDIR\documentation.txt"
  RMDir /r "$INSTDIR\ext"
  RMDir /r "$INSTDIR\skin"
  Delete "$INSTDIR\uninstall.exe"
  RMDir "$INSTDIR"

  DeleteRegKey /ifempty HKCU "Software\Markella (x86)"
  DeleteRegKey HKCR "*\shell\Markella (x86)"

  Goto cont

cancel:
  Abort

cont:
SectionEnd
