// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_ABOUT_WND_H_
#define _MARKELLA_ABOUT_WND_H_

#include "definitions.h"
#include "app_info.h"

#include <string.h>
#include <stdlib.h>

#include <WDL/heapbuf.h>
#include <WDL/wdlstring.h>
#include <WDL/wingui/wndsize.h>
#include <WDL/lice/lice.h>
#include <WDL/lice/lice_text.h>

class MAR_AboutWnd
{
public:
  MAR_AboutWnd()
    : m_hwnd(NULL)
    , m_x(0)
    , m_y(0)
    , m_w(0)
    , m_h(0)
    , m_bm(NULL)
    , m_font(NULL)
    , m_fontalpha(255)
    , m_scrolloffsety(0)
    , m_creditsheight(0)
    , m_calc(true)
  {}

  ~MAR_AboutWnd()
  {
    if (m_bm) delete m_bm;
    if (m_font) delete m_font;
  }

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET AboutWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  INT_PTR OnClose(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void DoPaint(HDC dc);
  int Run();
  WDL_DLGRET AboutWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  int m_x, m_y, m_w, m_h;
  WDL_WndSizer m_resize;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  int m_fontalpha;
  int m_scrolloffsety;
  int m_creditsheight;
  bool m_calc;
  WDL_TypedBuf<int> m_emptystring;
};

#endif // _MARKELLA_ABOUT_WND_H_
